/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventprocessorhost.AzureStorageCheckpointLeaseManager;
import com.microsoft.azure.eventprocessorhost.AzureStoragePartitionManagerOptions;
import com.microsoft.azure.eventprocessorhost.DefaultEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.EventProcessorOptions;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.IEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.eventprocessorhost.PartitionManager;
import com.microsoft.azure.eventprocessorhost.PartitionManagerOptions;
import com.microsoft.azure.storage.StorageException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventProcessorHost {
    private final String hostName;
    private final String eventHubPath;
    private final String consumerGroupName;
    private String eventHubConnectionString;
    private ICheckpointManager checkpointManager;
    private ILeaseManager leaseManager;
    private boolean initializeLeaseManager = false;
    private boolean unregistered = false;
    private PartitionManager partitionManager;
    private IEventProcessorFactory<?> processorFactory = null;
    private EventProcessorOptions processorOptions;
    private PartitionManagerOptions partitionManagerOptions = null;
    private final ExecutorService executorService;
    private final boolean weOwnExecutor;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(EventProcessorHost.class);
    private static final Object uuidSynchronizer = new Object();

    @Deprecated
    public EventProcessorHost(String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString) {
        this(EventProcessorHost.createHostName(null), eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString);
    }

    @Deprecated
    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, new AzureStorageCheckpointLeaseManager(storageConnectionString), (ExecutorService)null);
        this.initializeLeaseManager = true;
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString, storageContainerName, (ExecutorService)null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName, ExecutorService executorService) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString, storageContainerName, null, executorService);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName, String storageBlobPrefix) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString, storageContainerName, storageBlobPrefix, null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName, String storageBlobPrefix, ExecutorService executorService) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, new AzureStorageCheckpointLeaseManager(storageConnectionString, storageContainerName, storageBlobPrefix), executorService);
        this.initializeLeaseManager = true;
        this.partitionManagerOptions = new AzureStoragePartitionManagerOptions();
    }

    private EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, AzureStorageCheckpointLeaseManager combinedManager, ExecutorService executorService) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, combinedManager, combinedManager, executorService);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, ICheckpointManager checkpointManager, ILeaseManager leaseManager) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, checkpointManager, leaseManager, null);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, ICheckpointManager checkpointManager, ILeaseManager leaseManager, ExecutorService executorService) {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName argument must not be null or empty string");
        }
        if (consumerGroupName == null || consumerGroupName.isEmpty()) {
            throw new IllegalArgumentException("consumerGroupName argument must not be null or empty");
        }
        if (eventHubConnectionString == null || eventHubConnectionString.isEmpty()) {
            throw new IllegalArgumentException("eventHubConnectionString argument must not be null or empty");
        }
        ConnectionStringBuilder providedCSB = new ConnectionStringBuilder(eventHubConnectionString);
        String extractedEntityPath = providedCSB.getEntityPath();
        this.eventHubConnectionString = eventHubConnectionString;
        if (eventHubPath != null && !eventHubPath.isEmpty()) {
            this.eventHubPath = eventHubPath;
            if (extractedEntityPath != null) {
                if (eventHubPath.compareTo(extractedEntityPath) != 0) {
                    throw new IllegalArgumentException("Provided EventHub path in eventHubPath parameter conflicts with the path in provided EventHub connection string");
                }
            } else {
                ConnectionStringBuilder rebuildCSB = new ConnectionStringBuilder(providedCSB.getEndpoint(), this.eventHubPath, providedCSB.getSasKeyName(), providedCSB.getSasKey());
                rebuildCSB.setOperationTimeout(providedCSB.getOperationTimeout());
                rebuildCSB.setRetryPolicy(providedCSB.getRetryPolicy());
                this.eventHubConnectionString = rebuildCSB.toString();
            }
        } else if (extractedEntityPath != null && !extractedEntityPath.isEmpty()) {
            this.eventHubPath = extractedEntityPath;
        } else {
            throw new IllegalArgumentException("Provide EventHub entity path in either eventHubPath argument or in eventHubConnectionString");
        }
        if (checkpointManager == null) {
            throw new IllegalArgumentException("Must provide an object which implements ICheckpointManager");
        }
        if (leaseManager == null) {
            throw new IllegalArgumentException("Must provide an object which implements ILeaseManager");
        }
        if (this.partitionManagerOptions == null) {
            this.partitionManagerOptions = new PartitionManagerOptions();
        }
        this.hostName = hostName;
        this.consumerGroupName = consumerGroupName;
        this.checkpointManager = checkpointManager;
        this.leaseManager = leaseManager;
        if (executorService != null) {
            this.weOwnExecutor = false;
            this.executorService = executorService;
        } else {
            this.weOwnExecutor = true;
            this.executorService = Executors.newCachedThreadPool();
        }
        this.partitionManager = new PartitionManager(this);
        TRACE_LOGGER.info(LoggingUtils.withHost(this.hostName, "New EventProcessorHost created."));
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getEventHubConnectionString() {
        return this.eventHubConnectionString;
    }

    void setPartitionManager(PartitionManager pm) {
        this.partitionManager = pm;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    ICheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    ILeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    IEventProcessorFactory<?> getProcessorFactory() {
        return this.processorFactory;
    }

    String getEventHubPath() {
        return this.eventHubPath;
    }

    String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    EventProcessorOptions getEventProcessorOptions() {
        return this.processorOptions;
    }

    public PartitionManagerOptions getPartitionManagerOptions() {
        return this.partitionManagerOptions;
    }

    public void setPartitionManagerOptions(PartitionManagerOptions options) {
        this.partitionManagerOptions = options;
    }

    public <T extends IEventProcessor> Future<?> registerEventProcessor(Class<T> eventProcessorType) throws Exception {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, EventProcessorOptions.getDefaultOptions());
    }

    public <T extends IEventProcessor> Future<?> registerEventProcessor(Class<T> eventProcessorType, EventProcessorOptions processorOptions) throws Exception {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, processorOptions);
    }

    public Future<?> registerEventProcessorFactory(IEventProcessorFactory<?> factory) throws Exception {
        return this.registerEventProcessorFactory(factory, EventProcessorOptions.getDefaultOptions());
    }

    public Future<?> registerEventProcessorFactory(IEventProcessorFactory<?> factory, EventProcessorOptions processorOptions) throws Exception {
        if (this.unregistered) {
            throw new IllegalStateException("Register cannot be called on an EventProcessorHost after unregister. Please create a new EventProcessorHost instance.");
        }
        if (this.processorFactory != null) {
            throw new IllegalStateException("Register has already been called on this EventProcessorHost");
        }
        if (this.executorService.isShutdown() || this.executorService.isTerminated()) {
            TRACE_LOGGER.warn(LoggingUtils.withHost(this.hostName, "Calling registerEventProcessor/Factory after executor service has been shut down."));
            throw new RejectedExecutionException("EventProcessorHost executor service has been shut down");
        }
        if (this.initializeLeaseManager) {
            try {
                ((AzureStorageCheckpointLeaseManager)this.leaseManager).initialize(this);
            }
            catch (StorageException | URISyntaxException | InvalidKeyException e) {
                TRACE_LOGGER.warn(LoggingUtils.withHost(this.hostName, "Failure initializing Storage lease manager."));
                throw new RuntimeException("Failure initializing Storage lease manager", e);
            }
        }
        TRACE_LOGGER.info(LoggingUtils.withHost(this.hostName, "Starting event processing."));
        this.processorFactory = factory;
        this.processorOptions = processorOptions;
        return this.executorService.submit(() -> this.partitionManager.initialize());
    }

    public void unregisterEventProcessor() throws InterruptedException, ExecutionException {
        TRACE_LOGGER.info(LoggingUtils.withHost(this.hostName, "Stopping event processing"));
        this.unregistered = true;
        if (this.partitionManager != null) {
            try {
                Future<?> stoppingPartitions = this.partitionManager.stopPartitions();
                if (stoppingPartitions != null) {
                    stoppingPartitions.get();
                }
                if (this.weOwnExecutor) {
                    this.executorService.awaitTermination(10L, TimeUnit.MINUTES);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                TRACE_LOGGER.warn(LoggingUtils.withHost(this.hostName, "Failure shutting down"), (Throwable)e);
                throw e;
            }
        }
    }

    void stopExecutor() {
        if (this.weOwnExecutor) {
            this.executorService.shutdown();
        }
    }

    @Deprecated
    public static void setAutoExecutorShutdown(boolean auto) {
    }

    @Deprecated
    public static void forceExecutorShutdown(long secondsToWait) throws InterruptedException {
    }

    public static String createHostName(String prefix) {
        String usePrefix = prefix;
        if (usePrefix == null || usePrefix.isEmpty()) {
            usePrefix = "javahost";
        }
        return usePrefix + "-" + EventProcessorHost.safeCreateUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String safeCreateUUID() {
        Object object = uuidSynchronizer;
        synchronized (object) {
            UUID newUuid = UUID.randomUUID();
            return new String(newUuid.toString());
        }
    }
}

