/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCheckpointManager
implements ICheckpointManager {
    private EventProcessorHost host;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(InMemoryCheckpointManager.class);

    public void initialize(EventProcessorHost host) {
        this.host = host;
    }

    @Override
    public Future<Boolean> checkpointStoreExists() {
        return this.executor.submit(() -> this.checkpointStoreExistsSync());
    }

    private Boolean checkpointStoreExistsSync() {
        return InMemoryCheckpointStore.singleton.existsMap();
    }

    @Override
    public Future<Boolean> createCheckpointStoreIfNotExists() {
        return this.executor.submit(() -> this.createCheckpointStoreIfNotExistsSync());
    }

    private Boolean createCheckpointStoreIfNotExistsSync() {
        InMemoryCheckpointStore.singleton.initializeMap();
        return true;
    }

    @Override
    public Future<Boolean> deleteCheckpointStore() {
        return this.executor.submit(() -> this.deleteCheckpointStoreSync());
    }

    private Boolean deleteCheckpointStoreSync() {
        InMemoryCheckpointStore.singleton.deleteMap();
        return true;
    }

    @Override
    public Future<Checkpoint> getCheckpoint(String partitionId) {
        return this.executor.submit(() -> this.getCheckpointSync(partitionId));
    }

    private Checkpoint getCheckpointSync(String partitionId) {
        Checkpoint returnCheckpoint = null;
        Checkpoint checkpointInStore = InMemoryCheckpointStore.singleton.getCheckpoint(partitionId);
        if (checkpointInStore == null) {
            TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "getCheckpoint() no existing Checkpoint"));
            returnCheckpoint = null;
        } else {
            returnCheckpoint = checkpointInStore.getSequenceNumber() == -1L ? null : new Checkpoint(checkpointInStore);
        }
        return returnCheckpoint;
    }

    @Override
    public Future<Checkpoint> createCheckpointIfNotExists(String partitionId) {
        return this.executor.submit(() -> this.createCheckpointIfNotExistsSync(partitionId));
    }

    private Checkpoint createCheckpointIfNotExistsSync(String partitionId) {
        Checkpoint checkpointInStore = InMemoryCheckpointStore.singleton.getCheckpoint(partitionId);
        Checkpoint returnCheckpoint = null;
        if (checkpointInStore != null) {
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "createCheckpointIfNotExists() found existing checkpoint, OK"));
            returnCheckpoint = checkpointInStore.getSequenceNumber() != -1L ? new Checkpoint(checkpointInStore) : null;
        } else {
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "createCheckpointIfNotExists() creating new checkpoint"));
            Checkpoint newStoreCheckpoint = new Checkpoint(partitionId);
            newStoreCheckpoint.setOffset(null);
            newStoreCheckpoint.setSequenceNumber(-1L);
            InMemoryCheckpointStore.singleton.setOrReplaceCheckpoint(newStoreCheckpoint);
            returnCheckpoint = null;
        }
        return returnCheckpoint;
    }

    @Override
    @Deprecated
    public Future<Void> updateCheckpoint(Checkpoint checkpoint) {
        return null;
    }

    @Override
    public Future<Void> updateCheckpoint(Lease lease, Checkpoint checkpoint) {
        return this.executor.submit(() -> this.updateCheckpointSync(checkpoint.getPartitionId(), checkpoint.getOffset(), checkpoint.getSequenceNumber()));
    }

    private Void updateCheckpointSync(String partitionId, String offset, long sequenceNumber) {
        Checkpoint checkpointInStore = InMemoryCheckpointStore.singleton.getCheckpoint(partitionId);
        if (checkpointInStore != null) {
            checkpointInStore.setOffset(offset);
            checkpointInStore.setSequenceNumber(sequenceNumber);
        } else {
            TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), partitionId, "updateCheckpoint() can't find checkpoint"));
        }
        return null;
    }

    @Override
    public Future<Void> deleteCheckpoint(String partitionId) {
        return this.executor.submit(() -> this.deleteCheckpointSync(partitionId));
    }

    private Void deleteCheckpointSync(String partitionId) {
        InMemoryCheckpointStore.singleton.removeCheckpoint(partitionId);
        return null;
    }

    private static class InMemoryCheckpointStore {
        static final InMemoryCheckpointStore singleton = new InMemoryCheckpointStore();
        private ConcurrentHashMap<String, Checkpoint> inMemoryCheckpointsPrivate = null;

        private InMemoryCheckpointStore() {
        }

        synchronized boolean existsMap() {
            return this.inMemoryCheckpointsPrivate != null;
        }

        synchronized void initializeMap() {
            if (this.inMemoryCheckpointsPrivate == null) {
                this.inMemoryCheckpointsPrivate = new ConcurrentHashMap();
            }
        }

        synchronized void deleteMap() {
            this.inMemoryCheckpointsPrivate = null;
        }

        synchronized Checkpoint getCheckpoint(String partitionId) {
            return this.inMemoryCheckpointsPrivate.get(partitionId);
        }

        synchronized void setOrReplaceCheckpoint(Checkpoint newCheckpoint) {
            this.inMemoryCheckpointsPrivate.put(newCheckpoint.getPartitionId(), newCheckpoint);
        }

        synchronized void removeCheckpoint(String partitionId) {
            this.inMemoryCheckpointsPrivate.remove(partitionId);
        }
    }
}

