/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.ReceiverRuntimeInformation;
import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionContext {
    private final EventProcessorHost host;
    private final String partitionId;
    private final String eventHubPath;
    private final String consumerGroupName;
    private Lease lease;
    private String offset = "-1";
    private long sequenceNumber = 0L;
    private ReceiverRuntimeInformation runtimeInformation;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(PartitionContext.class);

    PartitionContext(EventProcessorHost host, String partitionId, String eventHubPath, String consumerGroupName) {
        this.host = host;
        this.partitionId = partitionId;
        this.eventHubPath = eventHubPath;
        this.consumerGroupName = consumerGroupName;
        this.runtimeInformation = new ReceiverRuntimeInformation(partitionId);
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public String getEventHubPath() {
        return this.eventHubPath;
    }

    public String getOwner() {
        return this.lease.getOwner();
    }

    public ReceiverRuntimeInformation getRuntimeInformation() {
        return this.runtimeInformation;
    }

    void setRuntimeInformation(ReceiverRuntimeInformation value) {
        this.runtimeInformation = value;
    }

    Lease getLease() {
        return this.lease;
    }

    void setLease(Lease lease) {
        this.lease = lease;
    }

    void setOffsetAndSequenceNumber(EventData event) {
        if (this.sequenceNumber >= this.sequenceNumber) {
            this.offset = event.getSystemProperties().getOffset();
            this.sequenceNumber = event.getSystemProperties().getSequenceNumber();
        } else {
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionId, "setOffsetAndSequenceNumber(" + event.getSystemProperties().getOffset() + "//" + event.getSystemProperties().getSequenceNumber() + ") would move backwards, ignoring"));
        }
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getInitialOffset() throws InterruptedException, ExecutionException {
        Object startAt = null;
        Checkpoint startingCheckpoint = this.host.getCheckpointManager().getCheckpoint(this.partitionId).get();
        if (startingCheckpoint == null) {
            Function<String, Object> initialOffsetProvider = this.host.getEventProcessorOptions().getInitialOffsetProvider();
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionId, "Calling user-provided initial offset provider"));
            startAt = initialOffsetProvider.apply(this.partitionId);
            if (startAt instanceof String) {
                this.offset = (String)startAt;
                this.sequenceNumber = 0L;
                TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionId, "Initial offset provided: " + this.offset + "//" + this.sequenceNumber));
                return startAt;
            } else {
                if (!(startAt instanceof Instant)) throw new IllegalArgumentException("Unexpected object type returned by user-provided initialOffsetProvider");
                TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionId, "Initial timestamp provided: " + (Instant)startAt));
            }
            return startAt;
        } else {
            this.offset = startingCheckpoint.getOffset();
            startAt = this.offset;
            this.sequenceNumber = startingCheckpoint.getSequenceNumber();
            TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionId, "Retrieved starting offset " + this.offset + "//" + this.sequenceNumber));
        }
        return startAt;
    }

    public void checkpoint() throws IllegalArgumentException, InterruptedException, ExecutionException {
        Checkpoint capturedCheckpoint = new Checkpoint(this.partitionId, this.offset, this.sequenceNumber);
        this.persistCheckpoint(capturedCheckpoint);
    }

    public void checkpoint(EventData event) throws IllegalArgumentException, InterruptedException, ExecutionException {
        this.persistCheckpoint(new Checkpoint(this.partitionId, event.getSystemProperties().getOffset(), event.getSystemProperties().getSequenceNumber()));
    }

    private void persistCheckpoint(Checkpoint persistThis) throws IllegalArgumentException, InterruptedException, ExecutionException {
        TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), persistThis.getPartitionId(), "Saving checkpoint: " + persistThis.getOffset() + "//" + persistThis.getSequenceNumber()));
        this.host.getCheckpointManager().updateCheckpoint(this.lease, persistThis).get();
    }
}

