/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.eventprocessorhost.PartitionPumpStatus;
import com.microsoft.azure.eventprocessorhost.Pump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PartitionPump {
    protected final EventProcessorHost host;
    protected final Pump pump;
    protected Lease lease = null;
    protected PartitionPumpStatus pumpStatus = PartitionPumpStatus.PP_UNINITIALIZED;
    protected IEventProcessor processor = null;
    protected PartitionContext partitionContext = null;
    protected final Object processingSynchronizer;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(PartitionPump.class);

    PartitionPump(EventProcessorHost host, Pump pump, Lease lease) {
        this.host = host;
        this.pump = pump;
        this.lease = lease;
        this.processingSynchronizer = new Object();
    }

    void setLease(Lease newLease) {
        this.partitionContext.setLease(newLease);
    }

    Void startPump() {
        this.pumpStatus = PartitionPumpStatus.PP_OPENING;
        this.partitionContext = new PartitionContext(this.host, this.lease.getPartitionId(), this.host.getEventHubPath(), this.host.getConsumerGroupName());
        this.partitionContext.setLease(this.lease);
        if (this.pumpStatus == PartitionPumpStatus.PP_OPENING) {
            String action = "Creating Event Processor";
            try {
                this.processor = this.host.getProcessorFactory().createEventProcessor(this.partitionContext);
                action = "Opening Event Processor";
                this.processor.onOpen(this.partitionContext);
            }
            catch (Exception e) {
                this.processor = null;
                TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionContext, "Failed " + action), (Throwable)e);
                this.host.getEventProcessorOptions().notifyOfException(this.host.getHostName(), e, action, this.lease.getPartitionId());
                this.pumpStatus = PartitionPumpStatus.PP_OPENFAILED;
            }
        }
        if (this.pumpStatus == PartitionPumpStatus.PP_OPENING) {
            this.specializedStartPump();
        }
        if (this.pumpStatus != PartitionPumpStatus.PP_RUNNING) {
            this.pumpStatus = PartitionPumpStatus.PP_CLOSING;
            try {
                this.processor.onClose(this.partitionContext, CloseReason.Shutdown);
            }
            catch (Exception e) {
                TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionContext, "Failed Closing Event Processor"), (Throwable)e);
                this.host.getEventProcessorOptions().notifyOfException(this.host.getHostName(), e, "Closing Event Processor", this.lease.getPartitionId());
            }
            this.processor = null;
            this.pumpStatus = PartitionPumpStatus.PP_CLOSED;
        }
        return null;
    }

    abstract void specializedStartPump();

    PartitionPumpStatus getPumpStatus() {
        return this.pumpStatus;
    }

    Boolean isClosing() {
        return this.pumpStatus == PartitionPumpStatus.PP_CLOSING || this.pumpStatus == PartitionPumpStatus.PP_CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(CloseReason reason) {
        Object object = this.pumpStatus;
        synchronized (object) {
            if (this.isClosing().booleanValue()) {
                return;
            }
            this.pumpStatus = PartitionPumpStatus.PP_CLOSING;
        }
        TRACE_LOGGER.info(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionContext, "pump shutdown for reason " + reason.toString()));
        this.specializedShutdown(reason);
        if (this.processor != null) {
            try {
                object = this.processingSynchronizer;
                synchronized (object) {
                    this.processor.onClose(this.partitionContext, reason);
                }
            }
            catch (Exception e) {
                TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionContext, "Failure closing processor"), (Throwable)e);
                this.host.getEventProcessorOptions().notifyOfException(this.host.getHostName(), e, "Closing Event Processor", this.lease.getPartitionId());
            }
        }
        if (reason != CloseReason.LeaseLost) {
            this.host.getLeaseManager().releaseLease(this.partitionContext.getLease());
        }
        this.pumpStatus = PartitionPumpStatus.PP_CLOSED;
    }

    abstract void specializedShutdown(CloseReason var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvents(Iterable<EventData> events) {
        Object blah;
        if (events != null) {
            blah = events.iterator();
            EventData last = null;
            while (blah.hasNext()) {
                last = (EventData)blah.next();
            }
            if (last != null) {
                this.partitionContext.setOffsetAndSequenceNumber(last);
            }
        }
        try {
            blah = this.processingSynchronizer;
            synchronized (blah) {
                this.processor.onEvents(this.partitionContext, events);
            }
        }
        catch (Exception e) {
            TRACE_LOGGER.warn(LoggingUtils.withHostAndPartition(this.host.getHostName(), this.partitionContext, "Got exception from onEvents"), (Throwable)e);
        }
    }

    protected Void onError(Throwable error) {
        this.processor.onError(this.partitionContext, error);
        this.pump.onPumpError(this.partitionContext.getPartitionId());
        return null;
    }
}

