/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.Lease;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.LeaseState;

class AzureBlobLease
extends Lease {
    private transient CloudBlockBlob blob;
    private String offset = "-1";
    private long sequenceNumber = 0L;

    AzureBlobLease(String partitionId, CloudBlockBlob blob) {
        super(partitionId);
        this.blob = blob;
    }

    AzureBlobLease(AzureBlobLease source) {
        super(source);
        this.offset = source.offset;
        this.sequenceNumber = source.sequenceNumber;
        this.blob = source.blob;
    }

    AzureBlobLease(AzureBlobLease source, CloudBlockBlob blob) {
        super(source);
        this.offset = source.offset;
        this.sequenceNumber = source.sequenceNumber;
        this.blob = blob;
    }

    AzureBlobLease(Lease source, CloudBlockBlob blob) {
        super(source);
        this.blob = blob;
    }

    CloudBlockBlob getBlob() {
        return this.blob;
    }

    void setOffset(String offset) {
        this.offset = offset;
    }

    String getOffset() {
        return this.offset;
    }

    void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public boolean isExpired() throws Exception {
        this.blob.downloadAttributes();
        LeaseState currentState = this.blob.getProperties().getLeaseState();
        return currentState != LeaseState.LEASED;
    }

    @Override
    String getStateDebug() {
        String retval = "uninitialized";
        try {
            this.blob.downloadAttributes();
            BlobProperties props = this.blob.getProperties();
            retval = String.valueOf(props.getLeaseState().toString()) + " " + props.getLeaseStatus().toString() + " " + props.getLeaseDuration().toString();
        }
        catch (StorageException e) {
            retval = "downloadAttributes on the blob caught " + e.toString();
        }
        return retval;
    }
}

