/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventprocessorhost.AzureStorageCheckpointLeaseManager;
import com.microsoft.azure.eventprocessorhost.DefaultEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.EventProcessorOptions;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.IEventProcessorFactory;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.eventprocessorhost.PartitionManager;
import com.microsoft.azure.storage.StorageException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EventProcessorHost {
    private final String hostName;
    private final String eventHubPath;
    private final String consumerGroupName;
    private String eventHubConnectionString;
    private ICheckpointManager checkpointManager;
    private ILeaseManager leaseManager;
    private boolean initializeLeaseManager = false;
    private PartitionManager partitionManager;
    private IEventProcessorFactory<?> processorFactory;
    private EventProcessorOptions processorOptions;
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private static int executorRefCount = 0;
    private static Boolean weOwnExecutor = true;
    private static boolean autoShutdownExecutor = false;
    public static final String EVENTPROCESSORHOST_TRACE = "eventprocessorhost.trace";
    private static final Logger TRACE_LOGGER = Logger.getLogger("eventprocessorhost.trace");
    private static final Object uuidSynchronizer = new Object();

    public EventProcessorHost(String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString) {
        this(EventProcessorHost.createHostName(null), eventHubPath, consumerGroupName, eventHubConnectionString, storageConnectionString);
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, new AzureStorageCheckpointLeaseManager(storageConnectionString));
        this.initializeLeaseManager = true;
    }

    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, String storageConnectionString, String storageContainerName) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, new AzureStorageCheckpointLeaseManager(storageConnectionString, storageContainerName));
        this.initializeLeaseManager = true;
    }

    private EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, AzureStorageCheckpointLeaseManager combinedManager) {
        this(hostName, eventHubPath, consumerGroupName, eventHubConnectionString, combinedManager, combinedManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventProcessorHost(String hostName, String eventHubPath, String consumerGroupName, String eventHubConnectionString, ICheckpointManager checkpointManager, ILeaseManager leaseManager) {
        TRACE_LOGGER.setLevel(Level.SEVERE);
        this.hostName = hostName;
        this.eventHubPath = eventHubPath;
        this.consumerGroupName = consumerGroupName;
        this.eventHubConnectionString = eventHubConnectionString;
        this.checkpointManager = checkpointManager;
        this.leaseManager = leaseManager;
        if (weOwnExecutor.booleanValue()) {
            Boolean bl = weOwnExecutor;
            synchronized (bl) {
                ++executorRefCount;
            }
        }
        this.partitionManager = new PartitionManager(this);
        this.logWithHost(Level.INFO, "New EventProcessorHost created");
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getEventHubConnectionString() {
        return this.eventHubConnectionString;
    }

    void setPartitionManager(PartitionManager pm) {
        this.partitionManager = pm;
    }

    static ExecutorService getExecutorService() {
        return executorService;
    }

    ICheckpointManager getCheckpointManager() {
        return this.checkpointManager;
    }

    ILeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    IEventProcessorFactory<?> getProcessorFactory() {
        return this.processorFactory;
    }

    String getEventHubPath() {
        return this.eventHubPath;
    }

    String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    EventProcessorOptions getEventProcessorOptions() {
        return this.processorOptions;
    }

    public <T extends IEventProcessor> Future<?> registerEventProcessor(Class<T> eventProcessorType) throws Exception {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, EventProcessorOptions.getDefaultOptions());
    }

    public <T extends IEventProcessor> Future<?> registerEventProcessor(Class<T> eventProcessorType, EventProcessorOptions processorOptions) throws Exception {
        DefaultEventProcessorFactory<T> defaultFactory = new DefaultEventProcessorFactory<T>();
        defaultFactory.setEventProcessorClass(eventProcessorType);
        return this.registerEventProcessorFactory(defaultFactory, processorOptions);
    }

    public Future<?> registerEventProcessorFactory(IEventProcessorFactory<?> factory) throws Exception {
        return this.registerEventProcessorFactory(factory, EventProcessorOptions.getDefaultOptions());
    }

    public Future<?> registerEventProcessorFactory(IEventProcessorFactory<?> factory, EventProcessorOptions processorOptions) throws Exception {
        if (executorService.isShutdown() || executorService.isTerminated()) {
            this.logWithHost(Level.SEVERE, "Calling registerEventProcessor/Factory after executor service has been shut down");
            throw new RejectedExecutionException("EventProcessorHost executor service has been shut down");
        }
        if (this.initializeLeaseManager) {
            try {
                ((AzureStorageCheckpointLeaseManager)this.leaseManager).initialize(this);
            }
            catch (StorageException | URISyntaxException | InvalidKeyException e) {
                this.logWithHost(Level.SEVERE, "Failure initializing Storage lease manager", e);
                throw new RuntimeException("Failure initializing Storage lease manager", e);
            }
        }
        this.logWithHost(Level.INFO, "Starting event processing");
        this.processorFactory = factory;
        this.processorOptions = processorOptions;
        return executorService.submit(() -> this.partitionManager.initialize());
    }

    public void unregisterEventProcessor() throws InterruptedException, ExecutionException {
        this.logWithHost(Level.INFO, "Stopping event processing");
        try {
            this.partitionManager.stopPartitions().get();
            if (weOwnExecutor.booleanValue() && executorRefCount <= 0 && autoShutdownExecutor) {
                executorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.logWithHost(Level.SEVERE, "Failure shutting down", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopExecutor() {
        if (weOwnExecutor.booleanValue() && autoShutdownExecutor) {
            Boolean bl = weOwnExecutor;
            synchronized (bl) {
                if (--executorRefCount <= 0) {
                    executorService.shutdown();
                }
            }
        }
    }

    public static void setAutoExecutorShutdown(boolean auto) {
        autoShutdownExecutor = auto;
    }

    public static void forceExecutorShutdown(long secondsToWait) throws InterruptedException {
        executorService.shutdown();
        executorService.awaitTermination(secondsToWait, TimeUnit.SECONDS);
    }

    void log(Level logLevel, String logMessage) {
        TRACE_LOGGER.log(logLevel, logMessage);
    }

    void logWithHost(Level logLevel, String logMessage) {
        this.log(logLevel, "host " + this.hostName + ": " + logMessage);
    }

    void logWithHost(Level logLevel, String logMessage, Throwable e) {
        this.log(logLevel, "host " + this.hostName + ": " + logMessage);
        this.logWithHost(logLevel, "Caught " + e.toString());
        StackTraceElement[] stack = e.getStackTrace();
        int i = 0;
        while (i < stack.length) {
            this.logWithHost(logLevel, stack[i].toString());
            ++i;
        }
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof Exception) {
            Exception inner = (Exception)cause;
            this.logWithHost(logLevel, "Inner exception " + inner.toString());
            stack = inner.getStackTrace();
            int i2 = 0;
            while (i2 < stack.length) {
                this.logWithHost(logLevel, stack[i2].toString());
                ++i2;
            }
        }
    }

    void logWithHostAndPartition(Level logLevel, String partitionId, String logMessage) {
        this.logWithHost(logLevel, "partition " + partitionId + ": " + logMessage);
    }

    void logWithHostAndPartition(Level logLevel, String partitionId, String logMessage, Throwable e) {
        this.logWithHostAndPartition(logLevel, partitionId, logMessage);
        this.logWithHostAndPartition(logLevel, partitionId, "Caught " + e.toString());
        StackTraceElement[] stack = e.getStackTrace();
        int i = 0;
        while (i < stack.length) {
            this.logWithHostAndPartition(logLevel, partitionId, stack[i].toString());
            ++i;
        }
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof Exception) {
            Exception inner = (Exception)cause;
            this.logWithHostAndPartition(logLevel, partitionId, "Inner exception " + inner.toString());
            stack = inner.getStackTrace();
            int i2 = 0;
            while (i2 < stack.length) {
                this.logWithHostAndPartition(logLevel, partitionId, stack[i2].toString());
                ++i2;
            }
        }
    }

    void logWithHostAndPartition(Level logLevel, PartitionContext context, String logMessage) {
        this.logWithHostAndPartition(logLevel, context.getPartitionId(), logMessage);
    }

    void logWithHostAndPartition(Level logLevel, PartitionContext context, String logMessage, Throwable e) {
        this.logWithHostAndPartition(logLevel, context.getPartitionId(), logMessage, e);
    }

    public static String createHostName(String prefix) {
        String usePrefix = prefix;
        if (usePrefix == null || usePrefix.isEmpty()) {
            usePrefix = "javahost";
        }
        return String.valueOf(usePrefix) + "-" + EventProcessorHost.safeCreateUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String safeCreateUUID() {
        String uuid = "not generated";
        Object object = uuidSynchronizer;
        synchronized (object) {
            uuid = UUID.randomUUID().toString();
        }
        return uuid;
    }
}

