/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.Lease;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.logging.Level;

public class PartitionContext {
    private final EventProcessorHost host;
    private final String partitionId;
    private final String eventHubPath;
    private final String consumerGroupName;
    private Lease lease;
    private String offset = "-1";
    private long sequenceNumber = 0L;
    private Object offsetSynchronizer;

    PartitionContext(EventProcessorHost host, String partitionId, String eventHubPath, String consumerGroupName) {
        this.host = host;
        this.partitionId = partitionId;
        this.eventHubPath = eventHubPath;
        this.consumerGroupName = consumerGroupName;
        this.offsetSynchronizer = new Object();
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public String getEventHubPath() {
        return this.eventHubPath;
    }

    public String getOwner() {
        return this.lease.getOwner();
    }

    Lease getLease() {
        return this.lease;
    }

    void setLease(Lease lease) {
        this.lease = lease;
    }

    public void setOffsetAndSequenceNumber(EventData event) throws IllegalArgumentException {
        this.setOffsetAndSequenceNumber(event.getSystemProperties().getOffset(), event.getSystemProperties().getSequenceNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffsetAndSequenceNumber(String offset, long sequenceNumber) throws IllegalArgumentException {
        Object object = this.offsetSynchronizer;
        synchronized (object) {
            if (sequenceNumber < this.sequenceNumber) {
                throw new IllegalArgumentException("new offset " + offset + "//" + sequenceNumber + " less than old " + this.offset + "//" + this.sequenceNumber);
            }
            this.offset = offset;
            this.sequenceNumber = sequenceNumber;
        }
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    String getInitialOffset() throws InterruptedException, ExecutionException {
        Function<String, String> initialOffsetProvider = this.host.getEventProcessorOptions().getInitialOffsetProvider();
        if (initialOffsetProvider != null) {
            this.host.logWithHostAndPartition(Level.FINE, this.partitionId, "Calling user-provided initial offset provider");
            this.offset = initialOffsetProvider.apply(this.partitionId);
            this.sequenceNumber = 0L;
            this.host.logWithHostAndPartition(Level.FINE, this.partitionId, "Initial offset provided: " + this.offset + "//" + this.sequenceNumber);
        } else {
            Checkpoint startingCheckpoint = this.host.getCheckpointManager().getCheckpoint(this.partitionId).get();
            this.offset = startingCheckpoint.getOffset();
            this.sequenceNumber = startingCheckpoint.getSequenceNumber();
            this.host.logWithHostAndPartition(Level.FINE, this.partitionId, "Retrieved starting offset " + this.offset + "//" + this.sequenceNumber);
        }
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws IllegalArgumentException, InterruptedException, ExecutionException {
        Checkpoint capturedCheckpoint = null;
        Object object = this.offsetSynchronizer;
        synchronized (object) {
            capturedCheckpoint = new Checkpoint(this.partitionId, this.offset, this.sequenceNumber);
        }
        this.persistCheckpoint(capturedCheckpoint);
    }

    public void checkpoint(EventData event) throws IllegalArgumentException, InterruptedException, ExecutionException {
        this.setOffsetAndSequenceNumber(event.getSystemProperties().getOffset(), event.getSystemProperties().getSequenceNumber());
        this.persistCheckpoint(new Checkpoint(this.partitionId, event.getSystemProperties().getOffset(), event.getSystemProperties().getSequenceNumber()));
    }

    private void persistCheckpoint(Checkpoint persistThis) throws IllegalArgumentException, InterruptedException, ExecutionException {
        this.host.logWithHostAndPartition(Level.FINE, persistThis.getPartitionId(), "Saving checkpoint: " + persistThis.getOffset() + "//" + persistThis.getSequenceNumber());
        Checkpoint inStoreCheckpoint = this.host.getCheckpointManager().getCheckpoint(persistThis.getPartitionId()).get();
        if (persistThis.getSequenceNumber() < inStoreCheckpoint.getSequenceNumber()) {
            String msg = "Ignoring out of date checkpoint with offset " + persistThis.getOffset() + "/sequence number " + persistThis.getSequenceNumber() + " because current persisted checkpoint has higher offset " + inStoreCheckpoint.getOffset() + "/sequence number " + inStoreCheckpoint.getSequenceNumber();
            this.host.logWithHostAndPartition(Level.SEVERE, persistThis.getPartitionId(), msg);
            throw new IllegalArgumentException(msg);
        }
        inStoreCheckpoint.setOffset(persistThis.getOffset());
        inStoreCheckpoint.setSequenceNumber(persistThis.getSequenceNumber());
        this.host.getCheckpointManager().updateCheckpoint(inStoreCheckpoint).get();
    }
}

