/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import java.util.concurrent.CompletableFuture;

public class Lease {
    private final String partitionId;
    private long epoch;
    private String owner;
    private String token;

    protected Lease() {
        this.partitionId = "-1";
    }

    public Lease(String partitionId) {
        this.partitionId = partitionId;
        this.epoch = 0L;
        this.owner = "";
        this.token = "";
    }

    public Lease(Lease source) {
        this.partitionId = source.partitionId;
        this.epoch = source.epoch;
        this.owner = source.owner;
        this.token = source.token;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public void setEpoch(long epoch) {
        this.epoch = epoch;
    }

    public long incrementEpoch() {
        ++this.epoch;
        return this.epoch;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isOwnedBy(String possibleOwner) {
        boolean retval = false;
        if (this.owner != null) {
            retval = this.owner.compareTo(possibleOwner) == 0;
        }
        return retval;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public CompletableFuture<Boolean> isExpired() {
        return CompletableFuture.completedFuture(false);
    }

    String getStateDebug() {
        return "N/A";
    }
}

