/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventprocessorhost.ExceptionReceivedEventArgs;
import java.time.Duration;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventProcessorOptions {
    private Consumer<ExceptionReceivedEventArgs> exceptionNotificationHandler = null;
    private Boolean invokeProcessorAfterReceiveTimeout = false;
    private boolean receiverRuntimeMetricEnabled = false;
    private int maxBatchSize = 10;
    private int prefetchCount = 300;
    private Duration receiveTimeOut = Duration.ofMinutes(1L);
    private Function<String, EventPosition> initialPositionProvider = partitionId -> EventPosition.fromStartOfStream();
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(EventProcessorOptions.class);

    public static EventProcessorOptions getDefaultOptions() {
        return new EventProcessorOptions();
    }

    public void setExceptionNotification(Consumer<ExceptionReceivedEventArgs> notificationHandler) {
        this.exceptionNotificationHandler = notificationHandler;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public Duration getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(Duration receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) {
        if (prefetchCount < 1) {
            throw new IllegalArgumentException(String.format(Locale.US, "PrefetchCount has to be above %s", 1));
        }
        if (prefetchCount > 2000) {
            throw new IllegalArgumentException(String.format(Locale.US, "PrefetchCount has to be below %s", 2000));
        }
        this.prefetchCount = prefetchCount;
    }

    public Function<String, EventPosition> getInitialPositionProvider() {
        return this.initialPositionProvider;
    }

    public void setInitialPositionProvider(Function<String, EventPosition> initialPositionProvider) {
        this.initialPositionProvider = initialPositionProvider;
    }

    public Boolean getInvokeProcessorAfterReceiveTimeout() {
        return this.invokeProcessorAfterReceiveTimeout;
    }

    public void setInvokeProcessorAfterReceiveTimeout(Boolean invokeProcessorAfterReceiveTimeout) {
        this.invokeProcessorAfterReceiveTimeout = invokeProcessorAfterReceiveTimeout;
    }

    public boolean getReceiverRuntimeMetricEnabled() {
        return this.receiverRuntimeMetricEnabled;
    }

    public void setReceiverRuntimeMetricEnabled(boolean value) {
        this.receiverRuntimeMetricEnabled = value;
    }

    void notifyOfException(String hostname, Exception exception, String action) {
        this.notifyOfException(hostname, exception, action, "N/A");
    }

    void notifyOfException(String hostname, Exception exception, String action, String partitionId) {
        Consumer<ExceptionReceivedEventArgs> handler = this.exceptionNotificationHandler;
        if (handler != null) {
            try {
                handler.accept(new ExceptionReceivedEventArgs(hostname, exception, action, partitionId));
            }
            catch (Exception e) {
                TRACE_LOGGER.error("host " + hostname + ": caught exception from user-provided exception notification handler", (Throwable)e);
            }
        }
    }

    public class EndOfStreamInitialPositionProvider
    implements Function<String, EventPosition> {
        @Override
        public EventPosition apply(String t) {
            return EventPosition.fromEndOfStream();
        }
    }

    public class StartOfStreamInitialPositionProvider
    implements Function<String, EventPosition> {
        @Override
        public EventPosition apply(String t) {
            return EventPosition.fromStartOfStream();
        }
    }
}

