/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.extensions.appender;

import com.microsoft.azure.eventhubs.extensions.appender.EventHubsManager;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.StringEncoder;

@Plugin(name="EventHub", category="Core", elementType="appender", printObject=true)
public final class EventHubsAppender
extends AbstractAppender {
    private static final int MAX_BATCH_SIZE_BYTES = 204800;
    private static final int MAX_BATCH_SIZE = 21312;
    private static final long serialVersionUID = 1L;
    private final EventHubsManager eventHubsManager;
    private final boolean immediateFlush;
    private final AtomicInteger currentBufferedSizeBytes;
    private final ConcurrentLinkedQueue<byte[]> logEvents;

    private EventHubsAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, EventHubsManager eventHubsManager, boolean immediateFlush) {
        super(name, filter, layout, ignoreExceptions);
        this.eventHubsManager = eventHubsManager;
        this.immediateFlush = immediateFlush;
        this.logEvents = new ConcurrentLinkedQueue();
        this.currentBufferedSizeBytes = new AtomicInteger();
    }

    @PluginFactory
    public static EventHubsAppender createAppender(@Required(message="Provide a Name for EventHubs Log4j Appender") @PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions, @Required(message="Provide EventHub connection string to append the events to") @PluginAttribute(value="eventHubConnectionString") String connectionString, @PluginAttribute(value="immediateFlush", defaultBoolean=false) boolean immediateFlush) {
        EventHubsManager eventHubsManager = new EventHubsManager(name, connectionString);
        return new EventHubsAppender(name, filter, layout, ignoreExceptions, eventHubsManager, immediateFlush);
    }

    public void append(LogEvent logEvent) {
        byte[] serializedLogEvent = null;
        try {
            Layout layout = this.getLayout();
            serializedLogEvent = layout != null ? layout.toByteArray(logEvent) : StringEncoder.toBytes((String)logEvent.getMessage().getFormattedMessage(), (Charset)StandardCharsets.UTF_8);
            if (serializedLogEvent != null) {
                if (this.immediateFlush) {
                    this.eventHubsManager.send(serializedLogEvent);
                    return;
                }
                int currentSize = this.currentBufferedSizeBytes.addAndGet(serializedLogEvent.length);
                this.logEvents.offer(serializedLogEvent);
                if (currentSize < 204800 && this.logEvents.size() < 21312 && !logEvent.isEndOfBatch()) {
                    return;
                }
                logEvent.setEndOfBatch(true);
                this.eventHubsManager.send(this.logEvents);
                this.logEvents.clear();
                this.currentBufferedSizeBytes.set(0);
            }
        }
        catch (Throwable exception) {
            AppenderLoggingException appenderLoggingException = exception instanceof AppenderLoggingException ? (AppenderLoggingException)exception : new AppenderLoggingException("Appending logEvent to EventHubs failed: " + exception.getMessage(), exception);
            LOGGER.error(String.format(Locale.US, "[%s] Appender failed to logEvent to EventHub.", this.getName()));
            if (serializedLogEvent != null && this.logEvents.remove(serializedLogEvent)) {
                this.currentBufferedSizeBytes.addAndGet(-1 * serializedLogEvent.length);
            }
            throw appenderLoggingException;
        }
    }

    public void start() {
        super.start();
        try {
            this.eventHubsManager.startup();
        }
        catch (Throwable exception) {
            String errMsg = String.format(Locale.US, "[%s] Appender initialization failed with error: [%s]", this.getName(), exception.getMessage());
            LOGGER.error(errMsg);
            throw new AppenderLoggingException(errMsg, exception);
        }
    }

    public void stop() {
        super.stop();
        this.eventHubsManager.release();
    }
}

