/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.extensions.appender;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;

public final class EventHubsManager
extends AbstractManager {
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1);
    private final String eventHubConnectionString;
    private EventHubClient eventHubSender;

    protected EventHubsManager(String name, String eventHubConnectionString) {
        super(LoggerContext.getContext((boolean)true), name);
        this.eventHubConnectionString = eventHubConnectionString;
    }

    public void send(byte[] msg) throws EventHubException {
        if (msg != null) {
            EventData data = EventData.create((byte[])msg);
            this.eventHubSender.sendSync(data);
        }
    }

    public void send(Iterable<byte[]> messages) throws EventHubException {
        if (messages != null) {
            LinkedList<EventData> events = new LinkedList<EventData>();
            for (byte[] message : messages) {
                events.add(EventData.create((byte[])message));
            }
            this.eventHubSender.sendSync(events);
        }
    }

    public void startup() throws EventHubException, IOException {
        this.eventHubSender = EventHubClient.createFromConnectionStringSync((String)this.eventHubConnectionString, (ScheduledExecutorService)EXECUTOR_SERVICE);
    }
}

