/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.eventhubs;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.eventhubs.EventHubsWriteTask;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class EventHubsWriter$
implements Logging {
    public static final EventHubsWriter$ MODULE$;
    private final String BodyAttributeName;
    private final String PartitionKeyAttributeName;
    private final String PartitionIdAttributeName;
    private final String PartitionIdAttributeNameAlias;
    private final String PropertiesAttributeName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new EventHubsWriter$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String BodyAttributeName() {
        return this.BodyAttributeName;
    }

    public String PartitionKeyAttributeName() {
        return this.PartitionKeyAttributeName;
    }

    public String PartitionIdAttributeName() {
        return this.PartitionIdAttributeName;
    }

    public String PartitionIdAttributeNameAlias() {
        return this.PartitionIdAttributeNameAlias;
    }

    public String PropertiesAttributeName() {
        return this.PropertiesAttributeName;
    }

    public String toString() {
        return "EventHubsWriter";
    }

    private void validateQuery(Seq<Attribute> schema, Map<String, String> parameters) {
        DataType dataType = ((Expression)schema.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute x$1) {
                String string = x$1.name();
                String string2 = EventHubsWriter$.MODULE$.BodyAttributeName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required attribute '", "' not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventHubsWriter$.MODULE$.BodyAttributeName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        })).dataType();
        boolean bl = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " attribute type "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.BodyAttributeName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"must be a String or BinaryType."})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public void write(SparkSession sparkSession, QueryExecution queryExecution, Map<String, String> parameters) {
        Seq schema = queryExecution.analyzed().output();
        this.validateQuery((Seq<Attribute>)schema, parameters);
        queryExecution.toRdd().foreachPartition((Function1)new Serializable(parameters, schema){
            public static final long serialVersionUID = 0L;
            private final Map parameters$1;
            private final Seq schema$1;

            public final void apply(Iterator<InternalRow> iter) {
                EventHubsWriteTask writeTask = new EventHubsWriteTask((Map<String, String>)this.parameters$1, (Seq<Attribute>)this.schema$1);
                Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(this, writeTask, iter){
                    public static final long serialVersionUID = 0L;
                    private final EventHubsWriteTask writeTask$1;
                    private final Iterator iter$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.writeTask$1.execute((Iterator<InternalRow>)this.iter$1);
                    }
                    {
                        this.writeTask$1 = writeTask$1;
                        this.iter$1 = iter$1;
                    }
                }, (Function0)new Serializable(this, writeTask){
                    public static final long serialVersionUID = 0L;
                    private final EventHubsWriteTask writeTask$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.writeTask$1.close();
                    }
                    {
                        this.writeTask$1 = writeTask$1;
                    }
                });
            }
            {
                this.parameters$1 = parameters$1;
                this.schema$1 = schema$1;
            }
        });
    }

    private EventHubsWriter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.BodyAttributeName = "body";
        this.PartitionKeyAttributeName = "partitionKey";
        this.PartitionIdAttributeName = "partition";
        this.PartitionIdAttributeNameAlias = "partitionId";
        this.PropertiesAttributeName = "properties";
    }
}

