/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver$;
import org.apache.spark.eventhubs.PartitionsStatusTracker;
import org.apache.spark.eventhubs.PartitionsStatusTracker$;
import org.apache.spark.eventhubs.TaskContextSlim;
import org.apache.spark.eventhubs.client.Client;
import org.apache.spark.eventhubs.client.EventHubsClient;
import org.apache.spark.eventhubs.client.EventHubsClient$;
import org.apache.spark.eventhubs.package$;
import org.apache.spark.eventhubs.rdd.EventHubsRDD;
import org.apache.spark.eventhubs.rdd.OffsetRange;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.eventhubs.EventHubsDirectDStream;
import org.apache.spark.util.RpcUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EventHubsUtils$
implements Logging {
    public static final EventHubsUtils$ MODULE$;
    private RpcEndpointRef partitionPerformanceReceiverRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new EventHubsUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public RpcEndpointRef partitionPerformanceReceiverRef() {
        return this.partitionPerformanceReceiverRef;
    }

    public void partitionPerformanceReceiverRef_$eq(RpcEndpointRef x$1) {
        this.partitionPerformanceReceiverRef = x$1;
    }

    private void createRpcEndpoint() {
        if (this.partitionPerformanceReceiverRef() == null) {
            try {
                this.partitionPerformanceReceiverRef_$eq(RpcUtils$.MODULE$.makeDriverRef(PartitionPerformanceReceiver$.MODULE$.ENDPOINT_NAME(), SparkEnv$.MODULE$.get().conf(), SparkEnv$.MODULE$.get().rpcEnv()));
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is an existing partitionPerformanceReceiverRef on the driver, use that one rather than creating a new one"})).s((Seq)Nil$.MODULE$);
                    }
                });
            }
            catch (Exception exception) {
                PartitionsStatusTracker partitionsStatusTracker = PartitionsStatusTracker$.MODULE$.getPartitionStatusTracker();
                PartitionPerformanceReceiver partitionPerformanceReceiver = new PartitionPerformanceReceiver(SparkEnv$.MODULE$.get().rpcEnv(), partitionsStatusTracker);
                this.partitionPerformanceReceiverRef_$eq(SparkEnv$.MODULE$.get().rpcEnv().setupEndpoint(PartitionPerformanceReceiver$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)partitionPerformanceReceiver));
            }
        }
    }

    public EventHubsDirectDStream createDirectStream(StreamingContext ssc, EventHubsConf ehConf) {
        this.createRpcEndpoint();
        return new EventHubsDirectDStream(ssc, ehConf, (Function1<EventHubsConf, Client>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final EventHubsClient apply(EventHubsConf ehConf) {
                return EventHubsClient$.MODULE$.apply(ehConf);
            }
        });
    }

    public JavaInputDStream<EventData> createDirectStream(JavaStreamingContext jssc, EventHubsConf ehConf) {
        this.createRpcEndpoint();
        return new JavaInputDStream((InputDStream)this.createDirectStream(jssc.ssc(), ehConf), ClassTag$.MODULE$.apply(EventData.class));
    }

    public EventHubsRDD createRDD(SparkContext sc, EventHubsConf ehConf, OffsetRange[] offsetRanges) {
        this.createRpcEndpoint();
        return new EventHubsRDD(sc, ehConf.trimmed(), offsetRanges);
    }

    public JavaRDD<EventData> createRDD(JavaSparkContext jsc, EventHubsConf ehConf, OffsetRange[] offsetRanges) {
        this.createRpcEndpoint();
        return new JavaRDD((RDD)this.createRDD(jsc.sc(), ehConf, offsetRanges), ClassTag$.MODULE$.apply(EventData.class));
    }

    public CompletableFuture<PartitionReceiver> createReceiverInner(EventHubClient client, boolean useExclusiveReceiver2, String consumerGroup2, String partitionId, EventPosition eventPosition, ReceiverOptions receiverOptions) {
        long taskId = this.getTaskId();
        this.logInfo((Function0<String>)new Serializable(useExclusiveReceiver2, consumerGroup2, partitionId, taskId){
            public static final long serialVersionUID = 0L;
            private final boolean useExclusiveReceiver$1;
            private final String consumerGroup$1;
            private final String partitionId$1;
            private final long taskId$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") creating receiver for Event Hub partition ", ", consumer group ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$1), this.partitionId$1, this.consumerGroup$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with epoch receiver option ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.useExclusiveReceiver$1)}))).toString();
            }
            {
                this.useExclusiveReceiver$1 = useExclusiveReceiver$1;
                this.consumerGroup$1 = consumerGroup$1;
                this.partitionId$1 = partitionId$1;
                this.taskId$1 = taskId$1;
            }
        });
        return useExclusiveReceiver2 ? client.createEpochReceiver(consumerGroup2, partitionId, eventPosition, package$.MODULE$.DefaultEpoch(), receiverOptions) : client.createReceiver(consumerGroup2, partitionId, eventPosition, receiverOptions);
    }

    public long getTaskId() {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        return taskContext == null ? -1L : taskContext.taskAttemptId();
    }

    public TaskContextSlim getTaskContextSlim() {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        return taskContext == null ? new TaskContextSlim(-1, -1L, -1, "") : new TaskContextSlim(taskContext.stageId(), taskContext.taskAttemptId(), taskContext.partitionId(), SparkEnv$.MODULE$.get().executorId());
    }

    public String encode(String inputStr) {
        return Base64.getEncoder().encodeToString(inputStr.getBytes(StandardCharsets.UTF_8));
    }

    public String decode(String inputString) {
        return new String(Base64.getDecoder().decode(inputString), StandardCharsets.UTF_8);
    }

    public String encrypt(String inputStr) {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, this.getSecretKeySpec());
        return Base64.getEncoder().encodeToString(cipher.doFinal(inputStr.getBytes(StandardCharsets.UTF_8)));
    }

    public String decrypt(String inputString) {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, this.getSecretKeySpec());
        return new String(cipher.doFinal(Base64.getDecoder().decode(inputString)), StandardCharsets.UTF_8);
    }

    private SecretKeySpec getSecretKeySpec() {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec keySpec = new PBEKeySpec(package$.MODULE$.SparkConnectorVersion().toCharArray(), package$.MODULE$.SparkConnectorVersion().getBytes(), 1000, 256);
        SecretKey secretKey = secretKeyFactory.generateSecret(keySpec);
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }

    private EventHubsUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.partitionPerformanceReceiverRef = null;
    }
}

