/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs.client;

import com.microsoft.azure.eventhubs.EventHubClient;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.client.ClientConnectionPool;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ClientConnectionPool$
implements Logging {
    public static final ClientConnectionPool$ MODULE$;
    private final HashMap<String, ClientConnectionPool> pools;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ClientConnectionPool$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String org$apache$spark$eventhubs$client$ClientConnectionPool$$notInitializedMessage(String name) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection pool is not initialized for EventHubs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
    }

    private boolean isInitialized(String key) {
        HashMap<String, ClientConnectionPool> hashMap = this.pools;
        synchronized (hashMap) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.pools.get((Object)key).isDefined());
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    private void ensureInitialized(String key) {
        if (this.isInitialized(key)) {
            return;
        }
        String message = this.org$apache$spark$eventhubs$client$ClientConnectionPool$$notInitializedMessage(key);
        throw new IllegalStateException(message);
    }

    private String key(EventHubsConf ehConf) {
        return ehConf.connectionString().toLowerCase();
    }

    private ClientConnectionPool get(String key) {
        HashMap<String, ClientConnectionPool> hashMap = this.pools;
        synchronized (hashMap) {
            Object object = this.pools.getOrElse((Object)key, (Function0)new Serializable(key){
                public static final long serialVersionUID = 0L;
                private final String key$1;

                public final Nothing$ apply() {
                    String message = ClientConnectionPool$.MODULE$.org$apache$spark$eventhubs$client$ClientConnectionPool$$notInitializedMessage(this.key$1);
                    throw new IllegalStateException(message);
                }
                {
                    this.key$1 = key$1;
                }
            });
            return (ClientConnectionPool)object;
        }
    }

    public EventHubClient borrowClient(EventHubsConf ehConf) {
        HashMap<String, ClientConnectionPool> hashMap = this.pools;
        synchronized (hashMap) {
            BoxedUnit boxedUnit;
            if (this.isInitialized(this.key(ehConf))) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.pools.update((Object)this.key(ehConf), (Object)new ClientConnectionPool(ehConf));
                boxedUnit = BoxedUnit.UNIT;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            ClientConnectionPool pool = this.get(this.key(ehConf));
            return pool.org$apache$spark$eventhubs$client$ClientConnectionPool$$borrowClient();
        }
    }

    public void returnClient(EventHubsConf ehConf, EventHubClient client) {
        this.ensureInitialized(this.key(ehConf));
        ClientConnectionPool pool = this.get(this.key(ehConf));
        pool.org$apache$spark$eventhubs$client$ClientConnectionPool$$returnClient(client);
    }

    private ClientConnectionPool$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.pools = new HashMap();
    }
}

