/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs.rdd;

import com.microsoft.azure.eventhubs.EventData;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.client.CachedEventHubsReceiver$;
import org.apache.spark.eventhubs.client.CachedReceiver;
import org.apache.spark.eventhubs.rdd.EventHubsRDDPartition;
import org.apache.spark.eventhubs.rdd.HasOffsetRanges;
import org.apache.spark.eventhubs.rdd.OffsetRange;
import org.apache.spark.eventhubs.utils.SimulatedCachedReceiver$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055b!\u0002\b\u0010\u0001MI\u0002\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011i\u0002!Q1A\u0005\u0002mB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0003\u0002\u0011)\u0019!C\u0001\u0005\"AA\n\u0001B\u0001B\u0003%1\tC\u0003N\u0001\u0011\u0005a\nC\u0003T\u0001\u0011\u0005C\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0003_\u0001\u0011\u0005s\fC\u0003d\u0001\u0011\u0005C\rC\u0003l\u0001\u0011\u0005C\u000eC\u0004\u0002\b\u0001!I!!\u0003\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\taQI^3oi\"+(m\u001d*E\t*\u0011\u0001#E\u0001\u0004e\u0012$'B\u0001\n\u0014\u0003%)g/\u001a8uQV\u00147O\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h'\u0011\u0001!D\u000b\u0019\u0011\u0007mir$D\u0001\u001d\u0015\t\u00012#\u0003\u0002\u001f9\t\u0019!\u000b\u0012#\u0011\u0005\u0001BS\"A\u0011\u000b\u0005I\u0011#BA\u0012%\u0003\u0015\t'0\u001e:f\u0015\t)c%A\u0005nS\u000e\u0014xn]8gi*\tq%A\u0002d_6L!!K\u0011\u0003\u0013\u00153XM\u001c;ECR\f\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0014\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0018-\u0005\u001daunZ4j]\u001e\u0004\"!\r\u001a\u000e\u0003=I!aM\b\u0003\u001f!\u000b7o\u00144gg\u0016$(+\u00198hKN\f!a]2\u0004\u0001A\u0011q\u0007O\u0007\u0002'%\u0011\u0011h\u0005\u0002\r'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007K\"\u001cuN\u001c4\u0016\u0003q\u0002\"!\u0010 \u000e\u0003EI!aP\t\u0003\u001b\u00153XM\u001c;Ik\n\u001c8i\u001c8g\u0003\u001d)\u0007nQ8oM\u0002\nAb\u001c4gg\u0016$(+\u00198hKN,\u0012a\u0011\t\u0004\t\u001eKU\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ER\u0015BA&\u0010\u0005-yeMZ:fiJ\u000bgnZ3\u0002\u001b=4gm]3u%\u0006tw-Z:!\u0003\u0019a\u0014N\\5u}Q!q\nU)S!\t\t\u0004\u0001C\u00035\r\u0001\u0007a\u0007C\u0003;\r\u0001\u0007A\bC\u0003B\r\u0001\u00071)A\u0007hKR\u0004\u0016M\u001d;ji&|gn]\u000b\u0002+B\u0019Ai\u0012,\u0011\u0005]:\u0016B\u0001-\u0014\u0005%\u0001\u0016M\u001d;ji&|g.A\u0003d_VtG\u000fF\u0001\\!\t!E,\u0003\u0002^\u000b\n!Aj\u001c8h\u0003\u001dI7/R7qif$\u0012\u0001\u0019\t\u0003\t\u0006L!AY#\u0003\u000f\t{w\u000e\\3b]\u0006!A/Y6f)\t)g\rE\u0002E\u000f~AQa\u001a\u0006A\u0002!\f1A\\;n!\t!\u0015.\u0003\u0002k\u000b\n\u0019\u0011J\u001c;\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR\u0019Q.a\u0001\u0011\u000794\u0018P\u0004\u0002pi:\u0011\u0001o]\u0007\u0002c*\u0011!/N\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K!!^#\u0002\u000fA\f7m[1hK&\u0011q\u000f\u001f\u0002\u0004'\u0016\f(BA;F!\tQhP\u0004\u0002|yB\u0011\u0001/R\u0005\u0003{\u0016\u000ba\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t11\u000b\u001e:j]\u001eT!!`#\t\r\u0005\u00151\u00021\u0001W\u0003\u0015\u0019\b\u000f\\5u\u0003A)'O\u001d\"fO&t\u0017I\u001a;fe\u0016sG\rF\u0002z\u0003\u0017Aq!!\u0004\r\u0001\u0004\ty!\u0001\u0003qCJ$\bcA\u0019\u0002\u0012%\u0019\u00111C\b\u0003+\u00153XM\u001c;Ik\n\u001c(\u000b\u0012#QCJ$\u0018\u000e^5p]\u000691m\\7qkR,GCBA\r\u0003?\t\u0019\u0003\u0005\u0003o\u00037y\u0012bAA\u000fq\nA\u0011\n^3sCR|'\u000f\u0003\u0004\u0002\"5\u0001\rAV\u0001\na\u0006\u0014H/\u001b;j_:Dq!!\n\u000e\u0001\u0004\t9#A\u0004d_:$X\r\u001f;\u0011\u0007]\nI#C\u0002\u0002,M\u00111\u0002V1tW\u000e{g\u000e^3yi\u0002")
public class EventHubsRDD
extends RDD<EventData>
implements HasOffsetRanges {
    private final EventHubsConf ehConf;
    private final OffsetRange[] offsetRanges;

    public EventHubsConf ehConf() {
        return this.ehConf;
    }

    @Override
    public OffsetRange[] offsetRanges() {
        return this.offsetRanges;
    }

    public Partition[] getPartitions() {
        return (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partitionId()), (Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)o -> new EventHubsRDDPartition(o.partitionId(), o.nameAndPartition(), o.fromSeqNo(), o.untilSeqNo(), o.preferredLoc()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.count()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public EventData[] take(int num) {
        EventHubsRDDPartition[] nonEmptyPartitions = (EventHubsRDDPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitions())).map((Function1 & Serializable & scala.Serializable)x$3 -> (EventHubsRDDPartition)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EventHubsRDDPartition.class))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EventHubsRDD.$anonfun$take$2(x$4)));
        if (num < 1 || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).isEmpty()) {
            return (EventData[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(EventData.class));
        }
        Map parts = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(result, part) -> {
            Map map;
            int remain = num - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (remain > 0) {
                long taken = Math.min((long)remain, part.count());
                map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
            } else {
                map = result;
            }
            return map;
        });
        return (EventData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.context().runJob((RDD)this, (Function2 & Serializable & scala.Serializable)(tc, it) -> (EventData[])it.take(BoxesRunTime.unboxToInt((Object)parts.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(EventData.class)), (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(EventData.class))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(EventData.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        EventHubsRDDPartition part = (EventHubsRDDPartition)split;
        return (Seq)part.preferredLoc().map((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    private String errBeginAfterEnd(EventHubsRDDPartition part) {
        return new StringBuilder(57).append("The beginning sequence number ").append(part.fromSeqNo()).append(" is larger than the ending ").append(new StringBuilder(45).append("sequence number ").append(part.untilSeqNo()).append(" for EventHubs ").append(part.name()).append(" on partition ").toString()).append(new StringBuilder(1).append(part.partitionId()).append(".").toString()).toString();
    }

    public Iterator<EventData> compute(Partition partition, TaskContext context) {
        Iterator<EventData> iterator;
        EventHubsRDDPartition part = (EventHubsRDDPartition)partition;
        Predef$.MODULE$.assert(part.fromSeqNo() <= part.untilSeqNo(), (Function0 & Serializable & scala.Serializable)() -> this.errBeginAfterEnd(part));
        if (part.fromSeqNo() == part.untilSeqNo()) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("(TID ").append(context.taskAttemptId()).append(") Beginning sequence number ").append(part.fromSeqNo()).append(" is equal to the ending sequence ").append(new StringBuilder(44).append("number ").append(part.untilSeqNo()).append(". Returning empty partition for EH: ").append(part.name()).append(" ").toString()).append(new StringBuilder(14).append("on partition: ").append(part.partitionId()).toString()).toString());
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("(TID ").append(context.taskAttemptId()).append(") Computing EventHubs ").append(part.name()).append(", partition ").append(part.partitionId()).append(" ").append(new StringBuilder(21).append("sequence numbers ").append(part.fromSeqNo()).append(" => ").append(part.untilSeqNo()).toString()).toString());
            CachedReceiver cachedReceiver = this.ehConf().useSimulatedClient() ? SimulatedCachedReceiver$.MODULE$ : CachedEventHubsReceiver$.MODULE$;
            iterator = cachedReceiver.receive(this.ehConf(), part.nameAndPartition(), part.fromSeqNo(), (int)(part.untilSeqNo() - part.fromSeqNo()));
        }
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$take$2(EventHubsRDDPartition x$4) {
        return x$4.count() > 0L;
    }

    public EventHubsRDD(SparkContext sc, EventHubsConf ehConf, OffsetRange[] offsetRanges) {
        this.ehConf = ehConf;
        this.offsetRanges = offsetRanges;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(EventData.class));
    }
}

