/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import java.io.Serializable;
import org.apache.spark.eventhubs.client.Client;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.eventhubs.EventHubsWriter$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001e4aAC\u0006\u0002\u0002-)\u0002\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\t\u000bI\u0002A\u0011A\u001a\t\u000f]\u0002!\u0019!C\tq!1A\b\u0001Q\u0001\neBQ!\u0010\u0001\u0005\nyBQ\u0001\u0016\u0001\u0005\nUCQ\u0001\u0018\u0001\u0005\nuCQa\u001a\u0001\u0005\u0012!DQ\u0001\u001f\u0001\u0005\na\u0012!#\u0012<f]RDUOY:S_^<&/\u001b;fe*\u0011A\"D\u0001\nKZ,g\u000e\u001e5vENT!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\fS:\u0004X\u000f^*dQ\u0016l\u0017m\u0001\u0001\u0011\u0007}9#F\u0004\u0002!K9\u0011\u0011\u0005J\u0007\u0002E)\u00111%H\u0001\u0007yI|w\u000e\u001e \n\u0003eI!A\n\r\u0002\u000fA\f7m[1hK&\u0011\u0001&\u000b\u0002\u0004'\u0016\f(B\u0001\u0014\u0019!\tY\u0003'D\u0001-\u0015\tic&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0018\u000e\u0003!\u0019\u0017\r^1msN$\u0018BA\u0019-\u0005%\tE\u000f\u001e:jEV$X-\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003-AQ\u0001\b\u0002A\u0002y\t!\u0002\u001d:pU\u0016\u001cG/[8o+\u0005I\u0004CA\u0016;\u0013\tYDF\u0001\tV]N\fg-\u001a)s_*,7\r^5p]\u0006Y\u0001O]8kK\u000e$\u0018n\u001c8!\u00039!x\u000eU1si&$\u0018n\u001c8LKf$\"a\u0010&\u0011\u0007]\u0001%)\u0003\u0002B1\t1q\n\u001d;j_:\u0004\"aQ$\u000f\u0005\u0011+\u0005CA\u0011\u0019\u0013\t1\u0005$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$\u0019\u0011\u0015YU\u00011\u0001M\u00031\u0001\u0018M\u001d;ji&|gnS3z!\ti%+D\u0001O\u0015\ty\u0005+A\u0003usB,7O\u0003\u0002R\u001f\u00051QO\\:bM\u0016L!a\u0015(\u0003\u0015U#f\tO*ue&tw-A\u0007u_B\u000b'\u000f^5uS>t\u0017\n\u001a\u000b\u0003-j\u00032a\u0006!X!\t9\u0002,\u0003\u0002Z1\t\u0019\u0011J\u001c;\t\u000bm3\u0001\u0019\u0001'\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ri>\u0004&o\u001c9feRLWm\u001d\u000b\u0003=\n\u00042a\u0006!`!\u0011\u0019\u0005M\u0011\"\n\u0005\u0005L%aA'ba\")1m\u0002a\u0001I\u0006IQO\\:bM\u0016l\u0015\r\u001d\t\u0003W\u0015L!A\u001a\u0017\u0003\u001bUs7/\u00194f\u001b\u0006\u0004H)\u0019;b\u0003\u001d\u0019XM\u001c3S_^$2aV5p\u0011\u0015Q\u0007\u00021\u0001l\u0003\r\u0011xn\u001e\t\u0003Y6l\u0011AL\u0005\u0003]:\u00121\"\u00138uKJt\u0017\r\u001c*po\")\u0001\u000f\u0003a\u0001c\u000611/\u001a8eKJ\u0004\"A\u001d<\u000e\u0003MT!\u0001^;\u0002\r\rd\u0017.\u001a8u\u0015\taq\"\u0003\u0002xg\n11\t\\5f]R\f\u0001c\u0019:fCR,\u0007K]8kK\u000e$\u0018n\u001c8")
public abstract class EventHubsRowWriter {
    private final Seq<Attribute> inputSchema;
    private final UnsafeProjection projection;

    public UnsafeProjection projection() {
        return this.projection;
    }

    private Option<String> toPartitionKey(UTF8String partitionKey) {
        return partitionKey == null ? None$.MODULE$ : new Some((Object)partitionKey.toString());
    }

    private Option<Object> toPartitionId(UTF8String partitionId) {
        None$ none$;
        if (partitionId == null) {
            none$ = None$.MODULE$;
        } else {
            UTF8String.IntWrapper wrapper = new UTF8String.IntWrapper();
            Predef$.MODULE$.assert(partitionId.toInt(wrapper));
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)wrapper.value));
        }
        return none$;
    }

    private Option<Map<String, String>> toProperties(UnsafeMapData unsafeMap) {
        None$ none$;
        if (unsafeMap == null) {
            none$ = None$.MODULE$;
        } else {
            UnsafeArrayData keys = unsafeMap.keyArray();
            UnsafeArrayData values = unsafeMap.valueArray();
            none$ = new Some((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), keys.numElements()).map((Function1 & Serializable & scala.Serializable)i -> EventHubsRowWriter.$anonfun$toProperties$1(keys, values, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return none$;
    }

    public int sendRow(InternalRow row, Client sender) {
        UnsafeRow projectedRow = this.projection().apply(row);
        byte[] body = projectedRow.getBinary(0);
        Option<String> partitionKey = this.toPartitionKey(projectedRow.getUTF8String(1));
        Option<Object> partitionId = this.toPartitionId(projectedRow.getUTF8String(2));
        Option<Map<String, String>> properties = this.toProperties(projectedRow.getMap(3));
        Predef$.MODULE$.require(partitionId.isEmpty() || partitionKey.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Both a partitionKey (").append(partitionKey.get()).append(") and partition (").append(partitionId.get()).append(") have been detected. Both can not be set.").toString());
        EventData event = EventData.create((byte[])body);
        sender.send(event, partitionId, partitionKey, properties);
        return event.getBytes().length;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnsafeProjection createProjection() {
        Attribute bodyExpression = (Attribute)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EventHubsRowWriter.$anonfun$createProjection$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(32).append("Required attribute '").append(EventHubsWriter$.MODULE$.BodyAttributeName()).append("' not found.").toString());
        });
        DataType dataType = bodyExpression.dataType();
        boolean bl = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
        if (!bl) {
            throw new IllegalStateException(new StringBuilder(28).append(EventHubsWriter$.MODULE$.BodyAttributeName()).append(" attribute unsupported type ").append(dataType).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        LeafExpression partitionKeyExpression = (LeafExpression)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EventHubsRowWriter.$anonfun$createProjection$3(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)StringType$.MODULE$));
        DataType dataType2 = partitionKeyExpression.dataType();
        if (!StringType$.MODULE$.equals(dataType2)) {
            throw new IllegalStateException(new StringBuilder(28).append(EventHubsWriter$.MODULE$.PartitionKeyAttributeName()).append(" attribute unsupported type ").append(dataType2).toString());
        }
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        LeafExpression partitionIdExpression = (LeafExpression)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EventHubsRowWriter.$anonfun$createProjection$5(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)StringType$.MODULE$));
        DataType dataType3 = partitionIdExpression.dataType();
        if (!StringType$.MODULE$.equals(dataType3)) {
            throw new IllegalStateException(new StringBuilder(28).append(EventHubsWriter$.MODULE$.PartitionIdAttributeName()).append(" attribute unsupported type ").append(dataType3).toString());
        }
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        LeafExpression propertiesExpression = (LeafExpression)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EventHubsRowWriter.$anonfun$createProjection$7(x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$)));
        boolean bl2 = false;
        MapType mapType = null;
        DataType dataType4 = propertiesExpression.dataType();
        if (dataType4 instanceof MapType) {
            bl2 = true;
            mapType = (MapType)dataType4;
            DataType dataType5 = mapType.keyType();
            DataType dataType6 = mapType.valueType();
            boolean bl3 = mapType.valueContainsNull();
            if (StringType$.MODULE$.equals(dataType5) && StringType$.MODULE$.equals(dataType6) && bl3) {
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                return UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cast[]{new Cast((Expression)bodyExpression, (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)partitionKeyExpression, (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)partitionIdExpression, (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)propertiesExpression, (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), Cast$.MODULE$.apply$default$3())})), this.inputSchema);
            }
        }
        if (!bl2) throw new IllegalStateException(new StringBuilder(28).append(EventHubsWriter$.MODULE$.PropertiesAttributeName()).append(" attribute unsupported type ").append(dataType4).toString());
        DataType dataType7 = mapType.keyType();
        DataType dataType8 = mapType.valueType();
        boolean bl4 = mapType.valueContainsNull();
        if (!StringType$.MODULE$.equals(dataType7) || !StringType$.MODULE$.equals(dataType8) || bl4) throw new IllegalStateException(new StringBuilder(28).append(EventHubsWriter$.MODULE$.PropertiesAttributeName()).append(" attribute unsupported type ").append(dataType4).toString());
        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        return UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cast[]{new Cast((Expression)bodyExpression, (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)partitionKeyExpression, (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)partitionIdExpression, (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)propertiesExpression, (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), Cast$.MODULE$.apply$default$3())})), this.inputSchema);
    }

    public static final /* synthetic */ Tuple2 $anonfun$toProperties$1(UnsafeArrayData keys$1, UnsafeArrayData values$1, int i) {
        if (keys$1.isNullAt(i)) {
            throw new IllegalStateException("Properties cannot have a null key");
        }
        if (values$1.isNullAt(i)) {
            throw new IllegalStateException("Properties cannot have a null value");
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keys$1.getUTF8String(i).toString()), (Object)values$1.getUTF8String(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$1(Attribute x$2) {
        String string = x$2.name();
        String string2 = EventHubsWriter$.MODULE$.BodyAttributeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$3(Attribute x$3) {
        String string = x$3.name();
        String string2 = EventHubsWriter$.MODULE$.PartitionKeyAttributeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$5(Attribute x$4) {
        String string = x$4.name();
        String string2 = EventHubsWriter$.MODULE$.PartitionIdAttributeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$7(Attribute x$5) {
        String string = x$5.name();
        String string2 = EventHubsWriter$.MODULE$.PropertiesAttributeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public EventHubsRowWriter(Seq<Attribute> inputSchema) {
        this.inputSchema = inputSchema;
        this.projection = this.createProjection();
    }
}

