/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.eventhubs;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.EventHubsConf$;
import org.apache.spark.eventhubs.NameAndPartition;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver;
import org.apache.spark.eventhubs.PartitionsStatusTracker;
import org.apache.spark.eventhubs.PartitionsStatusTracker$;
import org.apache.spark.eventhubs.client.Client;
import org.apache.spark.eventhubs.package$;
import org.apache.spark.eventhubs.package$PartitionPreferredLocationStrategy$;
import org.apache.spark.eventhubs.rdd.EventHubsRDD;
import org.apache.spark.eventhubs.rdd.OffsetRange;
import org.apache.spark.eventhubs.rdd.OffsetRange$;
import org.apache.spark.eventhubs.utils.ThrottlingStatusPlugin;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.eventhubs.EventHubsSource$;
import org.apache.spark.sql.eventhubs.EventHubsSourceOffset;
import org.apache.spark.sql.eventhubs.EventHubsSourceOffset$;
import org.apache.spark.sql.eventhubs.EventHubsSourceProvider$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]f!\u0002\u001d:\u0001u\u001a\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\u0007e\u0002!\t!O:\t\u0011e\u0004\u0001R1A\u0005\niD!\"!\u0002\u0001\u0011\u000b\u0007I\u0011BA\u0004\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u000b\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003C\u0004\u0002$\u0001\u0001\u000b\u0011\u00028\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005\u001d\u0002\u0002CA\u0019\u0001\u0001\u0006I!!\u000b\t\u0013\u0005M\u0002A1A\u0005\n\u0005U\u0002\u0002CA\"\u0001\u0001\u0006I!a\u000e\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0003\u0002CA(\u0001\u0001\u0006I!!\u0013\t\u0015\u0005E\u0003\u0001#b\u0001\n\u0013\t\u0019\u0006C\u0005\u0002d\u0001\u0001\r\u0011\"\u0001\u0002f!I\u0011\u0011\u0011\u0001A\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003\u001f\u0003\u0001\u0015)\u0003\u0002h!I\u0011\u0011\u0013\u0001C\u0002\u0013\u0005\u00111\u0013\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\u0016\"Q\u0011\u0011\u0014\u0001\t\u0006\u0004%I!a'\t\u0013\u0005u\u0006\u00011A\u0005\n\u0005}\u0006\"CAb\u0001\u0001\u0007I\u0011BAc\u0011!\tI\r\u0001Q!\n\u0005\u0005\u0007\"CAf\u0001\u0001\u0007I\u0011BA`\u0011%\ti\r\u0001a\u0001\n\u0013\ty\r\u0003\u0005\u0002T\u0002\u0001\u000b\u0015BAa\u0011\u001d\t)\u000e\u0001C!\u0003/Dq!!:\u0001\t\u0003\n9\u000fC\u0004\u0002r\u0002!I!a=\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000f:\u0001B!\u0014:\u0011\u0003I$q\n\u0004\bqeB\t!\u000fB)\u0011\u0019\u0011x\u0005\"\u0001\u0003Z!I!1L\u0014C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\b\u0005;:\u0003\u0015!\u0003o\u0011)\u0011yf\nb\u0001\n\u0003I\u0014q\u0001\u0005\t\u0005C:\u0003\u0015!\u0003\u0002\n!I!1M\u0014A\u0002\u0013%\u0011q\u0001\u0005\n\u0005K:\u0003\u0019!C\u0005\u0005OB\u0001Ba\u001b(A\u0003&\u0011\u0011\u0002\u0005\n\u0005[:#\u0019!C\u0001\u0005_B\u0001Ba\u001e(A\u0003%!\u0011\u000f\u0005\n\u0005s:#\u0019!C\u0001\u0005wB\u0001Ba!(A\u0003%!Q\u0010\u0005\n\u0005\u000b;#\u0019!C\u0001\u0005\u000fC\u0001B!&(A\u0003%!\u0011\u0012\u0005\b\u0005/;C\u0011\u0001BM\u0011\u001d\u0011yj\nC\u0005\u0005C\u0013q\"\u0012<f]RDUOY:T_V\u00148-\u001a\u0006\u0003um\n\u0011\"\u001a<f]RDWOY:\u000b\u0005qj\u0014aA:rY*\u0011ahP\u0001\u0006gB\f'o\u001b\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014xm\u0005\u0003\u0001\t2#\u0006CA#K\u001b\u00051%BA$I\u0003\u0011a\u0017M\\4\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016!C:ue\u0016\fW.\u001b8h\u0015\t\t6(A\u0005fq\u0016\u001cW\u000f^5p]&\u00111K\u0014\u0002\u0007'>,(oY3\u0011\u0005UCV\"\u0001,\u000b\u0005]k\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005e3&a\u0002'pO\u001eLgnZ\u0001\u000bgFd7i\u001c8uKb$8\u0001\u0001\t\u0003;zk\u0011aO\u0005\u0003?n\u0012!bU)M\u0007>tG/\u001a=u\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005E.tgN\u0004\u0002dSB\u0011AmZ\u0007\u0002K*\u0011amW\u0001\u0007yI|w\u000e\u001e \u000b\u0003!\fQa]2bY\u0006L!A[4\u0002\rA\u0013X\rZ3g\u0013\taWNA\u0002NCBT!A[4\u0011\u0005\t|\u0017B\u00019n\u0005\u0019\u0019FO]5oO\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQ\u00061A(\u001b8jiz\"B\u0001\u001e<xqB\u0011Q\u000fA\u0007\u0002s!)!\f\u0002a\u00019\")\u0001\r\u0002a\u0001C\")\u0011\u000f\u0002a\u0001]\u0006AQ\r[\"mS\u0016tG/F\u0001|!\ra\u0018\u0011A\u0007\u0002{*\u0011ap`\u0001\u0007G2LWM\u001c;\u000b\u0005ij\u0014bAA\u0002{\n11\t\\5f]R\fa\u0002]1si&$\u0018n\u001c8D_VtG/\u0006\u0002\u0002\nA!\u00111BA\u0007\u001b\u00059\u0017bAA\bO\n\u0019\u0011J\u001c;\u0002\r\u0015D7i\u001c8g+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"A@\n\u0007\u0005mqPA\u0007Fm\u0016tG\u000fS;cg\u000e{gNZ\u0001\bK\"\u001cuN\u001c4!\u0003\u0019)\u0007NT1nKV\ta.A\u0004fQ:\u000bW.\u001a\u0011\u0002\u0005M\u001cWCAA\u0015!\u0011\tY#!\f\u000e\u0003uJ1!a\f>\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\r\u00198\rI\u0001\u0015[\u0006DxJ\u001a4tKR\u001c\b+\u001a:Ue&<w-\u001a:\u0016\u0005\u0005]\u0002CBA\u0006\u0003s\ti$C\u0002\u0002<\u001d\u0014aa\u00149uS>t\u0007\u0003BA\u0006\u0003\u007fI1!!\u0011h\u0005\u0011auN\\4\u0002+5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3sA\u000592\u000f\\8x!\u0006\u0014H/\u001b;j_:\fEM[;ti6,g\u000e^\u000b\u0003\u0003\u0013\u0002B!a\u0003\u0002L%\u0019\u0011QJ4\u0003\u000f\t{w\u000e\\3b]\u0006A2\u000f\\8x!\u0006\u0014H/\u001b;j_:\fEM[;ti6,g\u000e\u001e\u0011\u0002-QD'o\u001c;uY&twm\u0015;biV\u001c\b\u000b\\;hS:,\"!!\u0016\u0011\r\u0005-\u0011\u0011HA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\u007f\u0006)Q\u000f^5mg&!\u0011\u0011MA.\u0005Y!\u0006N]8ui2LgnZ*uCR,8\u000f\u00157vO&t\u0017\u0001\u00079beRLG/[8ogRC'o\u001c;uY\u00164\u0015m\u0019;peV\u0011\u0011q\r\t\t\u0003S\n\u0019(!\u001e\u0002|5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0004nkR\f'\r\\3\u000b\u0007\u0005Et-\u0001\u0006d_2dWm\u0019;j_:L1\u0001\\A6!\u0011\t9\"a\u001e\n\u0007\u0005etP\u0001\tOC6,\u0017I\u001c3QCJ$\u0018\u000e^5p]B!\u00111BA?\u0013\r\tyh\u001a\u0002\u0007\t>,(\r\\3\u00029A\f'\u000f^5uS>t7\u000f\u00165s_R$H.\u001a$bGR|'o\u0018\u0013fcR!\u0011QQAF!\u0011\tY!a\"\n\u0007\u0005%uM\u0001\u0003V]&$\b\"CAG'\u0005\u0005\t\u0019AA4\u0003\rAH%M\u0001\u001aa\u0006\u0014H/\u001b;j_:\u001cH\u000b\u001b:piRdWMR1di>\u0014\b%\u0001\u0014eK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]N\u0004VM\u001d4pe6\fgnY3QKJ\u001cWM\u001c;bO\u0016,\"!!&\u0011\r\t\\\u0017QOA>\u0003\u001d\"WMZ1vYR\u0004\u0016M\u001d;ji&|gn\u001d)fe\u001a|'/\\1oG\u0016\u0004VM]2f]R\fw-\u001a\u0011\u0002-%t\u0017\u000e^5bYB\u000b'\u000f^5uS>t7+Z9O_N,\"!!(\u0011\r\t\\\u0017QOAP!\u0011\t\t+a.\u000f\t\u0005\r\u00161\u0017\b\u0005\u0003K\u000b\tL\u0004\u0003\u0002(\u0006=f\u0002BAU\u0003[s1\u0001ZAV\u0013\u0005\u0011\u0015B\u0001!B\u0013\tqt(\u0003\u0002;{%\u0019\u0011QW@\u0002\u000fA\f7m[1hK&!\u0011\u0011XA^\u00059\u0019V-];f]\u000e,g*^7cKJT1!!.\u0000\u00035\u0019WO\u001d:f]R\u001cV-\u001d(pgV\u0011\u0011\u0011\u0019\t\u0007\u0003\u0017\tI$!(\u0002#\r,(O]3oiN+\u0017OT8t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0006\u001d\u0007\"CAG3\u0005\u0005\t\u0019AAa\u00039\u0019WO\u001d:f]R\u001cV-\u001d(pg\u0002\na\"Z1sY&,7\u000f^*fc:{7/\u0001\nfCJd\u0017.Z:u'\u0016\fhj\\:`I\u0015\fH\u0003BAC\u0003#D\u0011\"!$\u001d\u0003\u0003\u0005\r!!1\u0002\u001f\u0015\f'\u000f\\5fgR\u001cV-\u001d(pg\u0002\naa]2iK6\fWCAAm!\u0011\tY.!9\u000e\u0005\u0005u'bAApw\u0005)A/\u001f9fg&!\u00111]Ao\u0005)\u0019FO];diRK\b/Z\u0001\nO\u0016$xJ\u001a4tKR,\"!!;\u0011\r\u0005-\u0011\u0011HAv!\ri\u0015Q^\u0005\u0004\u0003_t%AB(gMN,G/\u0001\u000bbI*,8\u000f^*uCJ$\u0018N\\4PM\u001a\u001cX\r\u001e\u000b\u0005\u0003;\u000b)\u0010C\u0004\u0002x\u0002\u0002\r!!(\u0002\t\u0019\u0014x.\\\u0001\ne\u0006$X\rT5nSR$\"\"!(\u0002~\n\u0005!1\u0001B\u0004\u0011\u001d\ty0\ta\u0001\u0003{\tQ\u0001\\5nSRDq!a>\"\u0001\u0004\ti\nC\u0004\u0003\u0006\u0005\u0002\r!!(\u0002\u000bUtG/\u001b7\t\u000f\t%\u0011\u00051\u0001\u0002\u001e\u00069aM]8n\u001d\u0016<\u0018\u0001C4fi\n\u000bGo\u00195\u0015\r\t=!q\u0004B\u0012!\u0011\u0011\tB!\u0007\u000f\t\tM!q\u0003\b\u0005\u0003K\u0013)\"\u0003\u0002={%\u0019\u0011QW\u001e\n\t\tm!Q\u0004\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!.<\u0011\u001d\u0011\tC\ta\u0001\u0003S\fQa\u001d;beRDqA!\n#\u0001\u0004\tY/A\u0002f]\u0012\fa$\u00193e\u0007V\u0014(/\u001a8u\u0005\u0006$8\r\u001b+p'R\fG/^:Ue\u0006\u001c7.\u001a:\u0015\t\u0005\u0015%1\u0006\u0005\b\u0005[\u0019\u0003\u0019\u0001B\u0018\u00031ygMZ:fiJ\u000bgnZ3t!\u0019\tYA!\r\u00036%\u0019!1G4\u0003\u000b\u0005\u0013(/Y=\u0011\t\t]\"QH\u0007\u0003\u0005sQ1Aa\u000f\u0000\u0003\r\u0011H\rZ\u0005\u0005\u0005\u007f\u0011IDA\u0006PM\u001a\u001cX\r\u001e*b]\u001e,\u0017\u0001B:u_B$\"!!\"\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgR!\u0011Q\u0011B%\u0011\u0019\u0011Y%\na\u0001]\u00069Q.Z:tC\u001e,\u0017aD#wK:$\b*\u001e2t'>,(oY3\u0011\u0005U<3cA\u0014\u0003TA!\u00111\u0002B+\u0013\r\u00119f\u001a\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t=\u0013\u0001I%ogR\u0014Xo\u0019;j_:\u001chi\u001c:Q_R,g\u000e^5bY\u0012\u000bG/\u0019'pgN\f\u0011%\u00138tiJ,8\r^5p]N4uN\u001d)pi\u0016tG/[1m\t\u0006$\u0018\rT8tg\u0002\nqAV#S'&{e*\u0001\u0005W\u000bJ\u001b\u0016j\u0014(!\u00031awnY1m\u0005\u0006$8\r[%e\u0003AawnY1m\u0005\u0006$8\r[%e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\n%\u0004\"CAG]\u0005\u0005\t\u0019AA\u0005\u00035awnY1m\u0005\u0006$8\r[%eA\u00059\u0002/\u0019:uSRLwN\\:Ti\u0006$Xo\u001d+sC\u000e\\WM]\u000b\u0003\u0005c\u0002B!a\u0006\u0003t%\u0019!QO@\u0003/A\u000b'\u000f^5uS>t7o\u0015;biV\u001cHK]1dW\u0016\u0014\u0018\u0001\u00079beRLG/[8ogN#\u0018\r^;t)J\f7m[3sA\u0005a\u0002/\u0019:uSRLwN\u001c)fe\u001a|'/\\1oG\u0016\u0014VmY3jm\u0016\u0014XC\u0001B?!\u0011\t9Ba \n\u0007\t\u0005uP\u0001\u000fQCJ$\u0018\u000e^5p]B+'OZ8s[\u0006t7-\u001a*fG\u0016Lg/\u001a:\u0002;A\f'\u000f^5uS>t\u0007+\u001a:g_Jl\u0017M\\2f%\u0016\u001cW-\u001b<fe\u0002\nq\u0004]1si&$\u0018n\u001c8QKJ4wN]7b]\u000e,'+Z2fSZ,'OU3g+\t\u0011I\t\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y)P\u0001\u0004eB\u001c\u0017\u0002\u0002BJ\u0005\u001b\u0013aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\u0011qCJ$\u0018\u000e^5p]B+'OZ8s[\u0006t7-\u001a*fG\u0016Lg/\u001a:SK\u001a\u0004\u0013!F4fiN{'\u000f^3e\u000bb,7-\u001e;pe2K7\u000f\u001e\u000b\u0005\u00057\u0013i\nE\u0003\u0002\f\tEb\u000eC\u0004\u0002&Y\u0002\r!!\u000b\u0002\u000f\r|W\u000e]1sKR1\u0011\u0011\nBR\u0005gCqA!*8\u0001\u0004\u00119+A\u0001b!\u0011\u0011IKa,\u000e\u0005\t-&b\u0001BW{\u0005I1o\u00195fIVdWM]\u0005\u0005\u0005c\u0013YKA\rFq\u0016\u001cW\u000f^8s\u0007\u0006\u001c\u0007.\u001a+bg.dunY1uS>t\u0007b\u0002B[o\u0001\u0007!qU\u0001\u0002E\u0002")
public class EventHubsSource
implements Source,
Logging {
    private Client ehClient;
    private int partitionCount;
    private Option<ThrottlingStatusPlugin> throttlingStatusPlugin;
    private Map<NameAndPartition, Object> initialPartitionSeqNos;
    public final SQLContext org$apache$spark$sql$eventhubs$EventHubsSource$$sqlContext;
    private final Map<String, String> parameters;
    public final String org$apache$spark$sql$eventhubs$EventHubsSource$$metadataPath;
    private final EventHubsConf ehConf;
    private final String ehName;
    private final SparkContext sc;
    private final Option<Object> maxOffsetsPerTrigger;
    private final boolean slowPartitionAdjustment;
    private scala.collection.mutable.Map<NameAndPartition, Object> partitionsThrottleFactor;
    private final Map<NameAndPartition, Object> defaultPartitionsPerformancePercentage;
    private Option<Map<NameAndPartition, Object>> currentSeqNos;
    private Option<Map<NameAndPartition, Object>> earliestSeqNos;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String[] getSortedExecutorList(SparkContext sparkContext) {
        return EventHubsSource$.MODULE$.getSortedExecutorList(sparkContext);
    }

    public static RpcEndpointRef partitionPerformanceReceiverRef() {
        return EventHubsSource$.MODULE$.partitionPerformanceReceiverRef();
    }

    public static PartitionPerformanceReceiver partitionPerformanceReceiver() {
        return EventHubsSource$.MODULE$.partitionPerformanceReceiver();
    }

    public static PartitionsStatusTracker partitionsStatusTracker() {
        return EventHubsSource$.MODULE$.partitionsStatusTracker();
    }

    public static String InstructionsForPotentialDataLoss() {
        return EventHubsSource$.MODULE$.InstructionsForPotentialDataLoss();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Client ehClient$lzycompute() {
        EventHubsSource eventHubsSource = this;
        synchronized (eventHubsSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ehClient = (Client)EventHubsSourceProvider$.MODULE$.clientFactory(this.parameters).apply((Object)this.ehConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ehClient;
    }

    private Client ehClient() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ehClient$lzycompute() : this.ehClient;
    }

    private int partitionCount$lzycompute() {
        EventHubsSource eventHubsSource = this;
        synchronized (eventHubsSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionCount = this.ehClient().partitionCount();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionCount;
    }

    private int partitionCount() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionCount$lzycompute() : this.partitionCount;
    }

    private EventHubsConf ehConf() {
        return this.ehConf;
    }

    private String ehName() {
        return this.ehName;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    private boolean slowPartitionAdjustment() {
        return this.slowPartitionAdjustment;
    }

    private Option<ThrottlingStatusPlugin> throttlingStatusPlugin$lzycompute() {
        EventHubsSource eventHubsSource = this;
        synchronized (eventHubsSource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.throttlingStatusPlugin = this.ehConf().throttlingStatusPlugin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.throttlingStatusPlugin;
    }

    private Option<ThrottlingStatusPlugin> throttlingStatusPlugin() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.throttlingStatusPlugin$lzycompute() : this.throttlingStatusPlugin;
    }

    public scala.collection.mutable.Map<NameAndPartition, Object> partitionsThrottleFactor() {
        return this.partitionsThrottleFactor;
    }

    public void partitionsThrottleFactor_$eq(scala.collection.mutable.Map<NameAndPartition, Object> x$1) {
        this.partitionsThrottleFactor = x$1;
    }

    public Map<NameAndPartition, Object> defaultPartitionsPerformancePercentage() {
        return this.defaultPartitionsPerformancePercentage;
    }

    private Map<NameAndPartition, Object> initialPartitionSeqNos$lzycompute() {
        EventHubsSource eventHubsSource = this;
        synchronized (eventHubsSource) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                HDFSMetadataLog<EventHubsSourceOffset> metadataLog = new HDFSMetadataLog<EventHubsSourceOffset>(this){

                    public void serialize(EventHubsSourceOffset metadata, OutputStream out) {
                        out.write(0);
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                        writer.write(new StringBuilder(2).append("v").append(EventHubsSource$.MODULE$.VERSION()).append("\n").toString());
                        writer.write(metadata.json());
                        writer.flush();
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public EventHubsSourceOffset deserialize(InputStream in) {
                        EventHubsSourceOffset eventHubsSourceOffset;
                        in.read();
                        String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                        Predef$.MODULE$.assert(content.length() != 0);
                        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                            int indexOfNewLine = content.indexOf("\n");
                            if (indexOfNewLine <= 0) throw new IllegalStateException("Log file was malformed.");
                            int version = this.parseLogVersion(content.substring(0, indexOfNewLine), EventHubsSource$.MODULE$.VERSION());
                            eventHubsSourceOffset = EventHubsSourceOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
                            return eventHubsSourceOffset;
                        } else {
                            eventHubsSourceOffset = EventHubsSourceOffset$.MODULE$.apply(new SerializedOffset(content));
                        }
                        return eventHubsSourceOffset;
                    }

                    private int parseLogVersion(String text, int maxSupportedVersion) {
                        if (text.length() > 0 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) == 'v') {
                            int n;
                            try {
                                n = new StringOps(Predef$.MODULE$.augmentString(text.substring(1, text.length()))).toInt();
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalStateException(new StringBuilder(51).append("Log file was malformed: failed to read correct log ").append(new StringBuilder(14).append("version from ").append(text).append(".").toString()).toString());
                            }
                            int version = n;
                            if (version > 0) {
                                if (version > maxSupportedVersion) {
                                    throw new IllegalStateException(new StringBuilder(132).append("UnsupportedLogVersion: maximum supported log version ").append(new StringBuilder(51).append("is v").append(maxSupportedVersion).append(", but encountered v").append(version).append(". The log file was produced ").toString()).append("by a newer version of Spark and cannot be read by this version. Please upgrade.").toString());
                                }
                                return version;
                            }
                        }
                        throw new IllegalStateException(new StringBuilder(51).append("Log file was malformed: failed to read correct log ").append(new StringBuilder(14).append("version from ").append(text).append(".").toString()).toString());
                    }
                };
                this.initialPartitionSeqNos = ((EventHubsSourceOffset)((Object)metadataLog.get(0L).getOrElse(() -> EventHubsSource.$anonfun$initialPartitionSeqNos$1(this, (HDFSMetadataLog)metadataLog)))).partitionToSeqNos();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.initialPartitionSeqNos;
    }

    private Map<NameAndPartition, Object> initialPartitionSeqNos() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.initialPartitionSeqNos$lzycompute() : this.initialPartitionSeqNos;
    }

    private Option<Map<NameAndPartition, Object>> currentSeqNos() {
        return this.currentSeqNos;
    }

    private void currentSeqNos_$eq(Option<Map<NameAndPartition, Object>> x$1) {
        this.currentSeqNos = x$1;
    }

    private Option<Map<NameAndPartition, Object>> earliestSeqNos() {
        return this.earliestSeqNos;
    }

    private void earliestSeqNos_$eq(Option<Map<NameAndPartition, Object>> x$1) {
        this.earliestSeqNos = x$1;
    }

    public StructType schema() {
        return EventHubsSourceProvider$.MODULE$.eventHubsSchema();
    }

    /*
     * Unable to fully structure code
     */
    public Option<Offset> getOffset() {
        block5: {
            block4: {
                this.initialPartitionSeqNos();
                earliestAndLatest = this.ehClient().allBoundedSeqNos();
                this.earliestSeqNos_$eq((Option<Map<NameAndPartition, Object>>)new Some((Object)((Map)earliestAndLatest.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getOffset$1(org.apache.spark.sql.eventhubs.EventHubsSource scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((EventHubsSource)this), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
                latest = ((Map)earliestAndLatest.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getOffset$2(org.apache.spark.sql.eventhubs.EventHubsSource scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((EventHubsSource)this), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                var5_3 = false;
                var6_4 = null;
                var7_5 = this.maxOffsetsPerTrigger();
                if (!None$.MODULE$.equals(var7_5)) break block4;
                var1_6 = latest;
                break block5;
            }
            if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
            var5_3 = true;
            var6_4 = (Some)var7_5;
            limit = BoxesRunTime.unboxToLong((Object)var6_4.value());
            if (this.currentSeqNos().isEmpty()) {
                startingSeqNos = this.adjustStartingOffset(this.initialPartitionSeqNos());
                var1_6 = this.rateLimit(limit, startingSeqNos, latest, (Map<NameAndPartition, Object>)((Map)this.earliestSeqNos().get()));
            } else if (var5_3) {
                limit = BoxesRunTime.unboxToLong((Object)var6_4.value());
                startingSeqNos = this.adjustStartingOffset((Map<NameAndPartition, Object>)((Map)this.currentSeqNos().get()));
                var1_6 = this.rateLimit(limit, startingSeqNos, latest, (Map<NameAndPartition, Object>)((Map)this.earliestSeqNos().get()));
            } else {
                throw new MatchError(var7_5);
            }
        }
        seqNos = var1_6;
        this.currentSeqNos_$eq((Option<Map<NameAndPartition, Object>>)new Some((Object)seqNos));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOffset$3(scala.collection.immutable.Map ), ()Ljava/lang/String;)((Map)seqNos));
        return new Some((Object)new EventHubsSourceOffset(seqNos));
    }

    private Map<NameAndPartition, Object> adjustStartingOffset(Map<NameAndPartition, Object> from) {
        return (Map)from.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                NameAndPartition nAndP = (NameAndPartition)tuple22._1();
                long seqNo = tuple22._2$mcJ$sp();
                if (seqNo < BoxesRunTime.unboxToLong((Object)((MapLike)this.earliestSeqNos().get()).apply((Object)nAndP))) {
                    this.reportDataLoss(new StringBuilder(112).append("Starting seqNo ").append(seqNo).append(" in partition ").append(nAndP.partitionId()).append(" of EventHub ").append(nAndP.ehName()).append(" ").append(new StringBuilder(40).append("is behind the earliest sequence number ").append(((MapLike)this.earliestSeqNos().get()).apply((Object)nAndP)).append(" ").toString()).append("present in the service. Some events may have expired and been missed.").toString());
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nAndP), ((MapLike)this.earliestSeqNos().get()).apply((Object)nAndP));
                } else {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nAndP), (Object)BoxesRunTime.boxToLong((long)seqNo));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    private Map<NameAndPartition, Object> rateLimit(long limit, Map<NameAndPartition, Object> from, Map<NameAndPartition, Object> until, Map<NameAndPartition, Object> fromNew) {
        Map partitionsPerformancePercentage = this.slowPartitionAdjustment() ? (Map)EventHubsSource$.MODULE$.partitionsStatusTracker().partitionsPerformancePercentage().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultPartitionsPerformancePercentage()) : this.defaultPartitionsPerformancePercentage();
        Map sizes = (Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NameAndPartition nameAndPartition = (NameAndPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(from.get((Object)nameAndPartition).orElse((Function0 & Serializable & scala.Serializable)() -> fromNew.get((Object)nameAndPartition)).flatMap((Function1 & Serializable & scala.Serializable)begin -> EventHubsSource.$anonfun$rateLimit$4(this, end, nameAndPartition, BoxesRunTime.unboxToLong((Object)begin))));
            return iterable;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NameAndPartition nameAndPartition = (NameAndPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nameAndPartition), sizes.get((Object)nameAndPartition).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                double perforamnceFactor;
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)nameAndPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)fromNew.apply((Object)nameAndPartition))));
                double d = perforamnceFactor = this.slowPartitionAdjustment() ? BoxesRunTime.unboxToDouble((Object)partitionsPerformancePercentage.apply((Object)nameAndPartition)) : 1.0;
                if (this.slowPartitionAdjustment()) {
                    this.partitionsThrottleFactor().update((Object)nameAndPartition, (Object)BoxesRunTime.boxToDouble((double)perforamnceFactor));
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Slow partition adjustment is on, so prorate amount for ").append(nameAndPartition).append(" will be adjusted by").append(new StringBuilder(25).append(" the perfromanceFactor = ").append(perforamnceFactor).toString()).toString());
                }
                double prorate = (double)limit * ((double)size / total) * perforamnceFactor;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("rateLimit ").append(nameAndPartition).append(" prorated amount is ").append(prorate).toString());
                long off = begin + (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("rateLimit ").append(nameAndPartition).append(" new offset is ").append(off).toString());
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        Map<NameAndPartition, Object> map;
        Option<Offset> option;
        this.initialPartitionSeqNos();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("getBatch called with start = ").append(start).append(" and end = ").append(end).toString());
        Map<NameAndPartition, Object> untilSeqNos = EventHubsSourceOffset$.MODULE$.getPartitionSeqNos(end);
        if (this.currentSeqNos().isEmpty()) {
            this.currentSeqNos_$eq((Option<Map<NameAndPartition, Object>>)new Some(untilSeqNos));
        }
        if (start.isDefined()) {
            Object object = start.get();
            Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return this.org$apache$spark$sql$eventhubs$EventHubsSource$$sqlContext.internalCreateDataFrame(this.org$apache$spark$sql$eventhubs$EventHubsSource$$sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)), this.schema(), true);
            }
        }
        if (this.earliestSeqNos().isEmpty()) {
            Map<Object, Tuple2<Object, Object>> earliestAndLatest = this.ehClient().allBoundedSeqNos();
            this.earliestSeqNos_$eq((Option<Map<NameAndPartition, Object>>)new Some((Object)((Map)earliestAndLatest.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                int p;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        p = tuple22._1$mcI$sp();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                long e = tuple2._1$mcJ$sp();
                Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NameAndPartition(this.ehName(), p)), (Object)BoxesRunTime.boxToLong((long)e));
                return tuple23;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            Offset prevBatchEndOffset = (Offset)some.value();
            Map<NameAndPartition, Object> startingSeqNos = EventHubsSourceOffset$.MODULE$.getPartitionSeqNos(prevBatchEndOffset);
            map = this.adjustStartingOffset(startingSeqNos);
        } else if (None$.MODULE$.equals(option)) {
            map = this.adjustStartingOffset(this.initialPartitionSeqNos());
        } else {
            throw new MatchError(option);
        }
        Map<NameAndPartition, Object> fromSeqNos = map;
        Seq nameAndPartitions = untilSeqNos.keySet().toSeq();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Partitions: ").append(nameAndPartitions.mkString(", ")).toString());
        String[] sortedExecutors = EventHubsSource$.MODULE$.getSortedExecutorList(this.sc());
        int numExecutors = sortedExecutors.length;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Sorted executors: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedExecutors)).mkString(", ")).toString());
        OffsetRange[] offsetRanges = (OffsetRange[])((TraversableOnce)((TraversableLike)((TraversableLike)nameAndPartitions.map((Function1 & Serializable & scala.Serializable)np -> {
            int n;
            long fromSeqNo = BoxesRunTime.unboxToLong((Object)fromSeqNos.getOrElse(np, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(25).append(np).append(" doesn't have a fromSeqNo").toString());
            }));
            long untilSeqNo = BoxesRunTime.unboxToLong((Object)untilSeqNos.apply(np));
            Enumeration.Value value = this.ehConf().partitionPreferredLocationStrategy();
            Enumeration.Value value2 = package$PartitionPreferredLocationStrategy$.MODULE$.Hash();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                n = np.hashCode();
            } else {
                Enumeration.Value value4 = package$PartitionPreferredLocationStrategy$.MODULE$.BalancedHash();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    n = np.ehName().hashCode() + np.partitionId();
                } else {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported partition strategy: ").append(this.ehConf().partitionPreferredLocationStrategy()).toString());
                }
            }
            int preferredPartitionLocation = n;
            None$ preferredLoc = numExecutors > 0 ? new Some((Object)sortedExecutors[Math.floorMod(preferredPartitionLocation, numExecutors)]) : None$.MODULE$;
            return new Tuple5(np, (Object)BoxesRunTime.boxToLong((long)fromSeqNo), (Object)BoxesRunTime.boxToLong((long)untilSeqNo), (Object)BoxesRunTime.boxToInteger((int)preferredPartitionLocation), (Object)preferredLoc);
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple5 tuple5 = x$4;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            NameAndPartition np = (NameAndPartition)tuple5._1();
            long fromSeqNo = BoxesRunTime.unboxToLong((Object)tuple5._2());
            long untilSeqNo = BoxesRunTime.unboxToLong((Object)tuple5._3());
            Option preferredLoc = (Option)tuple5._5();
            OffsetRange offsetRange = OffsetRange$.MODULE$.apply(np, fromSeqNo, untilSeqNo, (Option<String>)preferredLoc);
            return offsetRange;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)range -> BoxesRunTime.boxToBoolean((boolean)EventHubsSource.$anonfun$getBatch$8(this, range)))).toArray(ClassTag$.MODULE$.apply(OffsetRange.class));
        if (this.slowPartitionAdjustment()) {
            this.addCurrentBatchToStatusTracker(offsetRanges);
            this.throttlingStatusPlugin().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.onBatchCreation(EventHubsSource$.MODULE$.org$apache$spark$sql$eventhubs$EventHubsSource$$localBatchId(), offsetRanges, this.partitionsThrottleFactor());
                return BoxedUnit.UNIT;
            });
        }
        RDD<InternalRow> rdd = EventHubsSourceProvider$.MODULE$.toInternalRow(new EventHubsRDD(this.sc(), this.ehConf().trimmed(), offsetRanges));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsetRanges)).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.nameAndPartition().toString(), (Ordering)Ordering.String$.MODULE$))).mkString(", ")).toString());
        return this.org$apache$spark$sql$eventhubs$EventHubsSource$$sqlContext.internalCreateDataFrame(rdd, this.schema(), true);
    }

    private void addCurrentBatchToStatusTracker(OffsetRange[] offsetRanges) {
        EventHubsSource$.MODULE$.org$apache$spark$sql$eventhubs$EventHubsSource$$localBatchId_$eq(EventHubsSource$.MODULE$.org$apache$spark$sql$eventhubs$EventHubsSource$$localBatchId() + 1);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Slow partition adjustment is on, add the current batch ").append(EventHubsSource$.MODULE$.org$apache$spark$sql$eventhubs$EventHubsSource$$localBatchId()).append(" to the tracker.").toString());
        EventHubsSource$.MODULE$.partitionsStatusTracker().addorUpdateBatch(EventHubsSource$.MODULE$.org$apache$spark$sql$eventhubs$EventHubsSource$$localBatchId(), offsetRanges);
    }

    public synchronized void stop() {
        if (this.slowPartitionAdjustment()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Slow partition adjustment is on, cleaning up the partition performance tracker before stopping.");
            EventHubsSource$.MODULE$.partitionsStatusTracker().cleanUp();
            EventHubsSource$.MODULE$.org$apache$spark$sql$eventhubs$EventHubsSource$$localBatchId_$eq(-1);
        }
        this.ehClient().close();
    }

    private void reportDataLoss(String message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(message).append(new StringBuilder(2).append(". ").append(EventHubsSource$.MODULE$.InstructionsForPotentialDataLoss()).toString()).toString());
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public static final /* synthetic */ Tuple2 $anonfun$partitionsThrottleFactor$1(EventHubsSource $this, int pid) {
        return new Tuple2((Object)new NameAndPartition($this.ehName(), pid), (Object)BoxesRunTime.boxToDouble((double)1.0));
    }

    public static final /* synthetic */ Tuple2 $anonfun$defaultPartitionsPerformancePercentage$1(EventHubsSource $this, int pid) {
        return new Tuple2((Object)new NameAndPartition($this.ehName(), pid), (Object)BoxesRunTime.boxToDouble((double)1.0));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EventHubsSourceOffset $anonfun$initialPartitionSeqNos$1(EventHubsSource $this, HDFSMetadataLog metadataLog$1) {
        void var3_3;
        Map seqNos = (Map)$this.ehClient().translate($this.ehConf(), $this.partitionCount(), $this.ehClient().translate$default$3()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int pId = tuple2._1$mcI$sp();
            long seqNo = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)new NameAndPartition($this.ehName(), pId), (Object)BoxesRunTime.boxToLong((long)seqNo));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        EventHubsSourceOffset offset = new EventHubsSourceOffset((Map<NameAndPartition, Object>)seqNos);
        metadataLog$1.add(0L, (Object)offset);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Initial sequence numbers: ").append(seqNos).toString());
        return var3_3;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getOffset$1(EventHubsSource $this, Tuple2 x0$1) {
        Tuple2 tuple2;
        int p;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$1;
                if (tuple22 == null) break block2;
                p = tuple22._1$mcI$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        long e = tuple2._1$mcJ$sp();
        Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NameAndPartition($this.ehName(), p)), (Object)BoxesRunTime.boxToLong((long)e));
        return tuple23;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getOffset$2(EventHubsSource $this, Tuple2 x0$2) {
        Tuple2 tuple2;
        int p;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$2;
                if (tuple22 == null) break block2;
                p = tuple22._1$mcI$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        long l = tuple2._2$mcJ$sp();
        Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new NameAndPartition($this.ehName(), p)), (Object)BoxesRunTime.boxToLong((long)l));
        return tuple23;
    }

    public static final /* synthetic */ String $anonfun$getOffset$3(Map seqNos$2) {
        return new StringBuilder(11).append("GetOffset: ").append(((SeqLike)seqNos$2.toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).toString();
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$4(EventHubsSource $this, long end$1, NameAndPartition nameAndPartition$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(nameAndPartition$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nameAndPartition$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getBatch$8(EventHubsSource $this, OffsetRange range) {
        boolean bl;
        if (range.untilSeqNo() < range.fromSeqNo()) {
            $this.reportDataLoss(new StringBuilder(46).append("Partition ").append(range.nameAndPartition()).append("'s sequence number was changed from ").append(new StringBuilder(36).append(range.fromSeqNo()).append(" to ").append(range.untilSeqNo()).append(", some data may have been missed").toString()).toString());
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public EventHubsSource(SQLContext sqlContext, Map<String, String> parameters, String metadataPath) {
        this.org$apache$spark$sql$eventhubs$EventHubsSource$$sqlContext = sqlContext;
        this.parameters = parameters;
        this.org$apache$spark$sql$eventhubs$EventHubsSource$$metadataPath = metadataPath;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.ehConf = EventHubsConf$.MODULE$.toConf(parameters);
        this.ehName = this.ehConf().name();
        this.sc = sqlContext.sparkContext();
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply(parameters.get((Object)EventHubsConf$.MODULE$.MaxEventsPerTriggerKey()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)EventHubsSource.$anonfun$maxOffsetsPerTrigger$1(x$1))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)$this.parameters.get((Object)EventHubsConf$.MODULE$.MaxEventsPerTriggerKeyAlias()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)EventHubsSource.$anonfun$maxOffsetsPerTrigger$3(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.partitionCount() * 1000))));
        this.slowPartitionAdjustment = new StringOps(Predef$.MODULE$.augmentString((String)parameters.get((Object)EventHubsConf$.MODULE$.SlowPartitionAdjustmentKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultSlowPartitionAdjustment()))).toBoolean();
        PartitionsStatusTracker$.MODULE$.setDefaultValuesInTracker(this.partitionCount(), this.ehName(), ((Duration)this.ehConf().maxAcceptableBatchReceiveTime().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultMaxAcceptableBatchReceiveTime())).toMillis(), this.throttlingStatusPlugin());
        this.partitionsThrottleFactor = (scala.collection.mutable.Map)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionCount()).map((Function1 & Serializable & scala.Serializable)pid -> EventHubsSource.$anonfun$partitionsThrottleFactor$1(this, BoxesRunTime.unboxToInt((Object)pid)), scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        this.defaultPartitionsPerformancePercentage = (Map)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitionCount()).map((Function1 & Serializable & scala.Serializable)pid -> EventHubsSource.$anonfun$defaultPartitionsPerformancePercentage$1(this, BoxesRunTime.unboxToInt((Object)pid)), scala.collection.package$.MODULE$.breakOut(scala.collection.immutable.Map$.MODULE$.canBuildFrom()));
        this.currentSeqNos = None$.MODULE$;
        this.earliestSeqNos = None$.MODULE$;
    }
}

