/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs.client;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.PartitionRuntimeInformation;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkEnv$;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.EventHubsUtils$;
import org.apache.spark.eventhubs.EventPosition$;
import org.apache.spark.eventhubs.NameAndPartition;
import org.apache.spark.eventhubs.PartitionPerformanceMetric;
import org.apache.spark.eventhubs.client.CachedEventHubsReceiver$;
import org.apache.spark.eventhubs.client.ClientConnectionPool$;
import org.apache.spark.eventhubs.package$;
import org.apache.spark.eventhubs.utils.MetricPlugin;
import org.apache.spark.eventhubs.utils.RetryUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=c!B\u0001\u0003\u0001\ta!aF\"bG\",G-\u0012<f]RDUOY:SK\u000e,\u0017N^3s\u0015\t\u0019A!\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b\u0019\t\u0011\"\u001a<f]RDWOY:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011!Q\u0002A!A!\u0002\u0013a\u0012AB3i\u0007>tgm\u0001\u0001\u0011\u0005uqR\"\u0001\u0003\n\u0005}!!!D#wK:$\b*\u001e2t\u0007>tg\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003\u0015q\u0017I\u001c3Q!\ti2%\u0003\u0002%\t\t\u0001b*Y7f\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005Q1\u000f^1siN+\u0017OT8\u0011\u0005!2dBA\u00155\u001d\tQ3G\u0004\u0002,e9\u0011A&\r\b\u0003[Aj\u0011A\f\u0006\u0003_m\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u00026\t\u00059\u0001/Y2lC\u001e,\u0017BA\u001c9\u00059\u0019V-];f]\u000e,g*^7cKJT!!\u000e\u0003\t\u000bi\u0002A\u0011B\u001e\u0002\rqJg.\u001b;?)\u0011adh\u0010!\u0011\u0005u\u0002Q\"\u0001\u0002\t\u000biI\u0004\u0019\u0001\u000f\t\u000b\u0005J\u0004\u0019\u0001\u0012\t\u000b\u0019J\u0004\u0019A\u0014\u0006\t\t\u0003\u0001a\u0011\u0002\u0016\u0003^\f\u0017\u000e\u001e+j[\u0016|W\u000f^#yG\u0016\u0004H/[8o!\t!5*D\u0001F\u0015\t1u)\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\taUI\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\"Aa\n\u0001EC\u0002\u0013%q*\u0001\u0007oC6,7\u000f]1dKV\u0013\u0018.F\u0001Q!\t\tVK\u0004\u0002S'B\u0011QfD\u0005\u0003)>\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011Ak\u0004\u0005\t3\u0002A)\u0019!C\u0005\u001f\u0006i1m\u001c8tk6,'o\u0012:pkBD\u0001b\u0017\u0001\t\u0006\u0004%I\u0001X\u0001\r[\u0016$(/[2QYV<\u0017N\\\u000b\u0002;B\u0019aB\u00181\n\u0005}{!AB(qi&|g\u000e\u0005\u0002bI6\t!M\u0003\u0002d\t\u0005)Q\u000f^5mg&\u0011QM\u0019\u0002\r\u001b\u0016$(/[2QYV<\u0017N\u001c\u0005\t\u0007\u0001A)\u0019!C\u0005OV\t\u0001\u000e\u0005\u0002jc6\t!N\u0003\u0002\u0006W*\u0011A.\\\u0001\u0006Cj,(/\u001a\u0006\u0003]>\f\u0011\"\\5de>\u001cxN\u001a;\u000b\u0003A\f1aY8n\u0013\t\u0011(N\u0001\bFm\u0016tG\u000fS;c\u00072LWM\u001c;\t\u000fQ\u0004\u0001\u0019!C\u0005k\u0006A!/Z2fSZ,'/F\u0001w!\tIw/\u0003\u0002yU\n\t\u0002+\u0019:uSRLwN\u001c*fG\u0016Lg/\u001a:\t\u000fi\u0004\u0001\u0019!C\u0005w\u0006a!/Z2fSZ,'o\u0018\u0013fcR\u0011Ap \t\u0003\u001duL!A`\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003I\u0018\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005\u0015\u0001\u0001)Q\u0005m\u0006I!/Z2fSZ,'\u000f\t\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u00039\u0019'/Z1uKJ+7-Z5wKJ$2A^A\u0007\u0011\u001d\ty!a\u0002A\u0002\u001d\nQa]3r\u001d>Dq!a\u0005\u0001\t\u0013\t)\"\u0001\nmCN$(+Z2fSZ,Gm\u00144gg\u0016$HCAA\f!\u0019\tI\"!\b\u0002\"5\u0011\u00111\u0004\u0006\u0003\r>IA!a\b\u0002\u001c\t1a)\u001e;ve\u0016\u00042ADA\u0012\u0013\r\t)c\u0004\u0002\u0005\u0019>tw\rC\u0004\u0002*\u0001!I!a\u000b\u0002\u0015I,7-Z5wK>sW\r\u0006\u0004\u0002.\u0005\u0015\u0013Q\u000b\t\u0007\u00033\ti\"a\f\u0011\r\u0005E\u0012\u0011HA \u001d\u0011\t\u0019$a\u000e\u000f\u00075\n)$C\u0001\u0011\u0013\t)t\"\u0003\u0003\u0002<\u0005u\"\u0001C%uKJ\f'\r\\3\u000b\u0005Uz\u0001cA5\u0002B%\u0019\u00111\t6\u0003\u0013\u00153XM\u001c;ECR\f\u0007\u0002CA$\u0003O\u0001\r!!\u0013\u0002\u000fQLW.Z8viB!\u00111JA)\u001b\t\tiEC\u0002\u0002P%\u000bA\u0001^5nK&!\u00111KA'\u0005!!UO]1uS>t\u0007bBA,\u0003O\u0001\r\u0001U\u0001\u0004[N<\u0007bBA.\u0001\u0011%\u0011QL\u0001\u000eG2|7/\u001a*fG\u0016Lg/\u001a:\u0015\u0005\u0005}\u0003CBA\r\u0003;\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9'S\u0001\u0005Y\u0006tw-\u0003\u0003\u0002l\u0005\u0015$\u0001\u0002,pS\u0012Dq!a\u001c\u0001\t\u0013\t\t(\u0001\tsK\u000e\u0014X-\u0019;f%\u0016\u001cW-\u001b<feR\u0019A0a\u001d\t\u000f\u0005=\u0011Q\u000ea\u0001O!9\u0011q\u000f\u0001\u0005\n\u0005e\u0014aC2iK\u000e\\7)\u001e:t_J$B!!\f\u0002|!9\u0011QPA;\u0001\u00049\u0013\u0001\u0004:fcV,7\u000f^*fc:{\u0007bBAA\u0001\u0011%\u00111Q\u0001\be\u0016\u001cW-\u001b<f)\u0019\t))a#\u0002\u000eB1\u0011\u0011GAD\u0003\u007fIA!!#\u0002>\tA\u0011\n^3sCR|'\u000fC\u0004\u0002~\u0005}\u0004\u0019A\u0014\t\u0011\u0005=\u0015q\u0010a\u0001\u0003#\u000b\u0011BY1uG\"\u001c\u0016N_3\u0011\u00079\t\u0019*C\u0002\u0002\u0016>\u00111!\u00138u\u0011\u001d\tI\n\u0001C\u0005\u00037\u000b1#Y<bSR\u0014VmY3jm\u0016lUm]:bO\u0016,B!!(\u0002$R1\u0011qTA[\u0003\u007f\u0003B!!)\u0002$2\u0001A\u0001CAS\u0003/\u0013\r!a*\u0003\u0003Q\u000bB!!+\u00020B\u0019a\"a+\n\u0007\u00055vBA\u0004O_RD\u0017N\\4\u0011\u00079\t\t,C\u0002\u00024>\u00111!\u00118z\u0011!\t9,a&A\u0002\u0005e\u0016!C1xC&$\u0018M\u00197f!\u0019\tI\"a/\u0002 &!\u0011QXA\u000e\u0005%\tu/Y5uC\ndW\rC\u0004\u0002~\u0005]\u0005\u0019A\u0014\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\u0006\u00013/\u001a8e!\u0006\u0014H/\u001b;j_:\u0004VM\u001d4pe6\fgnY3U_\u0012\u0013\u0018N^3s)\ra\u0018q\u0019\u0005\t\u0003\u0013\f\t\r1\u0001\u0002L\u0006!\u0002/\u0019:uSRLwN\u001c)fe\u001a|'/\\1oG\u0016\u00042!HAg\u0013\r\ty\r\u0002\u0002\u001b!\u0006\u0014H/\u001b;j_:\u0004VM\u001d4pe6\fgnY3NKR\u0014\u0018nY\u0004\t\u0003'\u0014\u0001\u0012\u0001\u0004\u0002V\u000692)Y2iK\u0012,e/\u001a8u\u0011V\u00147OU3dK&4XM\u001d\t\u0004{\u0005]gaB\u0001\u0003\u0011\u00031\u0011\u0011\\\n\u0007\u0003/l\u00111\\\n\u0011\u0007u\ni.C\u0002\u0002`\n\u0011abQ1dQ\u0016$'+Z2fSZ,'\u000fC\u0004;\u0003/$\t!a9\u0015\u0005\u0005U\u0007BCAt\u0003/\u0014\r\u0011\"\u0003\u0002j\u0006\u00192\u000f^1siJ+7-[3wKJ$\u0016.\\3OgV\u0011\u0011\u0011\u0005\u0005\n\u0003[\f9\u000e)A\u0005\u0003C\tAc\u001d;beR\u0014VmY5fm\u0016\u0014H+[7f\u001dN\u0004SaBAy\u0003/\u0004\u00111\u001f\u0002\u000b\u001bV$\u0018M\u00197f\u001b\u0006\u0004XCBA{\u0005\u000f\u0011i\u0001\u0005\u0005\u0002x\n\u0005!Q\u0001B\u0006\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u007f|\u0011AC2pY2,7\r^5p]&!!1AA}\u0005\u001dA\u0015m\u001d5NCB\u0004B!!)\u0003\b\u0011A!\u0011BAx\u0005\u0004\t9KA\u0001B!\u0011\t\tK!\u0004\u0005\u0011\t=\u0011q\u001eb\u0001\u0003O\u0013\u0011A\u0011\u0005\n\u0005'\t9\u000e)A\u0005\u0005+\t\u0011B]3dK&4XM]:\u0011\r\u0005](\u0011\u0001)=\u0011)\u0011I\"a6C\u0002\u0013\u0005!1D\u0001 a\u0006\u0014H/\u001b;j_:\u0004VM\u001d4pe6\fgnY3SK\u000e,\u0017N^3s%\u00164WC\u0001B\u000f!\u0011\u0011yB!\n\u000e\u0005\t\u0005\"b\u0001B\u0012\r\u0005\u0019!\u000f]2\n\t\t\u001d\"\u0011\u0005\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011%\u0011Y#a6!\u0002\u0013\u0011i\"\u0001\u0011qCJ$\u0018\u000e^5p]B+'OZ8s[\u0006t7-\u001a*fG\u0016Lg/\u001a:SK\u001a\u0004\u0003\u0002\u0003B\u0018\u0003/$IA!\r\u0002\u0007-,\u0017\u0010F\u0003Q\u0005g\u0011)\u0004\u0003\u0004\u001b\u0005[\u0001\r\u0001\b\u0005\u0007C\t5\u0002\u0019\u0001\u0012\t\u0013\u0005\u0005\u0015q\u001bC!\t\teBCCAC\u0005w\u0011iDa\u0010\u0003B!1!Da\u000eA\u0002qAa!\tB\u001c\u0001\u0004\u0011\u0003bBA?\u0005o\u0001\ra\n\u0005\t\u0003\u001f\u00139\u00041\u0001\u0002\u0012\"A!QIAl\t\u0003\u00119%A\u0003baBd\u0017\u0010F\u0004=\u0005\u0013\u0012YE!\u0014\t\ri\u0011\u0019\u00051\u0001\u001d\u0011\u0019\t#1\ta\u0001E!1aEa\u0011A\u0002\u001d\u0002")
public class CachedEventHubsReceiver
implements Logging {
    private String namespaceUri;
    private String consumerGroup;
    private Option<MetricPlugin> metricPlugin;
    private EventHubClient client;
    private final EventHubsConf ehConf;
    private final NameAndPartition nAndP;
    private PartitionReceiver receiver;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static CachedEventHubsReceiver apply(EventHubsConf eventHubsConf, NameAndPartition nameAndPartition, long l) {
        return CachedEventHubsReceiver$.MODULE$.apply(eventHubsConf, nameAndPartition, l);
    }

    public static RpcEndpointRef partitionPerformanceReceiverRef() {
        return CachedEventHubsReceiver$.MODULE$.partitionPerformanceReceiverRef();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String namespaceUri$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.namespaceUri = this.ehConf.namespaceUri();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.namespaceUri;
    }

    private String namespaceUri() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.namespaceUri$lzycompute() : this.namespaceUri;
    }

    private String consumerGroup$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerGroup = (String)this.ehConf.consumerGroup().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultConsumerGroup());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.consumerGroup;
    }

    private String consumerGroup() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerGroup$lzycompute() : this.consumerGroup;
    }

    private Option<MetricPlugin> metricPlugin$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metricPlugin = this.ehConf.metricPlugin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metricPlugin;
    }

    private Option<MetricPlugin> metricPlugin() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.metricPlugin$lzycompute() : this.metricPlugin;
    }

    private EventHubClient client$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.client = ClientConnectionPool$.MODULE$.borrowClient(this.ehConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.client;
    }

    private EventHubClient client() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.client$lzycompute() : this.client;
    }

    private PartitionReceiver receiver() {
        return this.receiver;
    }

    private void receiver_$eq(PartitionReceiver x$1) {
        this.receiver = x$1;
    }

    private PartitionReceiver createReceiver(long seqNo) {
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") creating receiver for namespaceUri: ", " EventHubNameAndPartition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri(), $this.nAndP})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer group: ", ". seqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerGroup(), BoxesRunTime.boxToLong((long)seqNo)})));
        ReceiverOptions receiverOptions = new ReceiverOptions();
        receiverOptions.setReceiverRuntimeMetricEnabled(true);
        receiverOptions.setPrefetchCount(BoxesRunTime.unboxToInt((Object)this.ehConf.prefetchCount().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultPrefetchCount())));
        receiverOptions.setIdentifier(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkEnv$.MODULE$.get().executorId(), BoxesRunTime.boxToLong((long)taskId)})));
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> EventHubsUtils$.MODULE$.createReceiverInner(this.client(), $this.ehConf.useExclusiveReceiver(), this.consumerGroup(), ((Object)BoxesRunTime.boxToInteger((int)$this.nAndP.partitionId())).toString(), EventPosition$.MODULE$.fromSequenceNumber(seqNo).convert(), receiverOptions);
        int n = RetryUtils$.MODULE$.retryJava$default$3();
        int n2 = RetryUtils$.MODULE$.retryJava$default$4();
        RetryUtils$.MODULE$.retryJava$default$5();
        Future consumer = RetryUtils$.MODULE$.retryJava(intersect, "CachedReceiver creation.", n, n2, null);
        return (PartitionReceiver)Await$.MODULE$.result(consumer, (Duration)this.ehConf.internalOperationTimeout());
    }

    private Future<Object> lastReceivedOffset() {
        return this.receiver().getEventPosition().getSequenceNumber() != null ? Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(this.receiver().getEventPosition().getSequenceNumber()))) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)-1L));
    }

    private Future<Iterable<EventData>> receiveOne(java.time.Duration timeout, String msg) {
        return this.receiveOneWithRetry$1(timeout, msg, 0);
    }

    private Future<Void> closeReceiver() {
        Promise dummyResult = Promise$.MODULE$.apply();
        dummyResult.success(null);
        Function0 & Serializable & scala.Serializable x$5 = (Function0 & Serializable & scala.Serializable)() -> this.receiver().close();
        String x$6 = "closing a receiver";
        Future x$7 = dummyResult.future();
        int x$8 = RetryUtils$.MODULE$.retryJava$default$3();
        int x$9 = RetryUtils$.MODULE$.retryJava$default$4();
        return RetryUtils$.MODULE$.retryJava(x$5, x$6, x$8, x$9, x$7);
    }

    private void recreateReceiver(long seqNo) {
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        long startTimeNs = System.nanoTime();
        Object object = !this.ehConf.useExclusiveReceiver() ? Await$.MODULE$.result(this.closeReceiver(), (Duration)this.ehConf.internalOperationTimeout()) : BoxedUnit.UNIT;
        this.receiver_$eq(this.createReceiver(seqNo));
        long elapsedTimeMs = TimeUnit.NANOSECONDS.toMillis(CachedEventHubsReceiver.elapsedTimeNs$1(startTimeNs));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Finished recreating a receiver for namespaceUri: ", " EventHubNameAndPartition: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " consumer group: ", ": ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)elapsedTimeMs)})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Iterable<EventData>> checkCursor(long requestSeqNo) {
        Future future;
        Iterable<EventData> event;
        long receivedSeqNo;
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        long lastReceivedSeqNo = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(this.lastReceivedOffset(), (Duration)this.ehConf.internalOperationTimeout()));
        if (lastReceivedSeqNo > -1L && lastReceivedSeqNo + 1L != requestSeqNo || !this.receiver().getIsOpen()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") checkCursor. Recreating a receiver for namespaceUri: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventHubNameAndPartition: ", " consumer group: ", ". requestSeqNo: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastReceivedSeqNo: ", ", isOpen: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastReceivedSeqNo), BoxesRunTime.boxToBoolean((boolean)this.receiver().getIsOpen())})));
            this.recreateReceiver(requestSeqNo);
        }
        if ((receivedSeqNo = ((EventData)(event = this.awaitReceiveMessage((Awaitable)this.receiveOne((java.time.Duration)this.ehConf.receiverTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultReceiverTimeout()), "checkCursor initial"), requestSeqNo)).head()).getSystemProperties().getSequenceNumber()) != requestSeqNo) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") checkCursor. Recreating a receiver for namespaceUri: ", " EventHubNameAndPartition:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " consumer group: ", ". requestSeqNo: ", ", receivedSeqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo), BoxesRunTime.boxToLong((long)receivedSeqNo)})));
            this.recreateReceiver(requestSeqNo);
            Iterable<EventData> movedEvent = this.awaitReceiveMessage((Awaitable)this.receiveOne((java.time.Duration)this.ehConf.receiverTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultReceiverTimeout()), "checkCursor move"), requestSeqNo);
            long movedSeqNo = ((EventData)movedEvent.head()).getSystemProperties().getSequenceNumber();
            if (movedSeqNo != requestSeqNo) {
                Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> this.client().getPartitionRuntimeInformation(((Object)BoxesRunTime.boxToInteger((int)$this.nAndP.partitionId())).toString());
                int n = RetryUtils$.MODULE$.retryJava$default$3();
                int n2 = RetryUtils$.MODULE$.retryJava$default$4();
                RetryUtils$.MODULE$.retryJava$default$5();
                PartitionRuntimeInformation info = (PartitionRuntimeInformation)Await$.MODULE$.result(RetryUtils$.MODULE$.retryJava(intersect, "partitionRuntime", n, n2, null), (Duration)this.ehConf.internalOperationTimeout());
                if (requestSeqNo >= info.getBeginSequenceNumber() || movedSeqNo != info.getBeginSequenceNumber()) throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In partition ", " of ", ", with consumer group ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.getPartitionId(), info.getEventHubPath(), this.consumerGroup()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request seqNo ", " is less than the received seqNo ", ". The earliest seqNo is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)requestSeqNo), BoxesRunTime.boxToLong((long)receivedSeqNo)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", the last seqNo is ", ", and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)info.getBeginSequenceNumber()), BoxesRunTime.boxToLong((long)info.getLastEnqueuedSequenceNumber())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received seqNo ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)movedSeqNo)})));
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> movedEvent, ExecutionContext.Implicits$.MODULE$.global());
                return future;
            } else {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> movedEvent, ExecutionContext.Implicits$.MODULE$.global());
            }
            return future;
        } else {
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> event, ExecutionContext.Implicits$.MODULE$.global());
        }
        return future;
    }

    public Iterator<EventData> org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$receive(long requestSeqNo, int batchSize) {
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        long startTimeNs = System.nanoTime();
        Iterable first = (Iterable)Await$.MODULE$.result(this.checkCursor(requestSeqNo), (Duration)this.ehConf.internalOperationTimeout());
        long firstSeqNo = ((EventData)first.head()).getSystemProperties().getSequenceNumber();
        int batchCount = (int)(requestSeqNo + (long)batchSize - firstSeqNo);
        if (batchCount <= 0) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        IndexedSeq theRest = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), batchCount).map((Function1 & Serializable & scala.Serializable)i -> this.awaitReceiveMessage((Awaitable)this.receiveOne((java.time.Duration)this.ehConf.receiverTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultReceiverTimeout()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"receive; ", "; seqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nAndP, BoxesRunTime.boxToLong((long)(requestSeqNo + (long)BoxesRunTime.unboxToInt((Object)i)))}))), requestSeqNo), IndexedSeq$.MODULE$.canBuildFrom());
        Iterable combined = (Iterable)first.$plus$plus((GenTraversableOnce)theRest.flatten((Function1)Predef$.MODULE$.$conforms()), Iterable$.MODULE$.canBuildFrom());
        Iterator sorted = ((IterableLike)combined.toSeq().sortWith((Function2 & Serializable & scala.Serializable)(e1, e2) -> BoxesRunTime.boxToBoolean((boolean)CachedEventHubsReceiver.$anonfun$receive$3(e1, e2)))).iterator();
        Tuple2 tuple2 = sorted.duplicate();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator result = (Iterator)tuple2._1();
        Iterator validate = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)validate);
        Tuple2 tuple23 = tuple22;
        Iterator result2 = (Iterator)tuple23._1();
        Iterator validate2 = (Iterator)tuple23._2();
        long elapsedTimeMs = TimeUnit.NANOSECONDS.toMillis(CachedEventHubsReceiver.elapsedTimeNs$2(startTimeNs));
        if (this.ehConf.slowPartitionAdjustment()) {
            this.sendPartitionPerformanceToDriver(new PartitionPerformanceMetric(this.nAndP, EventHubsUtils$.MODULE$.getTaskContextSlim(), requestSeqNo, batchCount, elapsedTimeMs));
        }
        if (this.metricPlugin().isDefined()) {
            Tuple2 tuple24 = (Tuple2)validate2.map((Function1 & Serializable & scala.Serializable)eventData -> new Tuple2.mcIJ.sp(1, (long)eventData.getBytes().length)).reduceOption((Function2 & Serializable & scala.Serializable)(countAndSize1, countAndSize2) -> new Tuple2.mcIJ.sp(countAndSize1._1$mcI$sp() + countAndSize2._1$mcI$sp(), countAndSize1._2$mcJ$sp() + countAndSize2._2$mcJ$sp())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcIJ.sp(0, 0L));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            int validateSize = tuple24._1$mcI$sp();
            long batchSizeInBytes = tuple24._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(validateSize, batchSizeInBytes);
            Tuple2.mcIJ.sp sp3 = sp2;
            int validateSize2 = sp3._1$mcI$sp();
            long batchSizeInBytes2 = sp3._2$mcJ$sp();
            this.metricPlugin().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.onReceiveMetric(EventHubsUtils$.MODULE$.getTaskContextSlim(), this.nAndP, batchCount, batchSizeInBytes2, elapsedTimeMs);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.assert(validateSize2 == batchCount);
        } else {
            Predef$.MODULE$.assert(validate2.size() == batchCount);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Finished receiving for namespaceUri: ", " EventHubNameAndPartition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri(), $this.nAndP})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer group: ", ", batchSize: ", ", elapsed time: ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerGroup(), BoxesRunTime.boxToInteger((int)batchSize), BoxesRunTime.boxToLong((long)elapsedTimeMs)})));
        return result2;
    }

    private <T> T awaitReceiveMessage(Awaitable<T> awaitable, long requestSeqNo) {
        Object object;
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        try {
            object = Await$.MODULE$.result(awaitable, (Duration)this.ehConf.internalOperationTimeout());
        }
        catch (TimeoutException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") awaitReceiveMessage call failed with timeout. NamespaceUri: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventHubNameAndPartition: ", " consumer group: ", ". requestSeqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo)})));
            this.recreateReceiver(requestSeqNo);
            throw e;
        }
        return (T)object;
    }

    private void sendPartitionPerformanceToDriver(PartitionPerformanceMetric partitionPerformance) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Task: ", ") sends PartitionPerformanceMetric: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventHubsUtils$.MODULE$.getTaskContextSlim()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to the driver."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPerformance})));
        try {
            CachedEventHubsReceiver$.MODULE$.partitionPerformanceReceiverRef().send((Object)partitionPerformance);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Task: ", ") failed to send the RPC message containing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventHubsUtils$.MODULE$.getTaskContextSlim()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PartitionPerformanceMetric: ", " to the driver with error: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPerformance, e})));
        }
    }

    private final Future receiveOneWithRetry$1(java.time.Duration timeout, String msg, int retryCount) {
        Future future;
        if (!this.receiver().getIsOpen() && retryCount < package$.MODULE$.RetryCount()) {
            long taskId = EventHubsUtils$.MODULE$.getTaskId();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") receiver is not opened yet. Will retry {", "} for namespaceUri: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), BoxesRunTime.boxToInteger((int)retryCount), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventHubNameAndPartition: ", " consumer group: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup()})));
            int retry = retryCount + 1;
            future = RetryUtils$.MODULE$.after(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(package$.MODULE$.WaitInterval())).milliseconds(), (Function0 & Serializable & scala.Serializable)() -> this.receiveOneWithRetry$1(timeout, msg, retry), ExecutionContext.Implicits$.MODULE$.global());
        } else {
            this.receiver().setReceiveTimeout(timeout);
            future = RetryUtils$.MODULE$.retryNotNull((Function0 & Serializable & scala.Serializable)() -> this.receiver().receive(1), msg).map((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala(), ExecutionContext.Implicits$.MODULE$.global());
        }
        return future;
    }

    private static final long elapsedTimeNs$1(long startTimeNs$1) {
        return System.nanoTime() - startTimeNs$1;
    }

    private static final long elapsedTimeNs$2(long startTimeNs$2) {
        return System.nanoTime() - startTimeNs$2;
    }

    public static final /* synthetic */ boolean $anonfun$receive$3(EventData e1, EventData e2) {
        return e1.getSystemProperties().getSequenceNumber() < e2.getSystemProperties().getSequenceNumber();
    }

    public CachedEventHubsReceiver(EventHubsConf ehConf, NameAndPartition nAndP, long startSeqNo) {
        this.ehConf = ehConf;
        this.nAndP = nAndP;
        Logging.$init$((Logging)this);
        this.receiver = this.createReceiver(startSeqNo);
    }
}

