/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver$;
import org.apache.spark.eventhubs.PartitionsStatusTracker;
import org.apache.spark.eventhubs.PartitionsStatusTracker$;
import org.apache.spark.eventhubs.TaskContextSlim;
import org.apache.spark.eventhubs.client.Client;
import org.apache.spark.eventhubs.client.EventHubsClient$;
import org.apache.spark.eventhubs.package$;
import org.apache.spark.eventhubs.rdd.EventHubsRDD;
import org.apache.spark.eventhubs.rdd.OffsetRange;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.eventhubs.EventHubsDirectDStream;
import org.apache.spark.util.RpcUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EventHubsUtils$
implements Logging {
    public static EventHubsUtils$ MODULE$;
    private RpcEndpointRef partitionPerformanceReceiverRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new EventHubsUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef partitionPerformanceReceiverRef() {
        return this.partitionPerformanceReceiverRef;
    }

    public void partitionPerformanceReceiverRef_$eq(RpcEndpointRef x$1) {
        this.partitionPerformanceReceiverRef = x$1;
    }

    private void createRpcEndpoint() {
        block2: {
            if (this.partitionPerformanceReceiverRef() != null) break block2;
            try {
                this.partitionPerformanceReceiverRef_$eq(RpcUtils$.MODULE$.makeDriverRef(PartitionPerformanceReceiver$.MODULE$.ENDPOINT_NAME(), SparkEnv$.MODULE$.get().conf(), SparkEnv$.MODULE$.get().rpcEnv()));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is an existing partitionPerformanceReceiverRef on the driver, use that one rather than creating a new one"})).s((Seq)Nil$.MODULE$));
            }
            catch (Exception e) {
                PartitionsStatusTracker partitionsStatusTracker = PartitionsStatusTracker$.MODULE$.getPartitionStatusTracker();
                PartitionPerformanceReceiver partitionPerformanceReceiver = new PartitionPerformanceReceiver(SparkEnv$.MODULE$.get().rpcEnv(), partitionsStatusTracker);
                this.partitionPerformanceReceiverRef_$eq(SparkEnv$.MODULE$.get().rpcEnv().setupEndpoint(PartitionPerformanceReceiver$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)partitionPerformanceReceiver));
            }
        }
    }

    public EventHubsDirectDStream createDirectStream(StreamingContext ssc, EventHubsConf ehConf2) {
        this.createRpcEndpoint();
        return new EventHubsDirectDStream(ssc, ehConf2, (Function1<EventHubsConf, Client>)(Function1 & Serializable & scala.Serializable)ehConf -> EventHubsClient$.MODULE$.apply((EventHubsConf)ehConf));
    }

    public JavaInputDStream<EventData> createDirectStream(JavaStreamingContext jssc, EventHubsConf ehConf) {
        this.createRpcEndpoint();
        return new JavaInputDStream((InputDStream)this.createDirectStream(jssc.ssc(), ehConf), ClassTag$.MODULE$.apply(EventData.class));
    }

    public EventHubsRDD createRDD(SparkContext sc, EventHubsConf ehConf, OffsetRange[] offsetRanges) {
        this.createRpcEndpoint();
        return new EventHubsRDD(sc, ehConf.trimmed(), offsetRanges);
    }

    public JavaRDD<EventData> createRDD(JavaSparkContext jsc, EventHubsConf ehConf, OffsetRange[] offsetRanges) {
        this.createRpcEndpoint();
        return new JavaRDD((RDD)this.createRDD(jsc.sc(), ehConf, offsetRanges), ClassTag$.MODULE$.apply(EventData.class));
    }

    public CompletableFuture<PartitionReceiver> createReceiverInner(EventHubClient client, boolean useExclusiveReceiver, String consumerGroup, String partitionId, EventPosition eventPosition, ReceiverOptions receiverOptions) {
        long taskId = this.getTaskId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") creating receiver for Event Hub partition ", ", consumer group ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), partitionId, consumerGroup})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with epoch receiver option ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)useExclusiveReceiver)})));
        return useExclusiveReceiver ? client.createEpochReceiver(consumerGroup, partitionId, eventPosition, package$.MODULE$.DefaultEpoch(), receiverOptions) : client.createReceiver(consumerGroup, partitionId, eventPosition, receiverOptions);
    }

    public long getTaskId() {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        return taskContext != null ? taskContext.taskAttemptId() : -1L;
    }

    public TaskContextSlim getTaskContextSlim() {
        TaskContext taskContext = TaskContext$.MODULE$.get();
        return taskContext != null ? new TaskContextSlim(taskContext.stageId(), taskContext.taskAttemptId(), taskContext.partitionId(), SparkEnv$.MODULE$.get().executorId()) : new TaskContextSlim(-1, -1L, -1, "");
    }

    public String encode(String inputStr) {
        return Base64.getEncoder().encodeToString(inputStr.getBytes(StandardCharsets.UTF_8));
    }

    public String decode(String inputString) {
        return new String(Base64.getDecoder().decode(inputString), StandardCharsets.UTF_8);
    }

    public String encrypt(String inputStr) {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, this.getSecretKeySpec());
        return Base64.getEncoder().encodeToString(cipher.doFinal(inputStr.getBytes(StandardCharsets.UTF_8)));
    }

    public String decrypt(String inputString) {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, this.getSecretKeySpec());
        return new String(cipher.doFinal(Base64.getDecoder().decode(inputString)), StandardCharsets.UTF_8);
    }

    private SecretKeySpec getSecretKeySpec() {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec keySpec = new PBEKeySpec(package$.MODULE$.SparkConnectorVersion().toCharArray(), package$.MODULE$.SparkConnectorVersion().getBytes(), 1000, 256);
        SecretKey secretKey = secretKeyFactory.generateSecret(keySpec);
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }

    private EventHubsUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.partitionPerformanceReceiverRef = null;
    }
}

