/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs.client;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.PartitionRuntimeInformation;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkEnv$;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.EventHubsUtils$;
import org.apache.spark.eventhubs.EventPosition$;
import org.apache.spark.eventhubs.NameAndPartition;
import org.apache.spark.eventhubs.PartitionPerformanceMetric;
import org.apache.spark.eventhubs.client.CachedEventHubsReceiver$;
import org.apache.spark.eventhubs.client.CachedReceivedData;
import org.apache.spark.eventhubs.client.ClientConnectionPool$;
import org.apache.spark.eventhubs.package$;
import org.apache.spark.eventhubs.utils.MetricPlugin;
import org.apache.spark.eventhubs.utils.RetryUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd!B\u0001\u0003\u0001\ta!aF\"bG\",G-\u0012<f]RDUOY:SK\u000e,\u0017N^3s\u0015\t\u0019A!\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b\u0019\t\u0011\"\u001a<f]RDWOY:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011AcF\u0007\u0002+)\u0011aCB\u0001\tS:$XM\u001d8bY&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h\u0011!Q\u0002A!A!\u0002\u0013a\u0012AB3i\u0007>tgm\u0001\u0001\u0011\u0005uqR\"\u0001\u0003\n\u0005}!!!D#wK:$\b*\u001e2t\u0007>tg\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003\u0015q\u0017I\u001c3Q!\ti2%\u0003\u0002%\t\t\u0001b*Y7f\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005Q1\u000f^1siN+\u0017OT8\u0011\u0005!2dBA\u00155\u001d\tQ3G\u0004\u0002,e9\u0011A&\r\b\u0003[Aj\u0011A\f\u0006\u0003_m\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u00026\t\u00059\u0001/Y2lC\u001e,\u0017BA\u001c9\u00059\u0019V-];f]\u000e,g*^7cKJT!!\u000e\u0003\t\u000bi\u0002A\u0011B\u001e\u0002\rqJg.\u001b;?)\u0011adh\u0010!\u0011\u0005u\u0002Q\"\u0001\u0002\t\u000biI\u0004\u0019\u0001\u000f\t\u000b\u0005J\u0004\u0019\u0001\u0012\t\u000b\u0019J\u0004\u0019A\u0014\u0006\t\t\u0003\u0001a\u0011\u0002\u0016\u0003^\f\u0017\u000e\u001e+j[\u0016|W\u000f^#yG\u0016\u0004H/[8o!\t!5*D\u0001F\u0015\t1u)\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001S%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\taUI\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]\"Aa\n\u0001EC\u0002\u0013%q*\u0001\u0007oC6,7\u000f]1dKV\u0013\u0018.F\u0001Q!\t\tVK\u0004\u0002S'B\u0011QfD\u0005\u0003)>\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011Ak\u0004\u0005\t3\u0002A)\u0019!C\u0005\u001f\u0006i1m\u001c8tk6,'o\u0012:pkBD\u0001b\u0017\u0001\t\u0006\u0004%I\u0001X\u0001\r[\u0016$(/[2QYV<\u0017N\\\u000b\u0002;B\u0019aB\u00181\n\u0005}{!AB(qi&|g\u000e\u0005\u0002bI6\t!M\u0003\u0002d\t\u0005)Q\u000f^5mg&\u0011QM\u0019\u0002\r\u001b\u0016$(/[2QYV<\u0017N\u001c\u0005\t\u0007\u0001A)\u0019!C\u0005OV\t\u0001\u000e\u0005\u0002jc6\t!N\u0003\u0002\u0006W*\u0011A.\\\u0001\u0006Cj,(/\u001a\u0006\u0003]>\f\u0011\"\\5de>\u001cxN\u001a;\u000b\u0003A\f1aY8n\u0013\t\u0011(N\u0001\bFm\u0016tG\u000fS;c\u00072LWM\u001c;\t\u000fQ\u0004\u0001\u0019!C\u0005k\u0006A!/Z2fSZ,'/F\u0001w!\tIw/\u0003\u0002yU\n\t\u0002+\u0019:uSRLwN\u001c*fG\u0016Lg/\u001a:\t\u000fi\u0004\u0001\u0019!C\u0005w\u0006a!/Z2fSZ,'o\u0018\u0013fcR\u0011Ap \t\u0003\u001duL!A`\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003I\u0018\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005\u0015\u0001\u0001)Q\u0005m\u0006I!/Z2fSZ,'\u000f\t\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017\t!bY1dQ\u0016$G)\u0019;b+\t\ti\u0001E\u0002>\u0003\u001fI1!!\u0005\u0003\u0005I\u0019\u0015m\u00195fIJ+7-Z5wK\u0012$\u0015\r^1\t\u0013\u0005U\u0001\u00011A\u0005\n\u0005]\u0011AD2bG\",G\rR1uC~#S-\u001d\u000b\u0004y\u0006e\u0001BCA\u0001\u0003'\t\t\u00111\u0001\u0002\u000e!A\u0011Q\u0004\u0001!B\u0013\ti!A\u0006dC\u000eDW\r\u001a#bi\u0006\u0004\u0003bBA\u0011\u0001\u0011%\u00111E\u0001\u000fGJ,\u0017\r^3SK\u000e,\u0017N^3s)\r1\u0018Q\u0005\u0005\b\u0003O\ty\u00021\u0001(\u0003\u0015\u0019X-\u001d(p\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\t!\u0003\\1tiJ+7-Z5wK\u0012|eMZ:fiR\u0011\u0011q\u0006\t\u0007\u0003c\t)$!\u000f\u000e\u0005\u0005M\"B\u0001$\u0010\u0013\u0011\t9$a\r\u0003\r\u0019+H/\u001e:f!\rq\u00111H\u0005\u0004\u0003{y!\u0001\u0002'p]\u001eDq!!\u0011\u0001\t\u0013\t\u0019%\u0001\u0006sK\u000e,\u0017N^3P]\u0016$b!!\u0012\u0002^\u00055\u0004CBA\u0019\u0003k\t9\u0005\u0005\u0004\u0002J\u0005E\u0013q\u000b\b\u0005\u0003\u0017\nyED\u0002.\u0003\u001bJ\u0011\u0001E\u0005\u0003k=IA!a\u0015\u0002V\tA\u0011\n^3sC\ndWM\u0003\u00026\u001fA\u0019\u0011.!\u0017\n\u0007\u0005m#NA\u0005Fm\u0016tG\u000fR1uC\"A\u0011qLA \u0001\u0004\t\t'A\u0004uS6,w.\u001e;\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001aJ\u0003\u0011!\u0018.\\3\n\t\u0005-\u0014Q\r\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011qNA \u0001\u0004\u0001\u0016aA7tO\"9\u00111\u000f\u0001\u0005\n\u0005U\u0014!D2m_N,'+Z2fSZ,'\u000f\u0006\u0002\u0002xA1\u0011\u0011GA\u001b\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fJ\u0015\u0001\u00027b]\u001eLA!a!\u0002~\t!ak\\5e\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013\u000b\u0001C]3de\u0016\fG/\u001a*fG\u0016Lg/\u001a:\u0015\u0007q\fY\tC\u0004\u0002(\u0005\u0015\u0005\u0019A\u0014\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\u0006Y1\r[3dW\u000e+(o]8s)\u0011\t)%a%\t\u000f\u0005U\u0015Q\u0012a\u0001O\u0005a!/Z9vKN$8+Z9O_\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0015a\u0002:fG\u0016Lg/\u001a\u000b\u0007\u0003;\u000b\u0019+!*\u0011\r\u0005%\u0013qTA,\u0013\u0011\t\t+!\u0016\u0003\u0011%#XM]1u_JDq!!&\u0002\u0018\u0002\u0007q\u0005\u0003\u0005\u0002(\u0006]\u0005\u0019AAU\u0003%\u0011\u0017\r^2i'&TX\rE\u0002\u000f\u0003WK1!!,\u0010\u0005\rIe\u000e\u001e\u0005\b\u0003c\u0003A\u0011BAZ\u0003M\tw/Y5u%\u0016\u001cW-\u001b<f\u001b\u0016\u001c8/Y4f+\u0011\t),a/\u0015\r\u0005]\u0016QZAl!\u0011\tI,a/\r\u0001\u0011A\u0011QXAX\u0005\u0004\tyLA\u0001U#\u0011\t\t-a2\u0011\u00079\t\u0019-C\u0002\u0002F>\u0011qAT8uQ&tw\rE\u0002\u000f\u0003\u0013L1!a3\u0010\u0005\r\te.\u001f\u0005\t\u0003\u001f\fy\u000b1\u0001\u0002R\u0006I\u0011m^1ji\u0006\u0014G.\u001a\t\u0007\u0003c\t\u0019.a.\n\t\u0005U\u00171\u0007\u0002\n\u0003^\f\u0017\u000e^1cY\u0016Dq!!&\u00020\u0002\u0007q\u0005C\u0004\u0002\\\u0002!I!!8\u0002AM,g\u000e\u001a)beRLG/[8o!\u0016\u0014hm\u001c:nC:\u001cW\rV8Ee&4XM\u001d\u000b\u0004y\u0006}\u0007\u0002CAq\u00033\u0004\r!a9\u0002)A\f'\u000f^5uS>t\u0007+\u001a:g_Jl\u0017M\\2f!\ri\u0012Q]\u0005\u0004\u0003O$!A\u0007)beRLG/[8o!\u0016\u0014hm\u001c:nC:\u001cW-T3ue&\u001cw\u0001CAv\u0005!\u0005a!!<\u0002/\r\u000b7\r[3e\u000bZ,g\u000e\u001e%vEN\u0014VmY3jm\u0016\u0014\bcA\u001f\u0002p\u001a9\u0011A\u0001E\u0001\r\u0005E8CBAx\u001b\u0005M8\u0003E\u0002>\u0003kL1!a>\u0003\u00059\u0019\u0015m\u00195fIJ+7-Z5wKJDqAOAx\t\u0003\tY\u0010\u0006\u0002\u0002n\"Q\u0011q`Ax\u0005\u0004%IA!\u0001\u0002'M$\u0018M\u001d;SK\u000eLWM^3s)&lWMT:\u0016\u0005\u0005e\u0002\"\u0003B\u0003\u0003_\u0004\u000b\u0011BA\u001d\u0003Q\u0019H/\u0019:u%\u0016\u001c\u0017.\u001a<feRKW.\u001a(tA\u00159!\u0011BAx\u0001\t-!AC'vi\u0006\u0014G.Z'baV1!Q\u0002B\u0010\u0005K\u0001\u0002Ba\u0004\u0003\u001a\tu!1E\u0007\u0003\u0005#QAAa\u0005\u0003\u0016\u00059Q.\u001e;bE2,'b\u0001B\f\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm!\u0011\u0003\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\tILa\b\u0005\u0011\t\u0005\"q\u0001b\u0001\u0003\u007f\u0013\u0011!\u0011\t\u0005\u0003s\u0013)\u0003\u0002\u0005\u0003(\t\u001d!\u0019AA`\u0005\u0005\u0011\u0005\"\u0003B\u0016\u0003_\u0004\u000b\u0011\u0002B\u0017\u0003%\u0011XmY3jm\u0016\u00148\u000f\u0005\u0004\u0003\u0010\te\u0001\u000b\u0010\u0005\u000b\u0005c\tyO1A\u0005\u0002\tM\u0012a\b9beRLG/[8o!\u0016\u0014hm\u001c:nC:\u001cWMU3dK&4XM\u001d*fMV\u0011!Q\u0007\t\u0005\u0005o\u0011i$\u0004\u0002\u0003:)\u0019!1\b\u0004\u0002\u0007I\u00048-\u0003\u0003\u0003@\te\"A\u0004*qG\u0016sG\r]8j]R\u0014VM\u001a\u0005\n\u0005\u0007\ny\u000f)A\u0005\u0005k\t\u0001\u0005]1si&$\u0018n\u001c8QKJ4wN]7b]\u000e,'+Z2fSZ,'OU3gA!A!qIAx\t\u0013\u0011I%A\u0002lKf$R\u0001\u0015B&\u0005\u001bBaA\u0007B#\u0001\u0004a\u0002BB\u0011\u0003F\u0001\u0007!\u0005C\u0005\u0002\u001a\u0006=H\u0011\t\u0003\u0003RQQ\u0011Q\u0014B*\u0005+\u00129F!\u0017\t\ri\u0011y\u00051\u0001\u001d\u0011\u0019\t#q\na\u0001E!9\u0011Q\u0013B(\u0001\u00049\u0003\u0002CAT\u0005\u001f\u0002\r!!+\t\u0011\tu\u0013q\u001eC\u0001\u0005?\nQ!\u00199qYf$r\u0001\u0010B1\u0005G\u0012)\u0007\u0003\u0004\u001b\u00057\u0002\r\u0001\b\u0005\u0007C\tm\u0003\u0019\u0001\u0012\t\r\u0019\u0012Y\u00061\u0001(\u0001")
public class CachedEventHubsReceiver
implements Logging {
    private String namespaceUri;
    private String consumerGroup;
    private Option<MetricPlugin> metricPlugin;
    private EventHubClient org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client;
    private final EventHubsConf ehConf;
    private final NameAndPartition nAndP;
    private PartitionReceiver receiver;
    private CachedReceivedData cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static CachedEventHubsReceiver apply(EventHubsConf eventHubsConf, NameAndPartition nameAndPartition, long l) {
        return CachedEventHubsReceiver$.MODULE$.apply(eventHubsConf, nameAndPartition, l);
    }

    public static RpcEndpointRef partitionPerformanceReceiverRef() {
        return CachedEventHubsReceiver$.MODULE$.partitionPerformanceReceiverRef();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String namespaceUri$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.namespaceUri = this.ehConf.namespaceUri();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.namespaceUri;
    }

    private String namespaceUri() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.namespaceUri$lzycompute() : this.namespaceUri;
    }

    private String consumerGroup$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerGroup = (String)this.ehConf.consumerGroup().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultConsumerGroup());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.consumerGroup;
    }

    private String consumerGroup() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerGroup$lzycompute() : this.consumerGroup;
    }

    private Option<MetricPlugin> metricPlugin$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metricPlugin = this.ehConf.metricPlugin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metricPlugin;
    }

    private Option<MetricPlugin> metricPlugin() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.metricPlugin$lzycompute() : this.metricPlugin;
    }

    private EventHubClient client$lzycompute() {
        CachedEventHubsReceiver cachedEventHubsReceiver = this;
        synchronized (cachedEventHubsReceiver) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client = ClientConnectionPool$.MODULE$.borrowClient(this.ehConf);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client;
    }

    public EventHubClient org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.client$lzycompute() : this.org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client;
    }

    private PartitionReceiver receiver() {
        return this.receiver;
    }

    private void receiver_$eq(PartitionReceiver x$1) {
        this.receiver = x$1;
    }

    private CachedReceivedData cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(CachedReceivedData x$1) {
        this.cachedData = x$1;
    }

    private PartitionReceiver createReceiver(long seqNo) {
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") creating receiver for namespaceUri: ", " EventHubNameAndPartition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri(), $this.nAndP})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer group: ", ". seqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerGroup(), BoxesRunTime.boxToLong((long)seqNo)})));
        ReceiverOptions receiverOptions = new ReceiverOptions();
        receiverOptions.setReceiverRuntimeMetricEnabled(true);
        receiverOptions.setPrefetchCount(BoxesRunTime.unboxToInt((Object)this.ehConf.prefetchCount().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultPrefetchCount())));
        receiverOptions.setIdentifier(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkEnv$.MODULE$.get().executorId(), BoxesRunTime.boxToLong((long)taskId)})));
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> EventHubsUtils$.MODULE$.createReceiverInner(this.org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client(), $this.ehConf.useExclusiveReceiver(), this.consumerGroup(), ((Object)BoxesRunTime.boxToInteger((int)$this.nAndP.partitionId())).toString(), EventPosition$.MODULE$.fromSequenceNumber(seqNo).convert(), receiverOptions);
        int n = RetryUtils$.MODULE$.retryJava$default$3();
        int n2 = RetryUtils$.MODULE$.retryJava$default$4();
        RetryUtils$.MODULE$.retryJava$default$5();
        Future consumer = RetryUtils$.MODULE$.retryJava(intersect, "CachedReceiver creation.", n, n2, null);
        return (PartitionReceiver)Await$.MODULE$.result(consumer, (Duration)this.ehConf.internalOperationTimeout());
    }

    private Future<Object> lastReceivedOffset() {
        return this.receiver().getEventPosition().getSequenceNumber() != null ? Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(this.receiver().getEventPosition().getSequenceNumber()))) : Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)-1L));
    }

    private Future<Iterable<EventData>> receiveOne(java.time.Duration timeout, String msg) {
        return this.receiveOneWithRetry$1(timeout, msg, 0);
    }

    private Future<Void> closeReceiver() {
        Promise dummyResult = Promise$.MODULE$.apply();
        dummyResult.success(null);
        Function0 & Serializable & scala.Serializable x$5 = (Function0 & Serializable & scala.Serializable)() -> this.receiver().close();
        String x$6 = "closing a receiver";
        Future x$7 = dummyResult.future();
        int x$8 = RetryUtils$.MODULE$.retryJava$default$3();
        int x$9 = RetryUtils$.MODULE$.retryJava$default$4();
        return RetryUtils$.MODULE$.retryJava(x$5, x$6, x$8, x$9, x$7);
    }

    private void recreateReceiver(long seqNo) {
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        long startTimeNs = System.nanoTime();
        Object object = !this.ehConf.useExclusiveReceiver() ? Await$.MODULE$.result(this.closeReceiver(), (Duration)this.ehConf.internalOperationTimeout()) : BoxedUnit.UNIT;
        this.receiver_$eq(this.createReceiver(seqNo));
        long elapsedTimeMs = TimeUnit.NANOSECONDS.toMillis(CachedEventHubsReceiver.elapsedTimeNs$1(startTimeNs));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Finished recreating a receiver for namespaceUri: ", " EventHubNameAndPartition: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " consumer group: ", ": ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)elapsedTimeMs)})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Iterable<EventData>> checkCursor(long requestSeqNo) {
        Future future;
        Iterable<EventData> event;
        long receivedSeqNo;
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        long lastReceivedSeqNo = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(this.lastReceivedOffset(), (Duration)this.ehConf.internalOperationTimeout()));
        if (lastReceivedSeqNo > -1L && lastReceivedSeqNo + 1L != requestSeqNo || !this.receiver().getIsOpen()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") checkCursor. Recreating a receiver for namespaceUri: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventHubNameAndPartition: ", " consumer group: ", ". requestSeqNo: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastReceivedSeqNo: ", ", isOpen: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastReceivedSeqNo), BoxesRunTime.boxToBoolean((boolean)this.receiver().getIsOpen())})));
            this.recreateReceiver(requestSeqNo);
        }
        if ((receivedSeqNo = ((EventData)(event = this.awaitReceiveMessage((Awaitable)this.receiveOne((java.time.Duration)this.ehConf.receiverTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultReceiverTimeout()), "checkCursor initial"), requestSeqNo)).head()).getSystemProperties().getSequenceNumber()) != requestSeqNo) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") checkCursor. Recreating a receiver for namespaceUri: ", " EventHubNameAndPartition:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " consumer group: ", ". requestSeqNo: ", ", receivedSeqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo), BoxesRunTime.boxToLong((long)receivedSeqNo)})));
            this.recreateReceiver(requestSeqNo);
            Iterable<EventData> movedEvent = this.awaitReceiveMessage((Awaitable)this.receiveOne((java.time.Duration)this.ehConf.receiverTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultReceiverTimeout()), "checkCursor move"), requestSeqNo);
            long movedSeqNo = ((EventData)movedEvent.head()).getSystemProperties().getSequenceNumber();
            if (movedSeqNo != requestSeqNo) {
                Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$client().getPartitionRuntimeInformation(((Object)BoxesRunTime.boxToInteger((int)$this.nAndP.partitionId())).toString());
                int n = RetryUtils$.MODULE$.retryJava$default$3();
                int n2 = RetryUtils$.MODULE$.retryJava$default$4();
                RetryUtils$.MODULE$.retryJava$default$5();
                PartitionRuntimeInformation info = (PartitionRuntimeInformation)Await$.MODULE$.result(RetryUtils$.MODULE$.retryJava(intersect, "partitionRuntime", n, n2, null), (Duration)this.ehConf.internalOperationTimeout());
                if (requestSeqNo >= info.getBeginSequenceNumber() || movedSeqNo != info.getBeginSequenceNumber()) throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In partition ", " of ", ", with consumer group ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.getPartitionId(), info.getEventHubPath(), this.consumerGroup()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request seqNo ", " is less than the received seqNo ", ". The earliest seqNo is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)requestSeqNo), BoxesRunTime.boxToLong((long)receivedSeqNo)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", the last seqNo is ", ", and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)info.getBeginSequenceNumber()), BoxesRunTime.boxToLong((long)info.getLastEnqueuedSequenceNumber())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received seqNo ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)movedSeqNo)})));
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> movedEvent, ExecutionContext.Implicits$.MODULE$.global());
                return future;
            } else {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> movedEvent, ExecutionContext.Implicits$.MODULE$.global());
            }
            return future;
        } else {
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> event, ExecutionContext.Implicits$.MODULE$.global());
        }
        return future;
    }

    public Iterator<EventData> org$apache$spark$eventhubs$client$CachedEventHubsReceiver$$receive(long requestSeqNo, int batchSize) {
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        long startTimeNs = System.nanoTime();
        if (this.cachedData().matchSeqNoAndBatchSize(requestSeqNo, batchSize)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Returned data from cache for namespaceUri: ", " EventHubNameAndPartition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri(), $this.nAndP})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer group: ", ", requestSeqNo: ", ", batchSize: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo), BoxesRunTime.boxToInteger((int)batchSize)})));
            return this.cachedData().getCachedDataIterator();
        }
        Iterable first = (Iterable)Await$.MODULE$.result(this.checkCursor(requestSeqNo), (Duration)this.ehConf.internalOperationTimeout());
        long firstSeqNo = ((EventData)first.head()).getSystemProperties().getSequenceNumber();
        int batchCount = (int)(requestSeqNo + (long)batchSize - firstSeqNo);
        if (batchCount <= 0) {
            return scala.package$.MODULE$.Iterator().empty();
        }
        IndexedSeq theRest = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), batchCount).map((Function1 & Serializable & scala.Serializable)i -> this.awaitReceiveMessage((Awaitable)this.receiveOne((java.time.Duration)this.ehConf.receiverTimeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultReceiverTimeout()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"receive; ", "; seqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nAndP, BoxesRunTime.boxToLong((long)(requestSeqNo + (long)BoxesRunTime.unboxToInt((Object)i)))}))), requestSeqNo), IndexedSeq$.MODULE$.canBuildFrom());
        Iterable combined = (Iterable)first.$plus$plus((GenTraversableOnce)theRest.flatten((Function1)Predef$.MODULE$.$conforms()), Iterable$.MODULE$.canBuildFrom());
        Seq sortedSeq = (Seq)combined.toSeq().sortWith((Function2 & Serializable & scala.Serializable)(e1, e2) -> BoxesRunTime.boxToBoolean((boolean)CachedEventHubsReceiver.$anonfun$receive$4(e1, e2)));
        this.cachedData_$eq(new CachedReceivedData(requestSeqNo, batchSize, (Seq<EventData>)sortedSeq));
        Iterator sorted = sortedSeq.iterator();
        Tuple2 tuple2 = sorted.duplicate();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator result = (Iterator)tuple2._1();
        Iterator validate = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)validate);
        Tuple2 tuple23 = tuple22;
        Iterator result2 = (Iterator)tuple23._1();
        Iterator validate2 = (Iterator)tuple23._2();
        long elapsedTimeMs = TimeUnit.NANOSECONDS.toMillis(CachedEventHubsReceiver.elapsedTimeNs$2(startTimeNs));
        if (this.ehConf.slowPartitionAdjustment()) {
            this.sendPartitionPerformanceToDriver(new PartitionPerformanceMetric(this.nAndP, EventHubsUtils$.MODULE$.getTaskContextSlim(), requestSeqNo, batchCount, elapsedTimeMs));
        }
        if (this.metricPlugin().isDefined()) {
            Tuple2 tuple24 = (Tuple2)validate2.map((Function1 & Serializable & scala.Serializable)eventData -> new Tuple2.mcIJ.sp(1, (long)eventData.getBytes().length)).reduceOption((Function2 & Serializable & scala.Serializable)(countAndSize1, countAndSize2) -> new Tuple2.mcIJ.sp(countAndSize1._1$mcI$sp() + countAndSize2._1$mcI$sp(), countAndSize1._2$mcJ$sp() + countAndSize2._2$mcJ$sp())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcIJ.sp(0, 0L));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            int validateSize = tuple24._1$mcI$sp();
            long batchSizeInBytes = tuple24._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(validateSize, batchSizeInBytes);
            Tuple2.mcIJ.sp sp3 = sp2;
            int validateSize2 = sp3._1$mcI$sp();
            long batchSizeInBytes2 = sp3._2$mcJ$sp();
            this.metricPlugin().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.onReceiveMetric(EventHubsUtils$.MODULE$.getTaskContextSlim(), this.nAndP, batchCount, batchSizeInBytes2, elapsedTimeMs);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.assert(validateSize2 == batchCount);
        } else {
            Predef$.MODULE$.assert(validate2.size() == batchCount);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Finished receiving for namespaceUri: ", " EventHubNameAndPartition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri(), $this.nAndP})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"consumer group: ", ", batchSize: ", ", elapsed time: ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.consumerGroup(), BoxesRunTime.boxToInteger((int)batchSize), BoxesRunTime.boxToLong((long)elapsedTimeMs)})));
        return result2;
    }

    private <T> T awaitReceiveMessage(Awaitable<T> awaitable, long requestSeqNo) {
        Object object;
        long taskId = EventHubsUtils$.MODULE$.getTaskId();
        try {
            object = Await$.MODULE$.result(awaitable, (Duration)this.ehConf.internalOperationTimeout());
        }
        catch (TimeoutException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") awaitReceiveMessage call failed with timeout. NamespaceUri: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventHubNameAndPartition: ", " consumer group: ", ". requestSeqNo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup(), BoxesRunTime.boxToLong((long)requestSeqNo)})));
            this.recreateReceiver(requestSeqNo);
            throw e;
        }
        return (T)object;
    }

    private void sendPartitionPerformanceToDriver(PartitionPerformanceMetric partitionPerformance) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Task: ", ") sends PartitionPerformanceMetric: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventHubsUtils$.MODULE$.getTaskContextSlim()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to the driver."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPerformance})));
        try {
            CachedEventHubsReceiver$.MODULE$.partitionPerformanceReceiverRef().send((Object)partitionPerformance);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Task: ", ") failed to send the RPC message containing "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EventHubsUtils$.MODULE$.getTaskContextSlim()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PartitionPerformanceMetric: ", " to the driver with error: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionPerformance, e})));
        }
    }

    private final Future receiveOneWithRetry$1(java.time.Duration timeout, String msg, int retryCount) {
        Future future;
        if (!this.receiver().getIsOpen() && retryCount < package$.MODULE$.RetryCount()) {
            long taskId = EventHubsUtils$.MODULE$.getTaskId();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") receiver is not opened yet. Will retry {", "} for namespaceUri: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)taskId), BoxesRunTime.boxToInteger((int)retryCount), this.namespaceUri()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EventHubNameAndPartition: ", " consumer group: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.nAndP, this.consumerGroup()})));
            int retry = retryCount + 1;
            future = RetryUtils$.MODULE$.after(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(package$.MODULE$.WaitInterval())).milliseconds(), (Function0 & Serializable & scala.Serializable)() -> this.receiveOneWithRetry$1(timeout, msg, retry), ExecutionContext.Implicits$.MODULE$.global());
        } else {
            this.receiver().setReceiveTimeout(timeout);
            future = RetryUtils$.MODULE$.retryNotNull((Function0 & Serializable & scala.Serializable)() -> this.receiver().receive(1), msg).map((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala(), ExecutionContext.Implicits$.MODULE$.global());
        }
        return future;
    }

    private static final long elapsedTimeNs$1(long startTimeNs$1) {
        return System.nanoTime() - startTimeNs$1;
    }

    private static final long elapsedTimeNs$2(long startTimeNs$2) {
        return System.nanoTime() - startTimeNs$2;
    }

    public static final /* synthetic */ boolean $anonfun$receive$4(EventData e1, EventData e2) {
        return e1.getSystemProperties().getSequenceNumber() < e2.getSystemProperties().getSequenceNumber();
    }

    public CachedEventHubsReceiver(EventHubsConf ehConf, NameAndPartition nAndP, long startSeqNo) {
        this.ehConf = ehConf;
        this.nAndP = nAndP;
        Logging.$init$((Logging)this);
        this.receiver = this.createReceiver(startSeqNo);
        this.cachedData = new CachedReceivedData(-1L, -1, null);
    }
}

