/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs.client;

import com.microsoft.azure.eventhubs.EventHubClient;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.client.ClientConnectionPool;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;

public final class ClientConnectionPool$
implements Logging {
    public static ClientConnectionPool$ MODULE$;
    private final HashMap<String, ClientConnectionPool> pools;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ClientConnectionPool$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String notInitializedMessage(String name) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection pool is not initialized for EventHubs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
    }

    private boolean isInitialized(String key) {
        boolean bl;
        HashMap<String, ClientConnectionPool> hashMap = this.pools;
        synchronized (hashMap) {
            bl = this.pools.get((Object)key).isDefined();
        }
        return bl;
    }

    private void ensureInitialized(String key) {
        if (!this.isInitialized(key)) {
            String message = this.notInitializedMessage(key);
            throw new IllegalStateException(message);
        }
    }

    private String key(EventHubsConf ehConf) {
        return ehConf.connectionString().toLowerCase();
    }

    private ClientConnectionPool get(String key) {
        ClientConnectionPool clientConnectionPool;
        HashMap<String, ClientConnectionPool> hashMap = this.pools;
        synchronized (hashMap) {
            clientConnectionPool = (ClientConnectionPool)this.pools.getOrElse((Object)key, (Function0 & java.io.Serializable & Serializable)() -> {
                String message = this.notInitializedMessage(key);
                throw new IllegalStateException(message);
            });
        }
        return clientConnectionPool;
    }

    public EventHubClient borrowClient(EventHubsConf ehConf) {
        HashMap<String, ClientConnectionPool> hashMap = this.pools;
        synchronized (hashMap) {
            if (!this.isInitialized(this.key(ehConf))) {
                this.pools.update((Object)this.key(ehConf), (Object)new ClientConnectionPool(ehConf));
            }
        }
        ClientConnectionPool pool = this.get(this.key(ehConf));
        return pool.org$apache$spark$eventhubs$client$ClientConnectionPool$$borrowClient();
    }

    public void returnClient(EventHubsConf ehConf, EventHubClient client) {
        this.ensureInitialized(this.key(ehConf));
        ClientConnectionPool pool = this.get(this.key(ehConf));
        pool.org$apache$spark$eventhubs$client$ClientConnectionPool$$returnClient(client);
    }

    private ClientConnectionPool$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.pools = new HashMap();
    }
}

