/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.eventhubs.rdd;

import com.microsoft.azure.eventhubs.EventData;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.client.CachedEventHubsReceiver$;
import org.apache.spark.eventhubs.client.CachedReceiver;
import org.apache.spark.eventhubs.rdd.EventHubsRDDPartition;
import org.apache.spark.eventhubs.rdd.HasOffsetRanges;
import org.apache.spark.eventhubs.rdd.OffsetRange;
import org.apache.spark.eventhubs.utils.SimulatedCachedReceiver$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0001\u0019a!\u0001D#wK:$\b*\u001e2t%\u0012#%BA\u0002\u0005\u0003\r\u0011H\r\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a<f]RDWOY:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u001eGA\u0019a\u0002\u0005\n\u000e\u0003=Q!a\u0001\u0004\n\u0005Ey!a\u0001*E\tB\u00111cG\u0007\u0002))\u0011Q!\u0006\u0006\u0003-]\tQ!\u0019>ve\u0016T!\u0001G\r\u0002\u00135L7M]8t_\u001a$(\"\u0001\u000e\u0002\u0007\r|W.\u0003\u0002\u001d)\tIQI^3oi\u0012\u000bG/\u0019\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003E}\u0011q\u0001T8hO&tw\r\u0005\u0002%K5\t!!\u0003\u0002'\u0005\ty\u0001*Y:PM\u001a\u001cX\r\u001e*b]\u001e,7\u000f\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003+\u0003\t\u00198m\u0001\u0001\u0011\u0005-bS\"\u0001\u0004\n\u000552!\u0001D*qCJ\\7i\u001c8uKb$\b\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\r\u0015D7i\u001c8g+\u0005\t\u0004C\u0001\u001a4\u001b\u0005!\u0011B\u0001\u001b\u0005\u00055)e/\u001a8u\u0011V\u00147oQ8oM\"Aa\u0007\u0001B\u0001B\u0003%\u0011'A\u0004fQ\u000e{gN\u001a\u0011\t\u0011a\u0002!Q1A\u0005\u0002e\nAb\u001c4gg\u0016$(+\u00198hKN,\u0012A\u000f\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0011\n\u0015B\u0001\"\u0003\u0005-yeMZ:fiJ\u000bgnZ3\t\u0011\u0011\u0003!\u0011!Q\u0001\ni\nQb\u001c4gg\u0016$(+\u00198hKN\u0004\u0003\"\u0002$\u0001\t\u00039\u0015A\u0002\u001fj]&$h\b\u0006\u0003I\u0013*[\u0005C\u0001\u0013\u0001\u0011\u0015AS\t1\u0001+\u0011\u0015yS\t1\u00012\u0011\u0015AT\t1\u0001;\u0011\u0015i\u0005\u0001\"\u0011O\u000359W\r\u001e)beRLG/[8ogV\tq\nE\u0002<}A\u0003\"aK)\n\u0005I3!!\u0003)beRLG/[8o\u0011\u0015!\u0006\u0001\"\u0011V\u0003\u0015\u0019w.\u001e8u)\u00051\u0006CA\u001eX\u0013\tAFH\u0001\u0003M_:<\u0007\"\u0002.\u0001\t\u0003Z\u0016aB5t\u000b6\u0004H/\u001f\u000b\u00029B\u00111(X\u0005\u0003=r\u0012qAQ8pY\u0016\fg\u000eC\u0003a\u0001\u0011\u0005\u0013-\u0001\u0003uC.,GC\u00012d!\rYdH\u0005\u0005\u0006I~\u0003\r!Z\u0001\u0004]Vl\u0007CA\u001eg\u0013\t9GHA\u0002J]RDQ!\u001b\u0001\u0005B)\fQcZ3u!J,g-\u001a:sK\u0012dunY1uS>t7\u000f\u0006\u0002l\u007fB\u0019A\u000e^<\u000f\u00055\u0014hB\u00018r\u001b\u0005y'B\u00019*\u0003\u0019a$o\\8u}%\tQ(\u0003\u0002ty\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005\r\u0019V-\u001d\u0006\u0003gr\u0002\"\u0001\u001f?\u000f\u0005eT\bC\u00018=\u0013\tYH(\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>=\u0011\u0019\t\t\u0001\u001ba\u0001!\u0006)1\u000f\u001d7ji\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0011\u0001E3se\n+w-\u001b8BMR,'/\u00128e)\r9\u0018\u0011\u0002\u0005\t\u0003\u0017\t\u0019\u00011\u0001\u0002\u000e\u0005!\u0001/\u0019:u!\r!\u0013qB\u0005\u0004\u0003#\u0011!!F#wK:$\b*\u001e2t%\u0012#\u0005+\u0019:uSRLwN\u001c\u0005\b\u0003+\u0001A\u0011IA\f\u0003\u001d\u0019w.\u001c9vi\u0016$b!!\u0007\u0002 \u0005\r\u0002\u0003\u00027\u0002\u001cII1!!\bw\u0005!IE/\u001a:bi>\u0014\bbBA\u0011\u0003'\u0001\r\u0001U\u0001\na\u0006\u0014H/\u001b;j_:D\u0001\"!\n\u0002\u0014\u0001\u0007\u0011qE\u0001\bG>tG/\u001a=u!\rY\u0013\u0011F\u0005\u0004\u0003W1!a\u0003+bg.\u001cuN\u001c;fqR\u0004")
public class EventHubsRDD
extends RDD<EventData>
implements HasOffsetRanges {
    private final EventHubsConf ehConf;
    private final OffsetRange[] offsetRanges;

    public EventHubsConf ehConf() {
        return this.ehConf;
    }

    @Override
    public OffsetRange[] offsetRanges() {
        return this.offsetRanges;
    }

    public Partition[] getPartitions() {
        return (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partitionId()), (Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)o -> new EventHubsRDDPartition(o.partitionId(), o.nameAndPartition(), o.fromSeqNo(), o.untilSeqNo(), o.preferredLoc()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.count()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public EventData[] take(int num) {
        EventHubsRDDPartition[] nonEmptyPartitions = (EventHubsRDDPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitions())).map((Function1 & Serializable & scala.Serializable)x$3 -> (EventHubsRDDPartition)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EventHubsRDDPartition.class))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EventHubsRDD.$anonfun$take$2(x$4)));
        if (num < 1 || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).isEmpty()) {
            return (EventData[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(EventData.class));
        }
        Map parts = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(result, part) -> {
            Map map;
            int remain = num - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (remain > 0) {
                long taken = Math.min((long)remain, part.count());
                map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
            } else {
                map = result;
            }
            return map;
        });
        return (EventData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.context().runJob((RDD)this, (Function2 & Serializable & scala.Serializable)(tc, it) -> (EventData[])it.take(BoxesRunTime.unboxToInt((Object)parts.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(EventData.class)), (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(EventData.class))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(EventData.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        EventHubsRDDPartition part = (EventHubsRDDPartition)split;
        return (Seq)part.preferredLoc().map((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    private String errBeginAfterEnd(EventHubsRDDPartition part) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The beginning sequence number ", " is larger than the ending "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.fromSeqNo())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sequence number ", " for EventHubs ", " on partition "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.untilSeqNo()), part.name()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)part.partitionId())}));
    }

    public Iterator<EventData> compute(Partition partition, TaskContext context) {
        Iterator<EventData> iterator;
        EventHubsRDDPartition part = (EventHubsRDDPartition)partition;
        Predef$.MODULE$.assert(part.fromSeqNo() <= part.untilSeqNo(), (Function0 & Serializable & scala.Serializable)() -> this.errBeginAfterEnd(part));
        if (part.fromSeqNo() == part.untilSeqNo()) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Beginning sequence number ", " is equal to the ending sequence "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)context.taskAttemptId()), BoxesRunTime.boxToLong((long)part.fromSeqNo())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number ", ". Returning empty partition for EH: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.untilSeqNo()), part.name()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on partition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)part.partitionId())})));
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(TID ", ") Computing EventHubs ", ", partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)context.taskAttemptId()), part.name(), BoxesRunTime.boxToInteger((int)part.partitionId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sequence numbers ", " => ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)part.fromSeqNo()), BoxesRunTime.boxToLong((long)part.untilSeqNo())})));
            CachedReceiver cachedReceiver = this.ehConf().useSimulatedClient() ? SimulatedCachedReceiver$.MODULE$ : CachedEventHubsReceiver$.MODULE$;
            iterator = cachedReceiver.receive(this.ehConf(), part.nameAndPartition(), part.fromSeqNo(), (int)(part.untilSeqNo() - part.fromSeqNo()));
        }
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$take$2(EventHubsRDDPartition x$4) {
        return x$4.count() > 0L;
    }

    public EventHubsRDD(SparkContext sc, EventHubsConf ehConf, OffsetRange[] offsetRanges) {
        this.ehConf = ehConf;
        this.offsetRanges = offsetRanges;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(EventData.class));
    }
}

