/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.eventhubs;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.spark.SparkEnv$;
import org.apache.spark.eventhubs.EventHubsConf;
import org.apache.spark.eventhubs.EventHubsConf$;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver;
import org.apache.spark.eventhubs.PartitionPerformanceReceiver$;
import org.apache.spark.eventhubs.PartitionsStatusTracker;
import org.apache.spark.eventhubs.PartitionsStatusTracker$;
import org.apache.spark.eventhubs.client.Client;
import org.apache.spark.eventhubs.client.EventHubsClient$;
import org.apache.spark.eventhubs.package$;
import org.apache.spark.eventhubs.rdd.EventHubsRDD;
import org.apache.spark.eventhubs.utils.SimulatedClient$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.json4s.jackson.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EventHubsSourceProvider$
implements scala.Serializable {
    public static EventHubsSourceProvider$ MODULE$;
    private final PartitionsStatusTracker partitionsStatusTracker;
    private final PartitionPerformanceReceiver partitionPerformanceReceiver;
    private final RpcEndpointRef partitionPerformanceReceiverRef;

    static {
        new EventHubsSourceProvider$();
    }

    public PartitionsStatusTracker partitionsStatusTracker() {
        return this.partitionsStatusTracker;
    }

    public PartitionPerformanceReceiver partitionPerformanceReceiver() {
        return this.partitionPerformanceReceiver;
    }

    public RpcEndpointRef partitionPerformanceReceiverRef() {
        return this.partitionPerformanceReceiverRef;
    }

    public StructType eventHubsSchema() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("body", (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("partition", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("offset", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("sequenceNumber", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("enqueuedTime", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("publisher", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("partitionKey", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("properties", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), true, StructField$.MODULE$.apply$default$4()), new StructField("systemProperties", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), true, StructField$.MODULE$.apply$default$4())})));
    }

    public RDD<InternalRow> toInternalRow(EventHubsRDD rdd) {
        return rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(p, iter) -> iter.map((Function1 & Serializable & scala.Serializable)ed -> InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ed.getBytes(), UTF8String.fromString((String)((Object)BoxesRunTime.boxToInteger((int)p)).toString()), UTF8String.fromString((String)ed.getSystemProperties().getOffset()), BoxesRunTime.boxToLong((long)ed.getSystemProperties().getSequenceNumber()), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(ed.getSystemProperties().getEnqueuedTime().toEpochMilli()))), UTF8String.fromString((String)ed.getSystemProperties().getPublisher()), UTF8String.fromString((String)ed.getSystemProperties().getPartitionKey()), ArrayBasedMapData$.MODULE$.apply((Map)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(ed.getProperties()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof Binary) {
                Binary binary = (Binary)object2;
                ByteBuffer buf = binary.asByteBuffer();
                byte[] arr = new byte[buf.remaining()];
                buf.get(arr);
                object = arr;
            } else if (object2 instanceof Decimal128) {
                Decimal128 decimal128 = (Decimal128)object2;
                object = decimal128.asBytes();
            } else if (object2 instanceof Decimal32) {
                Decimal32 decimal32 = (Decimal32)object2;
                object = BoxesRunTime.boxToInteger((int)decimal32.getBits());
            } else if (object2 instanceof Decimal64) {
                Decimal64 decimal64 = (Decimal64)object2;
                object = BoxesRunTime.boxToLong((long)decimal64.getBits());
            } else if (object2 instanceof Symbol) {
                Symbol symbol = (Symbol)object2;
                object = symbol.toString();
            } else if (object2 instanceof UnsignedByte) {
                UnsignedByte unsignedByte = (UnsignedByte)object2;
                object = unsignedByte.toString();
            } else if (object2 instanceof UnsignedInteger) {
                UnsignedInteger unsignedInteger = (UnsignedInteger)object2;
                object = unsignedInteger.toString();
            } else if (object2 instanceof UnsignedLong) {
                UnsignedLong unsignedLong = (UnsignedLong)object2;
                object = unsignedLong.toString();
            } else if (object2 instanceof UnsignedShort) {
                UnsignedShort unsignedShort = (UnsignedShort)object2;
                object = unsignedShort.toString();
            } else if (object2 instanceof Character) {
                Character c = (Character)object2;
                object = c.toString();
            } else if (object2 instanceof DescribedType) {
                DescribedType describedType = (DescribedType)object2;
                object = describedType.getDescribed();
            } else {
                object = object2;
            }
            return object;
        }).map((Function1 & Serializable & scala.Serializable)p -> {
            Tuple2 tuple2;
            Object object = p._2();
            if (object instanceof String) {
                String string = (String)object;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UTF8String.fromString((String)((String)p._1()))), (Object)UTF8String.fromString((String)string));
            } else {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UTF8String.fromString((String)((String)p._1()))), (Object)UTF8String.fromString((String)Serialization$.MODULE$.write(p._2(), package$.MODULE$.formats())));
            }
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3()), ArrayBasedMapData$.MODULE$.apply((Map)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)ed.getSystemProperties()).asScala()).$minus$minus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$.MODULE$.OffsetAnnotation(), package$.MODULE$.SequenceNumberAnnotation(), package$.MODULE$.EnqueuedTimeAnnotation()}))).mapValues((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object object;
            Object object2 = x0$2;
            if (object2 instanceof Binary) {
                Binary binary = (Binary)object2;
                ByteBuffer buf = binary.asByteBuffer();
                byte[] arr = new byte[buf.remaining()];
                buf.get(arr);
                object = arr;
            } else {
                object = object2;
            }
            return object;
        }).map((Function1 & Serializable & scala.Serializable)p -> {
            Tuple2 tuple2;
            Object object = p._2();
            if (object instanceof String) {
                String string = (String)object;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UTF8String.fromString((String)((String)p._1()))), (Object)UTF8String.fromString((String)string));
            } else {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UTF8String.fromString((String)((String)p._1()))), (Object)UTF8String.fromString((String)Serialization$.MODULE$.write(p._2(), package$.MODULE$.formats())));
            }
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3())}))), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public Function1<EventHubsConf, Client> clientFactory(scala.collection.immutable.Map<String, String> parameters) {
        return new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)EventHubsConf$.MODULE$.UseSimulatedClientKey().toLowerCase(), (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.DefaultUseSimulatedClient()))).toBoolean() ? (Function1 & Serializable & scala.Serializable)ehConf -> SimulatedClient$.MODULE$.apply((EventHubsConf)ehConf) : (Function1 & Serializable & scala.Serializable)ehConf -> EventHubsClient$.MODULE$.apply((EventHubsConf)ehConf);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private EventHubsSourceProvider$() {
        MODULE$ = this;
        this.partitionsStatusTracker = PartitionsStatusTracker$.MODULE$.getPartitionStatusTracker();
        this.partitionPerformanceReceiver = new PartitionPerformanceReceiver(SparkEnv$.MODULE$.get().rpcEnv(), this.partitionsStatusTracker());
        this.partitionPerformanceReceiverRef = SparkEnv$.MODULE$.get().rpcEnv().setupEndpoint(PartitionPerformanceReceiver$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)this.partitionPerformanceReceiver());
    }
}

