/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataUtil;
import com.microsoft.azure.eventhubs.PartitionReceiver;
import com.microsoft.azure.eventhubs.PartitionSender;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.IllegalEntityException;
import com.microsoft.azure.servicebus.IteratorUtil;
import com.microsoft.azure.servicebus.MessageSender;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.RetryPolicy;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public class EventHubClient
extends ClientEntity {
    public static final String DEFAULT_CONSUMER_GROUP_NAME = "$Default";
    private final String eventHubName;
    private final Object senderCreateSync;
    private MessagingFactory underlyingFactory;
    private MessageSender sender;
    private boolean isSenderCreateStarted;
    private CompletableFuture<Void> createSender;

    private EventHubClient(ConnectionStringBuilder connectionString) throws IOException, IllegalEntityException {
        super(StringUtil.getRandomString(), null);
        this.eventHubName = connectionString.getEntityPath();
        this.senderCreateSync = new Object();
    }

    public static EventHubClient createFromConnectionStringSync(String connectionString) throws ServiceBusException, IOException {
        return EventHubClient.createFromConnectionStringSync(connectionString, null);
    }

    public static EventHubClient createFromConnectionStringSync(String connectionString, RetryPolicy retryPolicy) throws ServiceBusException, IOException {
        try {
            return EventHubClient.createFromConnectionString(connectionString, retryPolicy).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public static CompletableFuture<EventHubClient> createFromConnectionString(String connectionString) throws ServiceBusException, IOException {
        return EventHubClient.createFromConnectionString(connectionString, null);
    }

    public static CompletableFuture<EventHubClient> createFromConnectionString(String connectionString, RetryPolicy retryPolicy) throws ServiceBusException, IOException {
        ConnectionStringBuilder connStr = new ConnectionStringBuilder(connectionString);
        final EventHubClient eventHubClient = new EventHubClient(connStr);
        return MessagingFactory.createFromConnectionString(connectionString.toString(), retryPolicy).thenApply(new Function<MessagingFactory, EventHubClient>(){

            @Override
            public EventHubClient apply(MessagingFactory factory) {
                eventHubClient.underlyingFactory = factory;
                return eventHubClient;
            }
        });
    }

    public final void sendSync(EventData data) throws ServiceBusException {
        block5: {
            try {
                this.send(data).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    public final CompletableFuture<Void> send(final EventData data) {
        if (data == null) {
            throw new IllegalArgumentException("EventData cannot be empty.");
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClient.this.sender.send(data.toAmqpMessage());
            }
        });
    }

    public final void sendSync(Iterable<EventData> eventDatas) throws ServiceBusException {
        block5: {
            try {
                this.send(eventDatas).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    public final CompletableFuture<Void> send(final Iterable<EventData> eventDatas) {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClient.this.sender.send(EventDataUtil.toAmqpMessages(eventDatas));
            }
        });
    }

    public final void sendSync(EventData eventData, String partitionKey) throws ServiceBusException {
        block5: {
            try {
                this.send(eventData, partitionKey).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    public final CompletableFuture<Void> send(final EventData eventData, final String partitionKey) {
        if (eventData == null) {
            throw new IllegalArgumentException("EventData cannot be null.");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null");
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClient.this.sender.send(eventData.toAmqpMessage(partitionKey));
            }
        });
    }

    public final void sendSync(Iterable<EventData> eventDatas, String partitionKey) throws ServiceBusException {
        block5: {
            try {
                this.send(eventDatas, partitionKey).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable;
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if ((throwable = exception.getCause()) == null) break block5;
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
        }
    }

    public final CompletableFuture<Void> send(final Iterable<EventData> eventDatas, final String partitionKey) {
        if (eventDatas == null || IteratorUtil.sizeEquals(eventDatas, 0)) {
            throw new IllegalArgumentException("Empty batch of EventData cannot be sent.");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null");
        }
        if (partitionKey.length() > 128) {
            throw new IllegalArgumentException(String.format(Locale.US, "PartitionKey exceeds the maximum allowed length of partitionKey: {0}", 128));
        }
        return this.createInternalSender().thenCompose(new Function<Void, CompletableFuture<Void>>(){

            @Override
            public CompletableFuture<Void> apply(Void voidArg) {
                return EventHubClient.this.sender.send(EventDataUtil.toAmqpMessages(eventDatas, partitionKey));
            }
        });
    }

    public final PartitionSender createPartitionSenderSync(String partitionId) throws ServiceBusException, IllegalArgumentException {
        try {
            return this.createPartitionSender(partitionId).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionSender> createPartitionSender(String partitionId) throws ServiceBusException {
        return PartitionSender.Create(this.underlyingFactory, this.eventHubName, partitionId);
    }

    public final PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, String startingOffset) throws ServiceBusException {
        try {
            return this.createReceiver(consumerGroupName, partitionId, startingOffset).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, String startingOffset) throws ServiceBusException {
        return this.createReceiver(consumerGroupName, partitionId, startingOffset, false);
    }

    public final PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive) throws ServiceBusException {
        try {
            return this.createReceiver(consumerGroupName, partitionId, startingOffset, offsetInclusive).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive) throws ServiceBusException {
        return this.createReceiver(consumerGroupName, partitionId, startingOffset, offsetInclusive, null);
    }

    public final PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, Instant dateTime) throws ServiceBusException {
        try {
            return this.createReceiver(consumerGroupName, partitionId, dateTime).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, Instant dateTime) throws ServiceBusException {
        return this.createReceiver(consumerGroupName, partitionId, dateTime, null);
    }

    public final PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, String startingOffset, ReceiverOptions receiverOptions) throws ServiceBusException {
        try {
            return this.createReceiver(consumerGroupName, partitionId, startingOffset, receiverOptions).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, String startingOffset, ReceiverOptions receiverOptions) throws ServiceBusException {
        return this.createReceiver(consumerGroupName, partitionId, startingOffset, false, receiverOptions);
    }

    public final PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, ReceiverOptions receiverOptions) throws ServiceBusException {
        try {
            return this.createReceiver(consumerGroupName, partitionId, startingOffset, offsetInclusive, receiverOptions).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, ReceiverOptions receiverOptions) throws ServiceBusException {
        return PartitionReceiver.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, startingOffset, offsetInclusive, null, 0L, false, receiverOptions);
    }

    public final PartitionReceiver createReceiverSync(String consumerGroupName, String partitionId, Instant dateTime, ReceiverOptions receiverOptions) throws ServiceBusException {
        try {
            return this.createReceiver(consumerGroupName, partitionId, dateTime, receiverOptions).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createReceiver(String consumerGroupName, String partitionId, Instant dateTime, ReceiverOptions receiverOptions) throws ServiceBusException {
        return PartitionReceiver.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, null, false, dateTime, 0L, false, receiverOptions);
    }

    public final PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, String startingOffset, long epoch) throws ServiceBusException {
        try {
            return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, epoch).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, String startingOffset, long epoch) throws ServiceBusException {
        return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, false, epoch);
    }

    public final PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, long epoch) throws ServiceBusException {
        try {
            return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, offsetInclusive, epoch).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, long epoch) throws ServiceBusException {
        return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, offsetInclusive, epoch, null);
    }

    public final PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, Instant dateTime, long epoch) throws ServiceBusException {
        try {
            return this.createEpochReceiver(consumerGroupName, partitionId, dateTime, epoch).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, Instant dateTime, long epoch) throws ServiceBusException {
        return this.createEpochReceiver(consumerGroupName, partitionId, dateTime, epoch, null);
    }

    public final PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, String startingOffset, long epoch, ReceiverOptions receiverOptions) throws ServiceBusException {
        try {
            return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, epoch, receiverOptions).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, String startingOffset, long epoch, ReceiverOptions receiverOptions) throws ServiceBusException {
        return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, false, epoch, receiverOptions);
    }

    public final PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, long epoch, ReceiverOptions receiverOptions) throws ServiceBusException {
        try {
            return this.createEpochReceiver(consumerGroupName, partitionId, startingOffset, offsetInclusive, epoch, receiverOptions).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, long epoch, ReceiverOptions receiverOptions) throws ServiceBusException {
        return PartitionReceiver.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, startingOffset, offsetInclusive, null, epoch, true, receiverOptions);
    }

    public final PartitionReceiver createEpochReceiverSync(String consumerGroupName, String partitionId, Instant dateTime, long epoch, ReceiverOptions receiverOptions) throws ServiceBusException {
        try {
            return this.createEpochReceiver(consumerGroupName, partitionId, dateTime, epoch, receiverOptions).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public final CompletableFuture<PartitionReceiver> createEpochReceiver(String consumerGroupName, String partitionId, Instant dateTime, long epoch, ReceiverOptions receiverOptions) throws ServiceBusException {
        return PartitionReceiver.create(this.underlyingFactory, this.eventHubName, consumerGroupName, partitionId, null, false, dateTime, epoch, true, receiverOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> onClose() {
        if (this.underlyingFactory != null) {
            Object object = this.senderCreateSync;
            synchronized (object) {
                CompletableFuture<Void> internalSenderClose = this.sender != null ? this.sender.close().thenCompose(new Function<Void, CompletableFuture<Void>>(){

                    @Override
                    public CompletableFuture<Void> apply(Void voidArg) {
                        return EventHubClient.this.underlyingFactory.close();
                    }
                }) : this.underlyingFactory.close();
                return internalSenderClose;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> createInternalSender() {
        if (!this.isSenderCreateStarted) {
            Object object = this.senderCreateSync;
            synchronized (object) {
                if (!this.isSenderCreateStarted) {
                    this.createSender = MessageSender.create(this.underlyingFactory, StringUtil.getRandomString(), this.eventHubName).thenAccept((Consumer)new Consumer<MessageSender>(){

                        @Override
                        public void accept(MessageSender a) {
                            EventHubClient.this.sender = a;
                        }
                    });
                    this.isSenderCreateStarted = true;
                }
            }
        }
        return this.createSender;
    }
}

