/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataUtil;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import com.microsoft.azure.eventhubs.ReceivePump;
import com.microsoft.azure.eventhubs.ReceiverOptions;
import com.microsoft.azure.eventhubs.ReceiverRuntimeInformation;
import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.IReceiverSettingsProvider;
import com.microsoft.azure.servicebus.MessageReceiver;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.PassByRef;
import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnknownDescribedType;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.message.Message;

public final class PartitionReceiver
extends ClientEntity
implements IReceiverSettingsProvider {
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private static final int MINIMUM_PREFETCH_COUNT = 10;
    private static final int MAXIMUM_PREFETCH_COUNT = 999;
    static final int DEFAULT_PREFETCH_COUNT = 999;
    static final long NULL_EPOCH = 0L;
    public static final String START_OF_STREAM = "-1";
    private final String partitionId;
    private final MessagingFactory underlyingFactory;
    private final String eventHubName;
    private final String consumerGroupName;
    private final Object receiveHandlerLock;
    private String startingOffset;
    private boolean offsetInclusive;
    private Instant startingDateTime;
    private MessageReceiver internalReceiver;
    private Long epoch;
    private boolean isEpochReceiver;
    private ReceivePump receivePump;
    private ReceiverOptions receiverOptions;
    private ReceiverRuntimeInformation runtimeInformation;

    private PartitionReceiver(MessagingFactory factory, String eventHubName, String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, Instant dateTime, Long epoch, boolean isEpochReceiver, ReceiverOptions receiverOptions) throws ServiceBusException {
        super(null, null);
        this.underlyingFactory = factory;
        this.eventHubName = eventHubName;
        this.consumerGroupName = consumerGroupName;
        this.partitionId = partitionId;
        this.startingOffset = startingOffset;
        this.offsetInclusive = offsetInclusive;
        this.startingDateTime = dateTime;
        this.epoch = epoch;
        this.isEpochReceiver = isEpochReceiver;
        this.receiveHandlerLock = new Object();
        this.receiverOptions = receiverOptions;
        if (this.receiverOptions != null && this.receiverOptions.getReceiverRuntimeMetricEnabled()) {
            this.runtimeInformation = new ReceiverRuntimeInformation(partitionId);
        }
    }

    static CompletableFuture<PartitionReceiver> create(MessagingFactory factory, String eventHubName, String consumerGroupName, String partitionId, String startingOffset, boolean offsetInclusive, Instant dateTime, long epoch, boolean isEpochReceiver, ReceiverOptions receiverOptions) throws ServiceBusException {
        if (epoch < 0L) {
            throw new IllegalArgumentException("epoch cannot be a negative value. Please specify a zero or positive long value.");
        }
        if (StringUtil.isNullOrWhiteSpace(consumerGroupName)) {
            throw new IllegalArgumentException("specify valid string for argument - 'consumerGroupName'");
        }
        final PartitionReceiver receiver = new PartitionReceiver(factory, eventHubName, consumerGroupName, partitionId, startingOffset, offsetInclusive, dateTime, epoch, isEpochReceiver, receiverOptions);
        return receiver.createInternalReceiver().thenApply(new Function<Void, PartitionReceiver>(){

            @Override
            public PartitionReceiver apply(Void a) {
                return receiver;
            }
        });
    }

    private CompletableFuture<Void> createInternalReceiver() throws ServiceBusException {
        return MessageReceiver.create(this.underlyingFactory, StringUtil.getRandomString(), String.format("%s/ConsumerGroups/%s/Partitions/%s", this.eventHubName, this.consumerGroupName, this.partitionId), 999, this).thenAccept((Consumer)new Consumer<MessageReceiver>(){

            @Override
            public void accept(MessageReceiver r) {
                PartitionReceiver.this.internalReceiver = r;
            }
        });
    }

    final String getStartingOffset() {
        return this.startingOffset;
    }

    final boolean getOffsetInclusive() {
        return this.offsetInclusive;
    }

    public final String getPartitionId() {
        return this.partitionId;
    }

    public final int getPrefetchCount() {
        return this.internalReceiver.getPrefetchCount();
    }

    public final Duration getReceiveTimeout() {
        return this.internalReceiver.getReceiveTimeout();
    }

    public void setReceiveTimeout(Duration value) {
        this.internalReceiver.setReceiveTimeout(value);
    }

    public final void setPrefetchCount(int prefetchCount) throws ServiceBusException {
        if (prefetchCount < 10 || prefetchCount > 999) {
            throw new IllegalArgumentException(String.format(Locale.US, "PrefetchCount has to be between %s and %s", 10, 999));
        }
        this.internalReceiver.setPrefetchCount(prefetchCount);
    }

    public final long getEpoch() {
        return this.epoch;
    }

    public final ReceiverRuntimeInformation getRuntimeInformation() {
        return this.runtimeInformation;
    }

    public final Iterable<EventData> receiveSync(int maxEventCount) throws ServiceBusException {
        try {
            return this.receive(maxEventCount).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Throwable throwable;
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if ((throwable = exception.getCause()) != null) {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof ServiceBusException) {
                    throw (ServiceBusException)throwable;
                }
                throw new ServiceBusException(true, throwable);
            }
            return null;
        }
    }

    public CompletableFuture<Iterable<EventData>> receive(int maxEventCount) {
        return this.internalReceiver.receive(maxEventCount).thenApply(new Function<Collection<Message>, Iterable<EventData>>(){

            @Override
            public Iterable<EventData> apply(Collection<Message> amqpMessages) {
                DeliveryAnnotations deliveryAnnotations;
                PassByRef lastMessageRef = null;
                if (PartitionReceiver.this.receiverOptions != null && PartitionReceiver.this.receiverOptions.getReceiverRuntimeMetricEnabled()) {
                    lastMessageRef = new PassByRef();
                }
                LinkedList<EventData> events = EventDataUtil.toEventDataCollection(amqpMessages, lastMessageRef);
                if (lastMessageRef != null && lastMessageRef.get() != null && (deliveryAnnotations = ((Message)lastMessageRef.get()).getDeliveryAnnotations()) != null && deliveryAnnotations.getValue() != null) {
                    Map deliveryAnnotationsMap = deliveryAnnotations.getValue();
                    PartitionReceiver.this.runtimeInformation.setRuntimeInformation((Long)deliveryAnnotationsMap.get(ClientConstants.LAST_ENQUEUED_SEQUENCE_NUMBER), ((Date)deliveryAnnotationsMap.get(ClientConstants.LAST_ENQUEUED_TIME_UTC)).toInstant(), (String)deliveryAnnotationsMap.get(ClientConstants.LAST_ENQUEUED_OFFSET));
                }
                return events;
            }
        });
    }

    public CompletableFuture<Void> setReceiveHandler(PartitionReceiveHandler receiveHandler) {
        return this.setReceiveHandler(receiveHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> setReceiveHandler(PartitionReceiveHandler receiveHandler, boolean invokeWhenNoEvents) {
        Object object = this.receiveHandlerLock;
        synchronized (object) {
            if (receiveHandler == null) {
                if (this.receivePump != null && this.receivePump.isRunning()) {
                    return this.receivePump.stop();
                }
            } else {
                if (this.receivePump != null && this.receivePump.isRunning()) {
                    throw new IllegalArgumentException("Unexpected value for parameter 'receiveHandler'. PartitionReceiver was already registered with a PartitionReceiveHandler instance. Only 1 instance can be registered.");
                }
                this.receivePump = new ReceivePump(new ReceivePump.IPartitionReceiver(){

                    @Override
                    public Iterable<EventData> receive(int maxBatchSize) throws ServiceBusException {
                        return PartitionReceiver.this.receiveSync(maxBatchSize);
                    }

                    @Override
                    public String getPartitionId() {
                        return PartitionReceiver.this.getPartitionId();
                    }
                }, receiveHandler, invokeWhenNoEvents);
                Thread onReceivePumpThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PartitionReceiver.this.receivePump.run();
                    }
                });
                onReceivePumpThread.start();
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public CompletableFuture<Void> onClose() {
        if (this.receivePump != null && this.receivePump.isRunning()) {
            this.receivePump.stop();
        }
        if (this.internalReceiver != null) {
            return this.internalReceiver.close();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Map<Symbol, UnknownDescribedType> getFilter(Message lastReceivedMessage) {
        UnknownDescribedType filter;
        if (lastReceivedMessage == null && this.startingOffset == null) {
            long totalMilliSeconds;
            block7: {
                try {
                    totalMilliSeconds = this.startingDateTime.toEpochMilli();
                }
                catch (ArithmeticException ex) {
                    totalMilliSeconds = Long.MAX_VALUE;
                    if (!TRACE_LOGGER.isLoggable(Level.WARNING)) break block7;
                    TRACE_LOGGER.log(Level.WARNING, String.format("receiverPath[%s], action[createReceiveLink], warning[starting receiver from epoch+Long.Max]", this.internalReceiver.getReceivePath()));
                }
            }
            filter = new UnknownDescribedType((Object)AmqpConstants.STRING_FILTER, (Object)String.format("amqp.annotation.%s >%s '%s'", "x-opt-enqueued-time", "", totalMilliSeconds));
        } else {
            String lastReceivedOffset;
            boolean offsetInclusiveFlag;
            if (lastReceivedMessage != null) {
                offsetInclusiveFlag = false;
                lastReceivedOffset = lastReceivedMessage.getMessageAnnotations().getValue().get(AmqpConstants.OFFSET).toString();
            } else {
                offsetInclusiveFlag = this.offsetInclusive;
                lastReceivedOffset = this.startingOffset;
            }
            if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                String logReceivePath = "";
                logReceivePath = this.internalReceiver == null ? "receiverPath[RECEIVER IS NULL]" : "receiverPath[" + this.internalReceiver.getReceivePath() + "]";
                TRACE_LOGGER.log(Level.FINE, String.format("%s, action[createReceiveLink], offset[%s], offsetInclusive[%s]", logReceivePath, lastReceivedOffset, offsetInclusiveFlag));
            }
            filter = new UnknownDescribedType((Object)AmqpConstants.STRING_FILTER, (Object)String.format("amqp.annotation.%s >%s '%s'", "x-opt-offset", offsetInclusiveFlag ? "=" : "", lastReceivedOffset));
        }
        return Collections.singletonMap(AmqpConstants.STRING_FILTER, filter);
    }

    @Override
    public Map<Symbol, Object> getProperties() {
        return this.isEpochReceiver ? Collections.singletonMap(AmqpConstants.EPOCH, this.epoch) : null;
    }

    @Override
    public Symbol[] getDesiredCapabilities() {
        Symbol[] symbolArray;
        if (this.receiverOptions != null && this.receiverOptions.getReceiverRuntimeMetricEnabled()) {
            Symbol[] symbolArray2 = new Symbol[1];
            symbolArray = symbolArray2;
            symbolArray2[0] = AmqpConstants.ENABLE_RECEIVER_RUNTIME_METRIC_NAME;
        } else {
            symbolArray = null;
        }
        return symbolArray;
    }
}

