/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientEntity;
import com.microsoft.azure.servicebus.Timer;
import com.microsoft.azure.servicebus.TimerType;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActiveClientTokenManager {
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private ScheduledFuture timer;
    private final Object timerLock;
    private final Runnable sendTokenTask;
    private final ClientEntity clientEntity;
    private final Duration tokenRefreshInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveClientTokenManager(ClientEntity clientEntity, Runnable sendTokenAsync, Duration tokenRefreshInterval) {
        this.sendTokenTask = sendTokenAsync;
        this.clientEntity = clientEntity;
        this.tokenRefreshInterval = tokenRefreshInterval;
        Object object = this.timerLock = new Object();
        synchronized (object) {
            this.timer = Timer.schedule(new TimerCallback(), tokenRefreshInterval, TimerType.OneTimeRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.timerLock;
        synchronized (object) {
            this.timer.cancel(false);
        }
    }

    private class TimerCallback
    implements Runnable {
        private TimerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ActiveClientTokenManager.this.clientEntity.getIsClosingOrClosed()) {
                ActiveClientTokenManager.this.sendTokenTask.run();
                Object object = ActiveClientTokenManager.this.timerLock;
                synchronized (object) {
                    ActiveClientTokenManager.this.timer = Timer.schedule(new TimerCallback(), ActiveClientTokenManager.this.tokenRefreshInterval, TimerType.OneTimeRun);
                }
            } else if (TRACE_LOGGER.isLoggable(Level.FINE)) {
                TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "clientEntity[%s] - closing ActiveClientLinkManager", ActiveClientTokenManager.this.clientEntity.getClientId()));
            }
        }
    }
}

