/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ExceptionUtil;
import com.microsoft.azure.servicebus.FaultTolerantObject;
import com.microsoft.azure.servicebus.ISessionProvider;
import com.microsoft.azure.servicebus.amqp.AmqpException;
import com.microsoft.azure.servicebus.amqp.AmqpResponseCode;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import com.microsoft.azure.servicebus.amqp.IOperation;
import com.microsoft.azure.servicebus.amqp.IOperationResult;
import com.microsoft.azure.servicebus.amqp.ReactorDispatcher;
import com.microsoft.azure.servicebus.amqp.RequestResponseChannel;
import java.util.HashMap;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;

public class CBSChannel {
    final FaultTolerantObject<RequestResponseChannel> innerChannel;
    final ISessionProvider sessionProvider;
    final IAmqpConnection connectionEventDispatcher;

    public CBSChannel(ISessionProvider sessionProvider, IAmqpConnection connection, String linkName) {
        this.sessionProvider = sessionProvider;
        this.connectionEventDispatcher = connection;
        this.innerChannel = new FaultTolerantObject<RequestResponseChannel>(new OpenRequestResponseChannel(), new CloseRequestResponseChannel());
    }

    public void sendToken(final ReactorDispatcher dispatcher, String token, String tokenAudience, final IOperationResult<Void, Exception> sendTokenCallback) {
        final Message request = Proton.message();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("operation", "put-token");
        properties.put("type", "servicebus.windows.net:sastoken");
        properties.put("name", tokenAudience);
        ApplicationProperties applicationProperties = new ApplicationProperties(properties);
        request.setApplicationProperties(applicationProperties);
        request.setBody((Section)new AmqpValue((Object)token));
        this.innerChannel.runOnOpenedObject(dispatcher, new IOperationResult<RequestResponseChannel, Exception>(){

            @Override
            public void onComplete(RequestResponseChannel result) {
                result.request(dispatcher, request, new IOperationResult<Message, Exception>(){

                    @Override
                    public void onComplete(Message response) {
                        int statusCode = (Integer)response.getApplicationProperties().getValue().get("status-code");
                        String statusDescription = (String)response.getApplicationProperties().getValue().get("status-description");
                        if (statusCode == AmqpResponseCode.ACCEPTED.getValue() || statusCode == AmqpResponseCode.OK.getValue()) {
                            sendTokenCallback.onComplete(null);
                        } else {
                            this.onError(ExceptionUtil.amqpResponseCodeToException(statusCode, statusDescription));
                        }
                    }

                    @Override
                    public void onError(Exception error) {
                        sendTokenCallback.onError(error);
                    }
                });
            }

            @Override
            public void onError(Exception error) {
                sendTokenCallback.onError(error);
            }
        });
    }

    public void close(ReactorDispatcher reactorDispatcher, IOperationResult<Void, Exception> closeCallback) {
        this.innerChannel.close(reactorDispatcher, closeCallback);
    }

    private class CloseRequestResponseChannel
    implements IOperation<Void> {
        private CloseRequestResponseChannel() {
        }

        @Override
        public void run(final IOperationResult<Void, Exception> closeOperationCallback) {
            RequestResponseChannel channelToBeClosed = CBSChannel.this.innerChannel.unsafeGetIfOpened();
            if (channelToBeClosed == null) {
                closeOperationCallback.onComplete(null);
            } else {
                channelToBeClosed.close(new IOperationResult<Void, Exception>(){

                    @Override
                    public void onComplete(Void result) {
                        closeOperationCallback.onComplete(result);
                    }

                    @Override
                    public void onError(Exception error) {
                        closeOperationCallback.onError(error);
                    }
                });
            }
        }
    }

    private class OpenRequestResponseChannel
    implements IOperation<RequestResponseChannel> {
        private OpenRequestResponseChannel() {
        }

        @Override
        public void run(final IOperationResult<RequestResponseChannel, Exception> operationCallback) {
            Session session = CBSChannel.this.sessionProvider.getSession("cbs-session", null, new BiConsumer<ErrorCondition, Exception>(){

                @Override
                public void accept(ErrorCondition error, Exception exception) {
                    if (error != null) {
                        operationCallback.onError(new AmqpException(error));
                    } else if (exception != null) {
                        operationCallback.onError(exception);
                    }
                }
            });
            if (session == null) {
                return;
            }
            final RequestResponseChannel requestResponseChannel = new RequestResponseChannel("cbs", "$cbs", session);
            requestResponseChannel.open(new IOperationResult<Void, Exception>(){

                @Override
                public void onComplete(Void result) {
                    CBSChannel.this.connectionEventDispatcher.registerForConnectionError((Link)requestResponseChannel.getSendLink());
                    CBSChannel.this.connectionEventDispatcher.registerForConnectionError((Link)requestResponseChannel.getReceiveLink());
                    operationCallback.onComplete(requestResponseChannel);
                }

                @Override
                public void onError(Exception error) {
                    operationCallback.onError(error);
                }
            }, new IOperationResult<Void, Exception>(){

                @Override
                public void onComplete(Void result) {
                    CBSChannel.this.connectionEventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                    CBSChannel.this.connectionEventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
                }

                @Override
                public void onError(Exception error) {
                    CBSChannel.this.connectionEventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                    CBSChannel.this.connectionEventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
                }
            });
        }
    }
}

