/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import java.time.Duration;
import org.apache.qpid.proton.amqp.Symbol;

public final class ClientConstants {
    public static final int AMQPS_PORT = 5671;
    public static final int MAX_PARTITION_KEY_LENGTH = 128;
    public static final Symbol SERVER_BUSY_ERROR = Symbol.getSymbol((String)"com.microsoft:server-busy");
    public static final Symbol ARGUMENT_ERROR = Symbol.getSymbol((String)"com.microsoft:argument-error");
    public static final Symbol ARGUMENT_OUT_OF_RANGE_ERROR = Symbol.getSymbol((String)"com.microsoft:argument-out-of-range");
    public static final Symbol ENTITY_DISABLED_ERROR = Symbol.getSymbol((String)"com.microsoft:entity-disabled");
    public static final Symbol PARTITION_NOT_OWNED_ERROR = Symbol.getSymbol((String)"com.microsoft:partition-not-owned");
    public static final Symbol STORE_LOCK_LOST_ERROR = Symbol.getSymbol((String)"com.microsoft:store-lock-lost");
    public static final Symbol PUBLISHER_REVOKED_ERROR = Symbol.getSymbol((String)"com.microsoft:publisher-revoked");
    public static final Symbol TIMEOUT_ERROR = Symbol.getSymbol((String)"com.microsoft:timeout");
    public static final Symbol TRACKING_ID_PROPERTY = Symbol.getSymbol((String)"com.microsoft:tracking-id");
    public static final int MAX_MESSAGE_LENGTH_BYTES = 262144;
    public static final int MAX_FRAME_SIZE_BYTES = 65536;
    public static final int MAX_EVENTHUB_AMQP_HEADER_SIZE_BYTES = 512;
    public static final Duration TIMER_TOLERANCE = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_RERTRY_MIN_BACKOFF = Duration.ofSeconds(0L);
    public static final Duration DEFAULT_RERTRY_MAX_BACKOFF = Duration.ofSeconds(30L);
    public static final Duration TOKEN_REFRESH_INTERVAL = Duration.ofMinutes(20L);
    public static final int DEFAULT_MAX_RETRY_COUNT = 10;
    public static final String SERVICEBUS_CLIENT_TRACE = "servicebus.trace";
    public static final boolean DEFAULT_IS_TRANSIENT = true;
    public static final int SESSION_OPEN_TIMEOUT_IN_MS = 15000;
    public static final int REACTOR_IO_POLL_TIMEOUT = 20;
    public static final int SERVER_BUSY_BASE_SLEEP_TIME_IN_SECS = 4;
    public static final String NO_RETRY = "NoRetry";
    public static final String DEFAULT_RETRY = "Default";
    public static final String PRODUCT_NAME = "MSJavaClient";
    public static final String CURRENT_JAVACLIENT_VERSION = "0.13.1";
    public static final String PLATFORM_INFO = ClientConstants.getPlatformInfo();
    public static final String CBS_ADDRESS = "$cbs";
    public static final String PUT_TOKEN_OPERATION = "operation";
    public static final String PUT_TOKEN_OPERATION_VALUE = "put-token";
    public static final String PUT_TOKEN_TYPE = "type";
    public static final String SAS_TOKEN_TYPE = "servicebus.windows.net:sastoken";
    public static final String PUT_TOKEN_AUDIENCE = "name";
    public static final String PUT_TOKEN_EXPIRY = "expiration";
    public static final String PUT_TOKEN_STATUS_CODE = "status-code";
    public static final String PUT_TOKEN_STATUS_DESCRIPTION = "status-description";
    public static final String MANAGEMENT_ADDRESS = "$management";
    public static final String MANAGEMENT_EVENTHUB_ENTITY_TYPE = "com.microsoft:eventhub";
    public static final String MANAGEMENT_PARTITION_ENTITY_TYPE = "com.microsoft:partition";
    public static final String MANAGEMENT_OPERATION_KEY = "operation";
    public static final String READ_OPERATION_VALUE = "READ";
    public static final String MANAGEMENT_ENTITY_TYPE_KEY = "type";
    public static final String MANAGEMENT_ENTITY_NAME_KEY = "name";
    public static final String MANAGEMENT_PARTITION_NAME_KEY = "partition";
    public static final String MANAGEMENT_SECURITY_TOKEN_KEY = "security_token";
    public static final String MANAGEMENT_RESULT_PARTITION_IDS = "partition_ids";
    public static final String MANAGEMENT_RESULT_PARTITION_COUNT = "partition_count";
    public static final String MANAGEMENT_RESULT_BEGIN_SEQUENCE_NUMBER = "begin_sequence_number";
    public static final String MANAGEMENT_RESULT_LAST_ENQUEUED_SEQUENCE_NUMBER = "last_enqueued_sequence_number";
    public static final String MANAGEMENT_RESULT_LAST_ENQUEUED_OFFSET = "last_enqueued_offset";
    public static final String MANAGEMENT_RESULT_LAST_ENQUEUED_TIME_UTC = "last_enqueued_time_utc";
    public static final String MANAGEMENT_STATUS_CODE_KEY = "status-code";
    public static final String MANAGEMENT_STATUS_DESCRIPTION_KEY = "status-description";
    public static final String MANAGEMENT_RESPONSE_ERROR_CONDITION = "error-condition";
    public static final Symbol LAST_ENQUEUED_SEQUENCE_NUMBER = Symbol.valueOf((String)"last_enqueued_sequence_number");
    public static final Symbol LAST_ENQUEUED_OFFSET = Symbol.valueOf((String)"last_enqueued_offset");
    public static final Symbol LAST_ENQUEUED_TIME_UTC = Symbol.valueOf((String)"last_enqueued_time_utc");
    public static final String AMQP_PUT_TOKEN_FAILED_ERROR = "Put token failed. status-code: %s, status-description: %s";
    public static final String TOKEN_AUDIENCE_FORMAT = "amqp://%s/%s";

    private ClientConstants() {
    }

    private static String getPlatformInfo() {
        Package javaRuntimeClassPkg = Runtime.class.getPackage();
        StringBuilder patformInfo = new StringBuilder();
        patformInfo.append("jre:");
        patformInfo.append(javaRuntimeClassPkg.getImplementationVersion());
        patformInfo.append(";vendor:");
        patformInfo.append(javaRuntimeClassPkg.getImplementationVendor());
        patformInfo.append(";jvm:");
        patformInfo.append(System.getProperty("java.vm.version"));
        patformInfo.append(";arch:");
        patformInfo.append(System.getProperty("os.arch"));
        patformInfo.append(";os:");
        patformInfo.append(System.getProperty("os.name"));
        patformInfo.append(";os version:");
        patformInfo.append(System.getProperty("os.version"));
        return patformInfo.toString();
    }
}

