/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.amqp.DispatchHandler;
import com.microsoft.azure.servicebus.amqp.IIOObject;
import com.microsoft.azure.servicebus.amqp.IOperation;
import com.microsoft.azure.servicebus.amqp.IOperationResult;
import com.microsoft.azure.servicebus.amqp.ReactorDispatcher;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FaultTolerantObject<T extends IIOObject> {
    final IOperation<T> openTask;
    final IOperation<Void> closeTask;
    final Queue<IOperationResult<T, Exception>> openCallbacks;
    final Queue<IOperationResult<Void, Exception>> closeCallbacks;
    T innerObject;
    boolean creatingNewInnerObject;
    boolean closingInnerObject;

    public FaultTolerantObject(IOperation<T> openAsync, IOperation<Void> closeAsync) {
        this.openTask = openAsync;
        this.closeTask = closeAsync;
        this.openCallbacks = new ConcurrentLinkedQueue<IOperationResult<T, Exception>>();
        this.closeCallbacks = new ConcurrentLinkedQueue<IOperationResult<Void, Exception>>();
    }

    public T unsafeGetIfOpened() {
        if (this.innerObject != null && this.innerObject.getState() == IIOObject.IOObjectState.OPENED) {
            return this.innerObject;
        }
        return null;
    }

    public void runOnOpenedObject(ReactorDispatcher dispatcher, final IOperationResult<T, Exception> openCallback) {
        try {
            dispatcher.invoke(new DispatchHandler(){

                @Override
                public void onEvent() {
                    if (!(FaultTolerantObject.this.creatingNewInnerObject || FaultTolerantObject.this.innerObject != null && FaultTolerantObject.this.innerObject.getState() != IIOObject.IOObjectState.CLOSED && FaultTolerantObject.this.innerObject.getState() != IIOObject.IOObjectState.CLOSING)) {
                        FaultTolerantObject.this.creatingNewInnerObject = true;
                        FaultTolerantObject.this.openCallbacks.offer(openCallback);
                        FaultTolerantObject.this.openTask.run(new IOperationResult<T, Exception>(){

                            @Override
                            public void onComplete(T result) {
                                FaultTolerantObject.this.creatingNewInnerObject = false;
                                FaultTolerantObject.this.innerObject = result;
                                for (IOperationResult iOperationResult : FaultTolerantObject.this.openCallbacks) {
                                    iOperationResult.onComplete(result);
                                }
                                FaultTolerantObject.this.openCallbacks.clear();
                            }

                            @Override
                            public void onError(Exception error) {
                                FaultTolerantObject.this.creatingNewInnerObject = false;
                                for (IOperationResult iOperationResult : FaultTolerantObject.this.openCallbacks) {
                                    iOperationResult.onError(error);
                                }
                                FaultTolerantObject.this.openCallbacks.clear();
                            }
                        });
                    } else if (FaultTolerantObject.this.innerObject != null && FaultTolerantObject.this.innerObject.getState() == IIOObject.IOObjectState.OPENED) {
                        openCallback.onComplete(FaultTolerantObject.this.innerObject);
                    } else {
                        FaultTolerantObject.this.openCallbacks.offer(openCallback);
                    }
                }
            });
        }
        catch (IOException ioException) {
            openCallback.onError(ioException);
        }
    }

    public void close(ReactorDispatcher dispatcher, final IOperationResult<Void, Exception> closeCallback) {
        try {
            dispatcher.invoke(new DispatchHandler(){

                @Override
                public void onEvent() {
                    if (FaultTolerantObject.this.innerObject == null || FaultTolerantObject.this.innerObject.getState() == IIOObject.IOObjectState.CLOSED) {
                        closeCallback.onComplete(null);
                    } else if (!(FaultTolerantObject.this.closingInnerObject || FaultTolerantObject.this.innerObject.getState() != IIOObject.IOObjectState.OPENED && FaultTolerantObject.this.innerObject.getState() != IIOObject.IOObjectState.OPENING)) {
                        FaultTolerantObject.this.closingInnerObject = true;
                        FaultTolerantObject.this.closeCallbacks.offer(closeCallback);
                        FaultTolerantObject.this.closeTask.run(new IOperationResult<Void, Exception>(){

                            @Override
                            public void onComplete(Void result) {
                                FaultTolerantObject.this.closingInnerObject = false;
                                for (IOperationResult iOperationResult : FaultTolerantObject.this.closeCallbacks) {
                                    iOperationResult.onComplete(result);
                                }
                                FaultTolerantObject.this.closeCallbacks.clear();
                            }

                            @Override
                            public void onError(Exception error) {
                                FaultTolerantObject.this.closingInnerObject = false;
                                for (IOperationResult iOperationResult : FaultTolerantObject.this.closeCallbacks) {
                                    iOperationResult.onError(error);
                                }
                                FaultTolerantObject.this.closeCallbacks.clear();
                            }
                        });
                    } else {
                        FaultTolerantObject.this.closeCallbacks.offer(closeCallback);
                    }
                }
            });
        }
        catch (IOException ioException) {
            closeCallback.onError(ioException);
        }
    }
}

