/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ErrorContext;
import com.microsoft.azure.servicebus.StringUtil;
import java.util.Locale;

public class ServiceBusException
extends Exception {
    private static final long serialVersionUID = -3654294093967132325L;
    private boolean isTransient;
    private ErrorContext errorContext;

    ServiceBusException(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public ServiceBusException(boolean isTransient, String message) {
        super(message);
        this.isTransient = isTransient;
    }

    public ServiceBusException(boolean isTransient, Throwable cause) {
        super(cause);
        this.isTransient = isTransient;
    }

    public ServiceBusException(boolean isTransient, String message, Throwable cause) {
        super(message, cause);
        this.isTransient = isTransient;
    }

    @Override
    public String getMessage() {
        String baseMessage = super.getMessage();
        return this.errorContext == null || StringUtil.isNullOrEmpty(this.errorContext.toString()) ? baseMessage : (!StringUtil.isNullOrEmpty(baseMessage) ? String.format(Locale.US, "%s, %s[%s]", baseMessage, "errorContext", this.errorContext.toString()) : String.format(Locale.US, "%s[%s]", "errorContext", this.errorContext.toString()));
    }

    public boolean getIsTransient() {
        return this.isTransient;
    }

    public ErrorContext getContext() {
        return this.errorContext;
    }

    void setContext(ErrorContext errorContext) {
        this.errorContext = errorContext;
    }
}

