/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.StringUtil;
import java.time.Instant;
import org.apache.qpid.proton.engine.Session;

public final class TrackingUtil {
    public static final String TRACKING_ID_TOKEN_SEPARATOR = "_";

    private TrackingUtil() {
    }

    static String parseRoleIdentifier(String trackingId) {
        if (StringUtil.isNullOrWhiteSpace(trackingId) || !trackingId.contains(TRACKING_ID_TOKEN_SEPARATOR)) {
            return null;
        }
        return trackingId.substring(trackingId.indexOf(TRACKING_ID_TOKEN_SEPARATOR));
    }

    public static String getLinkName(Session session) {
        String linkNamePrefix = StringUtil.getRandomString();
        String linkNameWithServiceRoleTracker = session.getConnection() != null && !StringUtil.isNullOrEmpty(session.getConnection().getRemoteContainer()) ? linkNamePrefix.concat(TRACKING_ID_TOKEN_SEPARATOR).concat(session.getConnection().getRemoteContainer().substring(Math.max(session.getConnection().getRemoteContainer().length() - 7, 0), session.getConnection().getRemoteContainer().length())) : linkNamePrefix;
        return linkNameWithServiceRoleTracker.concat(TRACKING_ID_TOKEN_SEPARATOR).concat(String.valueOf(Instant.now().toEpochMilli()));
    }
}

