/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import java.util.Locale;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.message.Message;

public class AmqpUtil {
    private AmqpUtil() {
    }

    private static int getPayloadSize(Message msg) {
        if (msg == null || msg.getBody() == null) {
            return 0;
        }
        if (msg.getBody() instanceof Data) {
            Data payloadSection = (Data)msg.getBody();
            if (payloadSection == null) {
                return 0;
            }
            Binary payloadBytes = payloadSection.getValue();
            if (payloadBytes == null) {
                return 0;
            }
            return payloadBytes.getLength();
        }
        if (msg.getBody() instanceof AmqpValue) {
            AmqpValue amqpValue = (AmqpValue)msg.getBody();
            if (amqpValue == null) {
                return 0;
            }
            return amqpValue.getValue().toString().length() * 2;
        }
        return 0;
    }

    public static int getDataSerializedSize(Message amqpMessage) {
        if (amqpMessage == null) {
            return 0;
        }
        int payloadSize = AmqpUtil.getPayloadSize(amqpMessage);
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        int annotationsSize = 0;
        int applicationPropertiesSize = 0;
        if (messageAnnotations != null) {
            for (Object value : messageAnnotations.getValue().keySet()) {
                annotationsSize += AmqpUtil.sizeof(value);
            }
            for (Object value : messageAnnotations.getValue().values()) {
                annotationsSize += AmqpUtil.sizeof(value);
            }
        }
        if (applicationProperties != null) {
            for (Object value : applicationProperties.getValue().keySet()) {
                applicationPropertiesSize += AmqpUtil.sizeof(value);
            }
            for (Object value : applicationProperties.getValue().values()) {
                applicationPropertiesSize += AmqpUtil.sizeof(value);
            }
        }
        return annotationsSize + applicationPropertiesSize + payloadSize;
    }

    private static int sizeof(Object obj) {
        if (obj instanceof String) {
            return obj.toString().length() << 1;
        }
        if (obj instanceof Symbol) {
            return ((Symbol)obj).length() << 1;
        }
        if (obj instanceof Integer) {
            return 4;
        }
        if (obj instanceof Long) {
            return 8;
        }
        if (obj instanceof Short) {
            return 2;
        }
        if (obj instanceof Character) {
            return 2;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        throw new IllegalArgumentException(String.format(Locale.US, "Encoding Type: %s is not supported", obj.getClass()));
    }
}

