/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.ClientConstants;
import com.microsoft.azure.servicebus.StringUtil;
import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import com.microsoft.azure.servicebus.amqp.IAmqpConnection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.Handshaker;

public final class ConnectionHandler
extends BaseHandler {
    private static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final IAmqpConnection messagingFactory;

    public ConnectionHandler(IAmqpConnection messagingFactory) {
        this.add((Handler)new Handshaker());
        this.messagingFactory = messagingFactory;
    }

    public void onConnectionInit(Event event) {
        Connection connection = event.getConnection();
        String hostName = event.getReactor().getConnectionAddress(connection);
        connection.setHostname(hostName);
        connection.setContainer(StringUtil.getRandomString());
        HashMap<Symbol, String> connectionProperties = new HashMap<Symbol, String>();
        connectionProperties.put(AmqpConstants.PRODUCT, "MSJavaClient");
        connectionProperties.put(AmqpConstants.VERSION, "0.13.1");
        connectionProperties.put(AmqpConstants.PLATFORM, ClientConstants.PLATFORM_INFO);
        connection.setProperties(connectionProperties);
        connection.open();
    }

    public void onConnectionBound(Event event) {
        Transport transport = event.getTransport();
        SslDomain domain = ConnectionHandler.makeDomain(SslDomain.Mode.CLIENT);
        transport.ssl(domain);
        Sasl sasl = transport.sasl();
        sasl.setMechanisms(new String[]{"ANONYMOUS"});
    }

    public void onConnectionUnbound(Event event) {
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, "Connection.onConnectionUnbound: hostname[" + event.getConnection().getHostname() + "]");
        }
    }

    public void onTransportError(Event event) {
        ErrorCondition condition = event.getTransport().getCondition();
        if (condition != null) {
            if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
                TRACE_LOGGER.log(Level.WARNING, "Connection.onTransportError: hostname[" + event.getConnection().getHostname() + "], error[" + condition.getDescription() + "]");
            }
        } else if (TRACE_LOGGER.isLoggable(Level.WARNING)) {
            TRACE_LOGGER.log(Level.WARNING, "Connection.onTransportError: hostname[" + event.getConnection().getHostname() + "], error[no description returned]");
        }
        this.messagingFactory.onConnectionError(condition);
    }

    public void onConnectionRemoteOpen(Event event) {
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, "Connection.onConnectionRemoteOpen: hostname[" + event.getConnection().getHostname() + ", " + event.getConnection().getRemoteContainer() + "]");
        }
        this.messagingFactory.onOpenComplete(null);
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, "hostname[" + connection.getHostname() + (error != null ? "], errorCondition[" + error.getCondition() + ", " + error.getDescription() + "]" : "]"));
        }
        if (connection.getRemoteState() != EndpointState.CLOSED) {
            connection.close();
        }
        this.messagingFactory.onConnectionError(error);
    }

    private static SslDomain makeDomain(SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
        return domain;
    }
}

