/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.amqp.DispatchHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;

public final class ReactorDispatcher {
    private final Reactor reactor;
    private final Pipe ioSignal;
    private final ConcurrentLinkedQueue<BaseHandler> workQueue;
    private final ScheduleHandler workScheduler;

    public ReactorDispatcher(Reactor reactor) throws IOException {
        this.reactor = reactor;
        this.ioSignal = Pipe.open();
        this.workQueue = new ConcurrentLinkedQueue();
        this.workScheduler = new ScheduleHandler();
        this.initializeSelectable();
    }

    private void initializeSelectable() {
        Selectable schedulerSelectable = this.reactor.selectable();
        schedulerSelectable.setChannel((SelectableChannel)this.ioSignal.source());
        schedulerSelectable.onReadable((Selectable.Callback)this.workScheduler);
        schedulerSelectable.onFree((Selectable.Callback)new CloseHandler());
        schedulerSelectable.setReading(true);
        this.reactor.update(schedulerSelectable);
    }

    public void invoke(DispatchHandler timerCallback) throws IOException {
        this.workQueue.offer(timerCallback);
        this.signalWorkQueue();
    }

    public void invoke(int delay, DispatchHandler timerCallback) throws IOException {
        this.workQueue.offer(new DelayHandler(this.reactor, delay, timerCallback));
        this.signalWorkQueue();
    }

    private void signalWorkQueue() throws IOException {
        try {
            while (this.ioSignal.sink().write(ByteBuffer.allocate(1)) == 0) {
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private final class CloseHandler
    implements Selectable.Callback {
        private CloseHandler() {
        }

        public void run(Selectable selectable) {
            try {
                selectable.getChannel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (ReactorDispatcher.this.ioSignal.sink().isOpen()) {
                    ReactorDispatcher.this.ioSignal.sink().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ReactorDispatcher.this.workScheduler.run(null);
            try {
                if (ReactorDispatcher.this.ioSignal.source().isOpen()) {
                    ReactorDispatcher.this.ioSignal.source().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class ScheduleHandler
    implements Selectable.Callback {
        private ScheduleHandler() {
        }

        public void run(Selectable selectable) {
            BaseHandler topWork;
            try {
                ReactorDispatcher.this.ioSignal.source().read(ByteBuffer.allocate(1024));
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            while ((topWork = (BaseHandler)ReactorDispatcher.this.workQueue.poll()) != null) {
                topWork.onTimerTask(null);
            }
        }
    }

    private final class DelayHandler
    extends BaseHandler {
        final int delay;
        final BaseHandler timerCallback;
        final Reactor reactor;

        public DelayHandler(Reactor reactor, int delay, DispatchHandler timerCallback) {
            this.delay = delay;
            this.timerCallback = timerCallback;
            this.reactor = reactor;
        }

        public void onTimerTask(Event e) {
            this.reactor.schedule(this.delay, (Handler)this.timerCallback);
        }
    }
}

