/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.amqp;

import com.microsoft.azure.servicebus.ServiceBusException;
import com.microsoft.azure.servicebus.amqp.DispatchHandler;
import com.microsoft.azure.servicebus.amqp.ReactorDispatcher;
import com.microsoft.azure.servicebus.amqp.ReactorHandler;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.reactor.Reactor;

public class SessionHandler
extends BaseHandler {
    protected static final Logger TRACE_LOGGER = Logger.getLogger("servicebus.trace");
    private final String entityName;
    private final Consumer<Session> onRemoteSessionOpen;
    private final BiConsumer<ErrorCondition, Exception> onRemoteSessionOpenError;
    private boolean sessionCreated = false;
    private boolean sessionOpenErrorDispatched = false;

    public SessionHandler(String entityName, Consumer<Session> onRemoteSessionOpen, BiConsumer<ErrorCondition, Exception> onRemoteSessionOpenError) {
        this.entityName = entityName;
        this.onRemoteSessionOpenError = onRemoteSessionOpenError;
        this.onRemoteSessionOpen = onRemoteSessionOpen;
    }

    public void onSessionLocalOpen(Event e) {
        if (this.onRemoteSessionOpenError != null) {
            ReactorHandler reactorHandler = null;
            Reactor reactor = e.getReactor();
            Iterator reactorEventHandlers = reactor.getHandler().children();
            while (reactorEventHandlers.hasNext()) {
                Handler currentHandler = (Handler)reactorEventHandlers.next();
                if (!(currentHandler instanceof ReactorHandler)) continue;
                reactorHandler = (ReactorHandler)currentHandler;
                break;
            }
            ReactorDispatcher reactorDispatcher = reactorHandler.getReactorDispatcher();
            Session session = e.getSession();
            try {
                reactorDispatcher.invoke(15000, new SessionTimeoutHandler(session));
            }
            catch (IOException ignore) {
                if (TRACE_LOGGER.isLoggable(Level.SEVERE)) {
                    TRACE_LOGGER.log(Level.SEVERE, String.format(Locale.US, "entityName[%s], reactorDispatcherError[%s]", this.entityName, ignore.getMessage()));
                }
                session.close();
                this.onRemoteSessionOpenError.accept(null, new ServiceBusException(false, String.format("underlying IO of reactorDispatcher faulted with error: %s", ignore.getMessage()), ignore));
            }
        }
    }

    public void onSessionRemoteOpen(Event e) {
        Session session;
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s], sessionIncCapacity[%s], sessionOutgoingWindow[%s]", this.entityName, e.getSession().getIncomingCapacity(), e.getSession().getOutgoingWindow()));
        }
        if ((session = e.getSession()) != null && session.getLocalState() == EndpointState.UNINITIALIZED) {
            session.open();
        }
        this.sessionCreated = true;
        if (this.onRemoteSessionOpen != null) {
            this.onRemoteSessionOpen.accept(session);
        }
    }

    public void onSessionLocalClose(Event e) {
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s], condition[%s]", this.entityName, e.getSession().getCondition() == null ? "none" : e.getSession().getCondition().toString()));
        }
    }

    public void onSessionRemoteClose(Event e) {
        Session session;
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s], condition[%s]", this.entityName, e.getSession().getRemoteCondition() == null ? "none" : e.getSession().getRemoteCondition().toString()));
        }
        if ((session = e.getSession()) != null && session.getLocalState() != EndpointState.CLOSED) {
            session.close();
        }
        this.sessionOpenErrorDispatched = true;
        if (!this.sessionCreated && this.onRemoteSessionOpenError != null) {
            this.onRemoteSessionOpenError.accept(session.getRemoteCondition(), null);
        }
    }

    public void onSessionFinal(Event e) {
        if (TRACE_LOGGER.isLoggable(Level.FINE)) {
            TRACE_LOGGER.log(Level.FINE, String.format(Locale.US, "entityName[%s]", this.entityName));
        }
    }

    private class SessionTimeoutHandler
    extends DispatchHandler {
        private final Session session;

        public SessionTimeoutHandler(Session session) {
            this.session = session;
        }

        @Override
        public void onEvent() {
            if (!SessionHandler.this.sessionCreated && !SessionHandler.this.sessionOpenErrorDispatched) {
                Connection connection = this.session.getConnection();
                if (connection != null) {
                    if (connection.getRemoteCondition() != null && connection.getRemoteCondition().getCondition() != null) {
                        this.session.close();
                        SessionHandler.this.onRemoteSessionOpenError.accept(connection.getRemoteCondition(), null);
                        return;
                    }
                    Transport transport = connection.getTransport();
                    if (transport != null && transport.getCondition() != null && transport.getCondition().getCondition() != null) {
                        this.session.close();
                        SessionHandler.this.onRemoteSessionOpenError.accept(transport.getCondition(), null);
                        return;
                    }
                }
                this.session.close();
                SessionHandler.this.onRemoteSessionOpenError.accept(null, new ServiceBusException(false, "session creation timedout."));
            }
        }
    }
}

