/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.SecurityToken;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.FaultTolerantObject;
import com.microsoft.azure.eventhubs.impl.MessageOperationResult;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.OperationResultBase;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.RequestResponseChannel;
import com.microsoft.azure.eventhubs.impl.RequestResponseCloser;
import com.microsoft.azure.eventhubs.impl.RequestResponseOpener;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

final class CBSChannel {
    final ScheduledExecutorService executor;
    final FaultTolerantObject<RequestResponseChannel> innerChannel;

    CBSChannel(SessionProvider sessionProvider, AmqpConnection connection, String clientId, ScheduledExecutorService executor) {
        this.executor = executor;
        RequestResponseCloser closer = new RequestResponseCloser();
        this.innerChannel = new FaultTolerantObject<RequestResponseChannel>(new RequestResponseOpener(sessionProvider, clientId, "cbs-session", "cbs", "$cbs", connection, this.executor), closer);
        closer.setInnerChannel(this.innerChannel);
    }

    public void sendToken(ReactorDispatcher dispatcher, CompletableFuture<SecurityToken> tokenFuture, String tokenAudience, OperationResult<Void, Exception> sendTokenCallback, Consumer<Exception> errorCallback) {
        ((CompletableFuture)tokenFuture.thenAcceptAsync(token -> this.innerSendToken(dispatcher, (SecurityToken)token, tokenAudience, sendTokenCallback), (Executor)this.executor)).whenCompleteAsync((empty, exception) -> {
            if (exception != null && exception instanceof Exception) {
                errorCallback.accept((Exception)exception);
            }
        }, (Executor)this.executor);
    }

    private void innerSendToken(ReactorDispatcher dispatcher, SecurityToken token, String tokenAudience, OperationResult<Void, Exception> sendTokenCallback) {
        Message request = Proton.message();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("operation", "put-token");
        properties.put("type", token.getTokenType());
        properties.put("expiration", token.validTo());
        properties.put("name", tokenAudience);
        ApplicationProperties applicationProperties = new ApplicationProperties(properties);
        request.setApplicationProperties(applicationProperties);
        request.setBody((Section)new AmqpValue((Object)token.getToken()));
        MessageOperationResult messageOperation = new MessageOperationResult(response -> sendTokenCallback.onComplete(null), sendTokenCallback::onError);
        OperationResultBase operation = new OperationResultBase(result -> result.request(request, messageOperation), sendTokenCallback::onError);
        this.innerChannel.runOnOpenedObject(dispatcher, operation);
    }

    public void close(ReactorDispatcher reactorDispatcher, OperationResult<Void, Exception> closeCallback) {
        this.innerChannel.close(reactorDispatcher, closeCallback);
    }
}

