/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementException;
import com.microsoft.azure.functions.annotation.AuthorizationLevel;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsights;
import com.microsoft.azure.toolkit.lib.applicationinsights.ApplicationInsightsEntity;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.service.IAppServiceUpdater;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.service.IFunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import com.microsoft.azure.toolkit.lib.resource.AzureGroup;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.settings.Settings;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    private static final String DEPLOY_START = "Starting deployment...";
    private static final String DEPLOY_FINISH = "Deployment done, you may access your resource through %s";
    private static final String FUNCTION_SLOT_CREATE_START = "The specified function slot does not exist. Creating a new slot...";
    private static final String FUNCTION_SLOT_CREATED = "Successfully created the function slot: %s.";
    private static final String FUNCTION_SLOT_UPDATE = "Updating the specified function slot...";
    private static final String FUNCTION_SLOT_UPDATE_DONE = "Successfully updated the function slot: %s.";
    private static final String APPINSIGHTS_INSTRUMENTATION_KEY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    private static final String APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT = "Contradictory configurations for application insights, specify 'appInsightsKey' or 'appInsightsInstance' if you want to enable it, and specify 'disableAppInsights=true' if you want to disable it.";
    private static final String FAILED_TO_GET_APPLICATION_INSIGHTS = "The application insights %s cannot be found, will create it in resource group %s.";
    private static final String SKIP_CREATING_APPLICATION_INSIGHTS = "Skip creating application insights";
    private static final String APPLICATION_INSIGHTS_CREATE_START = "Creating application insights...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Successfully created the application insights %s for this Function App. You can visit %s/#@/resource%s/overview to view your Application Insights component.";
    private static final String APPLICATION_INSIGHTS_CREATE_FAILED = "Unable to create the Application Insights for the Function App due to error %s. Please use the Azure Portal to manually create and configure the Application Insights if needed.";
    private static final String INSTRUMENTATION_KEY_IS_NOT_VALID = "Instrumentation key is not valid, please update the application insights configuration";
    private static final String UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS = "Some http trigger urls cannot be displayed because they are non-anonymous. To access the non-anonymous triggers, please refer https://aka.ms/azure-functions-key.";
    private static final String HTTP_TRIGGER_URLS = "HTTP Trigger Urls:";
    private static final String NO_ANONYMOUS_HTTP_TRIGGER = "No anonymous HTTP Triggers found in deployed function app, skip list triggers.";
    private static final String AUTH_LEVEL = "authLevel";
    private static final String HTTP_TRIGGER = "httpTrigger";
    private static final String ARTIFACT_INCOMPATIBLE = "Your function app artifact compile version is higher than the java version in function host, please downgrade the project compile version and try again.";
    private static final String FUNCTIONS_WORKER_RUNTIME_NAME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String FUNCTIONS_WORKER_RUNTIME_VALUE = "java";
    private static final String SET_FUNCTIONS_WORKER_RUNTIME = "Set function worker runtime to java.";
    private static final String CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING = "App setting `FUNCTIONS_WORKER_RUNTIME` doesn't meet the requirement of Azure Java Functions, the value should be `java`.";
    private static final String FUNCTIONS_EXTENSION_VERSION_NAME = "FUNCTIONS_EXTENSION_VERSION";
    private static final String FUNCTIONS_EXTENSION_VERSION_VALUE = "~3";
    private static final String SET_FUNCTIONS_EXTENSION_VERSION = "Functions extension version isn't configured, setting up the default value.";
    private static final String RUNNING = "Running";
    private static final String CREATE_FUNCTION_APP = "Creating function app %s...";
    private static final String CREATE_FUNCTION_APP_DONE = "Successfully created function app %s.";
    private static final String CREATE_APP_SERVICE_PLAN = "Creating app service plan...";
    private static final String CREATE_APP_SERVICE_DONE = "Successfully created app service plan %s.";
    private static final String CREATE_RESOURCE_GROUP = "Creating resource group %s in region %s...";
    private static final String CREATE_RESOURCE_GROUP_DONE = "Successfully created resource group %s.";
    private static final String CREATE_NEW_FUNCTION_APP = "isCreateNewFunctionApp";
    private static final String CREATE_NEW_APP_SERVICE_PLAN = "createNewAppServicePlan";
    private static final String CREATE_NEW_RESOURCE_GROUP = "createNewResourceGroup";
    private static final String UPDATE_FUNCTION_APP = "Updating target Function App %s...";
    private static final String UPDATE_FUNCTION_DONE = "Successfully updated Function App %s.";
    private static final String NO_ARTIFACT_FOUNDED = "Failed to find function artifact '%s.jar' in folder '%s', please re-package the project and try again.";
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";
    private static final int LIST_TRIGGERS_MAX_RETRY = 3;
    private static final int LIST_TRIGGERS_RETRY_PERIOD_IN_SECONDS = 10;
    private static final String SYNCING_TRIGGERS_AND_FETCH_FUNCTION_INFORMATION = "Syncing triggers and fetching function information (Attempt %d/%d)...";
    private static final String NO_TRIGGERS_FOUNDED = "No triggers found in deployed function app, please try recompile the project by `mvn clean package` and deploy again.";
    private static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    private static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9._\\-()]{1,90}";
    private static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String APP_SERVICE_PLAN_NAME_PATTERN = "[a-zA-Z0-9\\-]{1,40}";
    private static final String EMPTY_APP_NAME = "Please config the <appName> in pom.xml.";
    private static final String INVALID_APP_NAME = "The <appName> only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.";
    private static final String EMPTY_RESOURCE_GROUP = "Please config the <resourceGroup> in pom.xml.";
    private static final String INVALID_RESOURCE_GROUP_NAME = "The <resourceGroup> only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String INVALID_SERVICE_PLAN_NAME = "Invalid value for <appServicePlanName>, it need to match the pattern %s";
    private static final String INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME = "Invalid value for <appServicePlanResourceGroup>, it only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String EMPTY_SLOT_NAME = "Please config the <name> of <deploymentSlot> in pom.xml";
    private static final String INVALID_SLOT_NAME = "Invalid value of <name> inside <deploymentSlot> in pom.xml, it needs to match the pattern '%s'";
    private static final String INVALID_REGION = "The value of <region> is not supported, please correct it in pom.xml.";
    private static final String EMPTY_IMAGE_NAME = "Please config the <image> of <runtime> in pom.xml.";
    private static final String INVALID_OS = "The value of <os> is not correct, supported values are: windows, linux and docker.";
    private static final String INVALID_JAVA_VERSION = "Unsupported value %s for <javaVersion> in pom.xml";
    private static final String INVALID_PRICING_TIER = "Unsupported value %s for <pricingTier> in pom.xml";
    private static final String FAILED_TO_LIST_TRIGGERS = "Deployment succeeded, but failed to list http trigger urls.";
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker app service";
    private AzureAppService az;

    protected void doExecute() throws AzureExecutionException {
        this.doValidate();
        this.processAppSettingsWithDefaultValue();
        this.az = this.getOrCreateAzureAppServiceClient();
        IFunctionAppBase target = this.createOrUpdateResource();
        this.deployArtifact(target);
        if (target instanceof IFunctionApp) {
            this.listHTTPTriggerUrls((IFunctionApp)target);
        }
    }

    protected void doValidate() throws AzureExecutionException {
        this.validateParameters();
        this.validateArtifactCompileVersion();
        this.validateApplicationInsightsConfiguration();
    }

    @Deprecated
    protected void validateParameters() {
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            throw new AzureToolkitRuntimeException(EMPTY_APP_NAME);
        }
        if (this.appName.startsWith("-") || !this.appName.matches(APP_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_APP_NAME);
        }
        if (StringUtils.isBlank((CharSequence)this.resourceGroup)) {
            throw new AzureToolkitRuntimeException(EMPTY_RESOURCE_GROUP);
        }
        if (this.resourceGroup.endsWith(".") || !this.resourceGroup.matches(RESOURCE_GROUP_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_RESOURCE_GROUP_NAME);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appServicePlanName) && !this.appServicePlanName.matches(APP_SERVICE_PLAN_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SERVICE_PLAN_NAME, APP_SERVICE_PLAN_NAME_PATTERN));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appServicePlanResourceGroup) && (this.appServicePlanResourceGroup.endsWith(".") || !this.appServicePlanResourceGroup.matches(RESOURCE_GROUP_PATTERN))) {
            throw new AzureToolkitRuntimeException(INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME);
        }
        if (this.deploymentSlotSetting != null && StringUtils.isEmpty((CharSequence)this.deploymentSlotSetting.getName())) {
            throw new AzureToolkitRuntimeException(EMPTY_SLOT_NAME);
        }
        if (this.deploymentSlotSetting != null && !this.deploymentSlotSetting.getName().matches(SLOT_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SLOT_NAME, SLOT_NAME_PATTERN));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.region) && Region.fromName((String)this.region) == null) {
            throw new AzureToolkitRuntimeException(INVALID_REGION);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runtime.getOs()) && OperatingSystem.fromString((String)this.runtime.getOs()) == null) {
            throw new AzureToolkitRuntimeException(INVALID_OS);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runtime.getJavaVersion()) && JavaVersion.fromString((String)this.runtime.getJavaVersion()) == JavaVersion.OFF) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_JAVA_VERSION, this.runtime.getJavaVersion()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.pricingTier) && PricingTier.fromString((String)this.pricingTier) == null) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_PRICING_TIER, this.pricingTier));
        }
        if (OperatingSystem.fromString((String)this.runtime.getOs()) == OperatingSystem.DOCKER && StringUtils.isEmpty((CharSequence)this.runtime.getImage())) {
            throw new AzureToolkitRuntimeException(EMPTY_IMAGE_NAME);
        }
    }

    protected IFunctionAppBase createOrUpdateResource() throws AzureExecutionException {
        String deploymentSlotName = Optional.ofNullable(this.deploymentSlotSetting).map(DeploymentSlotSetting::getName).orElse(null);
        IFunctionApp functionApp = this.az.functionApp(this.getResourceGroup(), this.getAppName());
        if (StringUtils.isEmpty((CharSequence)deploymentSlotName)) {
            return functionApp.exists() ? this.updateFunctionApp(functionApp) : this.createFunctionApp(functionApp);
        }
        IFunctionAppDeploymentSlot slot = functionApp.deploymentSlot(deploymentSlotName);
        return slot.exists() ? this.updateDeploymentSlot(slot) : this.createDeploymentSlot(slot);
    }

    protected IFunctionApp createFunctionApp(IFunctionApp functionApp) throws AzureExecutionException {
        this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_FUNCTION_APP, String.valueOf(true));
        ResourceGroup resourceGroup = this.getOrCreateResourceGroup();
        IAppServicePlan appServicePlan = this.getOrCreateAppServicePlan();
        AzureMessager.getMessager().info(String.format(CREATE_FUNCTION_APP, this.getAppName()));
        Runtime runtime = this.getRuntimeOrDefault();
        Map appSettings = this.getAppSettings();
        this.bindApplicationInsights(appSettings, true);
        IFunctionApp result = (IFunctionApp)functionApp.create().withName(this.getAppName()).withResourceGroup(resourceGroup.getName()).withPlan(appServicePlan.id()).withRuntime(runtime).withDockerConfiguration(this.getDockerConfiguration()).withAppSettings(appSettings).commit();
        AzureMessager.getMessager().info(String.format(CREATE_FUNCTION_APP_DONE, result.name()));
        return result;
    }

    private IAppServicePlan getOrCreateAppServicePlan() {
        String servicePlanName = StringUtils.isEmpty((CharSequence)this.getAppServicePlanName()) ? String.format("asp-%s", this.getAppName()) : this.getAppServicePlanName();
        String servicePlanGroup = this.getServicePlanResourceGroup();
        IAppServicePlan appServicePlan = this.az.appServicePlan(servicePlanGroup, servicePlanName);
        if (!appServicePlan.exists()) {
            AzureMessager.getMessager().info(CREATE_APP_SERVICE_PLAN);
            this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_APP_SERVICE_PLAN, String.valueOf(true));
            appServicePlan.create().withName(servicePlanName).withResourceGroup(servicePlanGroup).withRegion(this.getParsedRegion()).withPricingTier(this.getParsedPricingTier()).withOperatingSystem(this.getRuntimeOrDefault().getOperatingSystem()).commit();
            AzureMessager.getMessager().info(String.format(CREATE_APP_SERVICE_DONE, appServicePlan.name()));
        }
        return appServicePlan;
    }

    private Region getParsedRegion() {
        return Optional.ofNullable(this.region).map(Region::fromName).orElse(Region.US_WEST);
    }

    private PricingTier getParsedPricingTier() {
        if (StringUtils.isEmpty((CharSequence)this.pricingTier)) {
            return PricingTier.CONSUMPTION;
        }
        return Optional.ofNullable(PricingTier.fromString((String)this.pricingTier)).orElseThrow(() -> new AzureToolkitRuntimeException(String.format("Invalid pricing tier %s", this.pricingTier)));
    }

    private ResourceGroup getOrCreateResourceGroup() {
        try {
            return ((AzureGroup)Azure.az(AzureGroup.class)).getByName(this.getResourceGroup());
        }
        catch (ManagementException e) {
            AzureMessager.getMessager().info(String.format(CREATE_RESOURCE_GROUP, this.getResourceGroup(), this.getRegion()));
            this.getTelemetryProxy().addDefaultProperty(CREATE_NEW_RESOURCE_GROUP, String.valueOf(true));
            ResourceGroup result = ((AzureGroup)Azure.az(AzureGroup.class)).create(this.getResourceGroup(), this.getRegion());
            AzureMessager.getMessager().info(String.format(CREATE_RESOURCE_GROUP_DONE, result.getName()));
            return result;
        }
    }

    private Runtime getRuntimeOrDefault() {
        OperatingSystem os = Optional.ofNullable(this.runtime.getOs()).map(OperatingSystem::fromString).orElse(OperatingSystem.WINDOWS);
        JavaVersion javaVersion = Optional.ofNullable(this.runtime.getJavaVersion()).map(JavaVersion::fromString).orElse(JavaVersion.JAVA_8);
        return Runtime.getRuntime((OperatingSystem)os, (WebContainer)WebContainer.JAVA_OFF, (JavaVersion)javaVersion);
    }

    private Runtime getRuntime() {
        if (StringUtils.isEmpty((CharSequence)this.runtime.getOs()) && StringUtils.isEmpty((CharSequence)this.runtime.getJavaVersion())) {
            return null;
        }
        OperatingSystem os = OperatingSystem.fromString((String)this.runtime.getOs());
        JavaVersion javaVersion = JavaVersion.fromString((String)this.runtime.getJavaVersion());
        return Runtime.getRuntime((OperatingSystem)os, (WebContainer)WebContainer.JAVA_OFF, (JavaVersion)javaVersion);
    }

    private DockerConfiguration getDockerConfiguration() throws AzureExecutionException {
        OperatingSystem os = Optional.ofNullable(this.runtime.getOs()).map(OperatingSystem::fromString).orElse(null);
        if (os != OperatingSystem.DOCKER) {
            return null;
        }
        MavenDockerCredentialProvider credentialProvider = MavenDockerCredentialProvider.fromMavenSettings((Settings)this.getSettings(), (String)this.runtime.getServerId());
        return DockerConfiguration.builder().registryUrl(this.runtime.getRegistryUrl()).image(this.runtime.getImage()).userName(credentialProvider.getUsername()).password(credentialProvider.getPassword()).build();
    }

    protected IFunctionApp updateFunctionApp(IFunctionApp functionApp) throws AzureExecutionException {
        IAppServicePlan targetServicePlan;
        AzureMessager.getMessager().info(String.format(UPDATE_FUNCTION_APP, functionApp.name()));
        IAppServicePlan currentPlan = functionApp.plan();
        IAppServicePlan iAppServicePlan = targetServicePlan = StringUtils.isEmpty((CharSequence)this.appServicePlanName) ? currentPlan : this.az.appServicePlan(this.getServicePlanResourceGroup(), this.appServicePlanName);
        if (!targetServicePlan.exists()) {
            targetServicePlan = this.getOrCreateAppServicePlan();
        } else if (StringUtils.isNotEmpty((CharSequence)this.pricingTier)) {
            targetServicePlan.update().withPricingTier(this.getParsedPricingTier()).commit();
        }
        Map appSettings = this.getAppSettings();
        IAppServiceUpdater update = functionApp.update();
        if (this.isDisableAppInsights()) {
            update.withoutAppSettings(APPINSIGHTS_INSTRUMENTATION_KEY);
        } else {
            this.bindApplicationInsights(appSettings, false);
        }
        IFunctionApp result = (IFunctionApp)update.withPlan(targetServicePlan.id()).withRuntime(this.getRuntime()).withDockerConfiguration(this.getDockerConfiguration()).withAppSettings(appSettings).commit();
        AzureMessager.getMessager().info(String.format(UPDATE_FUNCTION_DONE, functionApp.name()));
        return result;
    }

    private String getServicePlanResourceGroup() {
        return StringUtils.isEmpty((CharSequence)this.getAppServicePlanResourceGroup()) ? this.getResourceGroup() : this.getAppServicePlanResourceGroup();
    }

    protected IFunctionAppDeploymentSlot createDeploymentSlot(IFunctionAppDeploymentSlot deploymentSlot) throws AzureExecutionException {
        AzureMessager.getMessager().info(FUNCTION_SLOT_CREATE_START);
        DeploymentSlotSetting slotSetting = this.getDeploymentSlotSetting();
        Map appSettings = this.getAppSettings();
        this.bindApplicationInsights(appSettings, false);
        IFunctionAppDeploymentSlot result = deploymentSlot.create().withAppSettings(appSettings).withConfigurationSource(slotSetting.getConfigurationSource()).withName(slotSetting.getName()).commit();
        AzureMessager.getMessager().info(String.format(FUNCTION_SLOT_CREATED, result.name()));
        return result;
    }

    protected IFunctionAppDeploymentSlot updateDeploymentSlot(IFunctionAppDeploymentSlot deploymentSlot) throws AzureExecutionException {
        AzureMessager.getMessager().info(FUNCTION_SLOT_UPDATE);
        Map appSettings = this.getAppSettings();
        IFunctionAppDeploymentSlot.Updater update = deploymentSlot.update();
        if (this.isDisableAppInsights()) {
            update.withoutAppSettings(APPINSIGHTS_INSTRUMENTATION_KEY);
        } else {
            this.bindApplicationInsights(appSettings, false);
        }
        IFunctionAppDeploymentSlot result = update.withAppSettings(appSettings).commit();
        AzureMessager.getMessager().info(String.format(FUNCTION_SLOT_UPDATE_DONE, result.name()));
        return deploymentSlot;
    }

    private void deployArtifact(IFunctionAppBase target) throws AzureExecutionException {
        if (target.getRuntime().getOperatingSystem() == OperatingSystem.DOCKER) {
            AzureMessager.getMessager().info(SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE);
            return;
        }
        AzureMessager.getMessager().info(DEPLOY_START);
        FunctionDeployType deployType = StringUtils.isEmpty((CharSequence)this.deploymentType) ? null : FunctionDeployType.fromString((String)this.deploymentType);
        File file = deployType == FunctionDeployType.FTP ? new File(this.getDeploymentStagingDirectoryPath()) : this.packageStagingDirectory();
        AbstractAzureMojo.RunnableWithException deployRunnable = deployType == null ? () -> target.deploy(file) : () -> target.deploy(file, deployType);
        this.executeWithTimeRecorder(deployRunnable, "deploy");
        if (!StringUtils.equalsIgnoreCase((CharSequence)target.state(), (CharSequence)RUNNING)) {
            target.start();
        }
        AzureMessager.getMessager().info(String.format(DEPLOY_FINISH, this.getResourcePortalUrl(target.id())));
    }

    private File packageStagingDirectory() {
        File zipFile = new File(this.getDeploymentStagingDirectoryPath() + ".zip");
        File stagingDirectory = new File(this.getDeploymentStagingDirectoryPath());
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
        return zipFile;
    }

    protected void listHTTPTriggerUrls(IFunctionApp target) {
        try {
            List<FunctionEntity> triggers = this.listFunctions(target);
            List httpFunction = triggers.stream().filter(function -> function.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)function.getTrigger().getType(), (CharSequence)HTTP_TRIGGER)).collect(Collectors.toList());
            List<FunctionEntity> anonymousTriggers = httpFunction.stream().filter(bindingResource -> bindingResource.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)bindingResource.getTrigger().getProperty(AUTH_LEVEL), (CharSequence)AuthorizationLevel.ANONYMOUS.toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(httpFunction) || CollectionUtils.isEmpty(anonymousTriggers)) {
                AzureMessager.getMessager().info(NO_ANONYMOUS_HTTP_TRIGGER);
                return;
            }
            AzureMessager.getMessager().info(HTTP_TRIGGER_URLS);
            anonymousTriggers.forEach(trigger -> AzureMessager.getMessager().info(String.format("\t %s : %s", trigger.getName(), trigger.getTriggerUrl())));
            if (anonymousTriggers.size() < httpFunction.size()) {
                AzureMessager.getMessager().info(UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS);
            }
        }
        catch (RuntimeException e) {
            AzureMessager.getMessager().warning(FAILED_TO_LIST_TRIGGERS);
        }
    }

    private List<FunctionEntity> listFunctions(IFunctionApp functionApp) {
        for (int i = 0; i < 3; ++i) {
            try {
                AzureMessager.getMessager().info(String.format(SYNCING_TRIGGERS_AND_FETCH_FUNCTION_INFORMATION, i + 1, 3));
                functionApp.syncTriggers();
                List triggers = functionApp.listFunctions();
                if (CollectionUtils.isNotEmpty((Collection)triggers)) {
                    return triggers;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new AzureToolkitRuntimeException(NO_TRIGGERS_FOUNDED);
    }

    protected void validateArtifactCompileVersion() throws AzureExecutionException {
        ComparableVersion artifactVersion;
        Runtime runtime = this.getRuntimeOrDefault();
        if (runtime.getOperatingSystem() == OperatingSystem.DOCKER) {
            return;
        }
        ComparableVersion runtimeVersion = new ComparableVersion(runtime.getJavaVersion().getValue());
        if (runtimeVersion.compareTo(artifactVersion = new ComparableVersion(Utils.getArtifactCompileVersion((File)this.getArtifactToDeploy()))) < 0) {
            throw new AzureExecutionException(ARTIFACT_INCOMPATIBLE);
        }
    }

    public void processAppSettingsWithDefaultValue() {
        if (this.appSettings == null) {
            this.appSettings = new Properties();
        }
        this.setDefaultAppSetting(this.appSettings, FUNCTIONS_WORKER_RUNTIME_NAME, SET_FUNCTIONS_WORKER_RUNTIME, FUNCTIONS_WORKER_RUNTIME_VALUE, CUSTOMIZED_FUNCTIONS_WORKER_RUNTIME_WARNING);
        this.setDefaultAppSetting(this.appSettings, FUNCTIONS_EXTENSION_VERSION_NAME, SET_FUNCTIONS_EXTENSION_VERSION, FUNCTIONS_EXTENSION_VERSION_VALUE, null);
    }

    private void setDefaultAppSetting(Map result, String settingName, String settingIsEmptyMessage, String defaultValue, String warningMessage) {
        String setting = (String)result.get(settingName);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            AzureMessager.getMessager().info(settingIsEmptyMessage);
            result.put(settingName, defaultValue);
            return;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)setting, (CharSequence)defaultValue) && StringUtils.isNotEmpty((CharSequence)warningMessage)) {
            AzureMessager.getMessager().warning(warningMessage);
        }
    }

    private File getArtifactToDeploy() throws AzureExecutionException {
        File stagingFolder = new File(this.getDeploymentStagingDirectoryPath());
        return Arrays.stream(Optional.ofNullable(stagingFolder.listFiles()).orElse(new File[0])).filter(jar -> StringUtils.equals((CharSequence)FilenameUtils.getBaseName((String)jar.getName()), (CharSequence)this.getFinalName())).findFirst().orElseThrow(() -> new AzureExecutionException(String.format(NO_ARTIFACT_FOUNDED, this.getFinalName(), stagingFolder)));
    }

    private void bindApplicationInsights(Map appSettings, boolean isCreation) throws AzureExecutionException {
        String instrumentationKey;
        if (appSettings.containsKey(APPINSIGHTS_INSTRUMENTATION_KEY)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey())) {
            instrumentationKey = this.getAppInsightsKey();
            if (!Utils.isGUID((String)instrumentationKey)) {
                throw new AzureExecutionException(INSTRUMENTATION_KEY_IS_NOT_VALID);
            }
        } else {
            ApplicationInsightsEntity applicationInsightsComponent = this.getOrCreateApplicationInsights(isCreation);
            String string = instrumentationKey = applicationInsightsComponent == null ? null : applicationInsightsComponent.getInstrumentationKey();
        }
        if (StringUtils.isNotEmpty((CharSequence)instrumentationKey)) {
            appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, instrumentationKey);
        }
    }

    private void validateApplicationInsightsConfiguration() throws AzureExecutionException {
        if (this.isDisableAppInsights() && (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey()) || StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()))) {
            throw new AzureExecutionException(APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT);
        }
    }

    private ApplicationInsightsEntity getOrCreateApplicationInsights(boolean enableCreation) {
        return StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()) ? this.getApplicationInsights(this.getAppInsightsInstance()) : (enableCreation ? this.createApplicationInsights(this.getAppName()) : null);
    }

    private ApplicationInsightsEntity getApplicationInsights(String appInsightsInstance) {
        ApplicationInsightsEntity resource;
        try {
            resource = ((ApplicationInsights)Azure.az(ApplicationInsights.class)).get(this.getResourceGroup(), appInsightsInstance);
        }
        catch (ManagementException e) {
            resource = null;
        }
        if (resource == null) {
            AzureMessager.getMessager().warning(String.format(FAILED_TO_GET_APPLICATION_INSIGHTS, appInsightsInstance, this.getResourceGroup()));
            return this.createApplicationInsights(appInsightsInstance);
        }
        return resource;
    }

    private ApplicationInsightsEntity createApplicationInsights(String name) {
        if (this.isDisableAppInsights()) {
            AzureMessager.getMessager().info(SKIP_CREATING_APPLICATION_INSIGHTS);
            return null;
        }
        try {
            AzureMessager.getMessager().info(APPLICATION_INSIGHTS_CREATE_START);
            AzureEnvironment environment = ((AzureAccount)Azure.az(AzureAccount.class)).account().getEnvironment();
            ApplicationInsightsEntity resource = ((ApplicationInsights)Azure.az(ApplicationInsights.class)).create(this.getResourceGroup(), Region.fromName((String)this.getRegion()), name);
            AzureMessager.getMessager().info(String.format(APPLICATION_INSIGHTS_CREATED, resource.getName(), DeployMojo.getPortalUrl((AzureEnvironment)environment), resource.getId()));
            return resource;
        }
        catch (Exception e) {
            AzureMessager.getMessager().warning(String.format(APPLICATION_INSIGHTS_CREATE_FAILED, e.getMessage()));
            return null;
        }
    }
}

