/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.function.ConfigParser;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.RuntimeConfiguration;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFunctionMojo
extends AbstractAppServiceMojo {
    private static final String FUNCTION_JAVA_VERSION_KEY = "functionJavaVersion";
    private static final String DISABLE_APP_INSIGHTS_KEY = "disableAppInsights";
    private static final String FUNCTION_RUNTIME_KEY = "os";
    private static final String FUNCTION_IS_DOCKER_KEY = "isDockerFunction";
    private static final String FUNCTION_REGION_KEY = "region";
    private static final String FUNCTION_PRICING_KEY = "pricingTier";
    private static final String FUNCTION_DEPLOY_TO_SLOT_KEY = "isDeployToFunctionSlot";
    protected static final String TRIGGER_TYPE = "triggerType";
    @Parameter(property="functions.pricingTier")
    protected String pricingTier;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    protected String finalName;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(property="functions.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="functions.region")
    protected String region;
    @Parameter(property="functions.runtime")
    protected RuntimeConfiguration runtime;
    @Parameter(property="functions.appInsightsInstance")
    protected String appInsightsInstance;
    @Parameter(property="functions.appInsightsKey")
    protected String appInsightsKey;
    @Parameter(property="functions.disableAppInsights", defaultValue="false")
    protected boolean disableAppInsights;
    protected ConfigParser parser = new ConfigParser(this);

    public String getRegion() {
        return this.region;
    }

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public String getAppInsightsInstance() {
        return this.appInsightsInstance;
    }

    public String getAppInsightsKey() {
        return this.appInsightsKey;
    }

    public boolean isDisableAppInsights() {
        return this.disableAppInsights;
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtime;
    }

    protected void validateAppName() {
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            throw new AzureToolkitRuntimeException("Please config the <appName> in pom.xml");
        }
    }

    public Map<String, String> getTelemetryProperties() {
        Map result = super.getTelemetryProperties();
        String javaVersion = this.runtime == null ? null : this.runtime.getJavaVersion();
        String os = this.runtime == null ? null : this.runtime.getOs();
        boolean isDockerFunction = this.runtime != null && StringUtils.isNotEmpty((CharSequence)this.runtime.getImage());
        result.put(FUNCTION_JAVA_VERSION_KEY, StringUtils.isEmpty((CharSequence)javaVersion) ? "" : javaVersion);
        result.put(FUNCTION_RUNTIME_KEY, StringUtils.isEmpty((CharSequence)os) ? "" : os);
        result.put(FUNCTION_IS_DOCKER_KEY, String.valueOf(isDockerFunction));
        result.put(FUNCTION_REGION_KEY, this.region);
        result.put(FUNCTION_PRICING_KEY, this.pricingTier);
        result.put(DISABLE_APP_INSIGHTS_KEY, String.valueOf(this.isDisableAppInsights()));
        boolean isDeployToFunctionSlot = this.getDeploymentSlotSetting() != null && StringUtils.isNotEmpty((CharSequence)this.getDeploymentSlotSetting().getName());
        result.put(FUNCTION_DEPLOY_TO_SLOT_KEY, String.valueOf(isDeployToFunctionSlot));
        return result;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public ConfigParser getParser() {
        return this.parser;
    }
}

