/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.model.WebContainer;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.RuntimeConfiguration;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.settings.Settings;

public class ConfigParser {
    private final AbstractFunctionMojo mojo;

    public ConfigParser(AbstractFunctionMojo mojo) {
        this.mojo = mojo;
    }

    public FunctionAppConfig parseConfig() throws AzureExecutionException {
        return (FunctionAppConfig)new FunctionAppConfig().disableAppInsights(this.mojo.isDisableAppInsights()).appInsightsKey(this.mojo.getAppInsightsKey()).appInsightsInstance(this.mojo.getAppInsightsInstance()).subscriptionId(this.mojo.getSubscriptionId()).resourceGroup(this.mojo.getResourceGroup()).appName(this.mojo.getAppName()).servicePlanName(this.mojo.getAppServicePlanName()).servicePlanResourceGroup(this.mojo.getAppServicePlanResourceGroup()).deploymentSlotName(this.getDeploymentSlotName()).deploymentSlotConfigurationSource(this.getDeploymentSlotConfigurationSource()).pricingTier(this.getParsedPricingTier()).region(this.getParsedRegion()).runtime(this.getRuntimeConfig()).appSettings(this.mojo.getAppSettings());
    }

    public RuntimeConfig getRuntimeConfig() throws AzureExecutionException {
        RuntimeConfiguration runtime = this.mojo.getRuntimeConfiguration();
        if (runtime == null) {
            return null;
        }
        OperatingSystem os = Optional.ofNullable(runtime.getOs()).map(OperatingSystem::fromString).orElse(null);
        JavaVersion javaVersion = Optional.ofNullable(runtime.getJavaVersion()).map(JavaVersion::fromString).orElse(null);
        RuntimeConfig result = new RuntimeConfig().os(os).javaVersion(javaVersion).webContainer(WebContainer.JAVA_OFF).image(runtime.getImage()).registryUrl(runtime.getRegistryUrl());
        if (StringUtils.isNotEmpty((CharSequence)runtime.getServerId())) {
            MavenDockerCredentialProvider credentialProvider = MavenDockerCredentialProvider.fromMavenSettings((Settings)this.mojo.getSettings(), (String)runtime.getServerId());
            result.username(credentialProvider.getUsername()).password(credentialProvider.getPassword());
        }
        return result;
    }

    private String getDeploymentSlotName() {
        return Optional.ofNullable(this.mojo.getDeploymentSlotSetting()).map(DeploymentSlotSetting::getName).orElse(null);
    }

    private String getDeploymentSlotConfigurationSource() {
        return Optional.ofNullable(this.mojo.getDeploymentSlotSetting()).map(DeploymentSlotSetting::getConfigurationSource).orElse(null);
    }

    private Region getParsedRegion() {
        return Optional.ofNullable(this.mojo.getRegion()).map(Region::fromName).orElse(null);
    }

    private PricingTier getParsedPricingTier() {
        return Optional.ofNullable(this.mojo.getPricingTier()).map(PricingTier::fromString).orElse(null);
    }
}

