/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.toolkit.lib.legacy.function.template.BindingTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionSettingTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.FunctionTemplate;
import com.microsoft.azure.toolkit.lib.legacy.function.template.TemplateResources;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="add")
public class AddMojo
extends AbstractFunctionMojo {
    private static final String LOAD_TEMPLATES = "Step 1 of 4: Load all function templates";
    private static final String LOAD_TEMPLATES_DONE = "Successfully loaded all function templates";
    private static final String FIND_TEMPLATE = "Step 2 of 4: Select function template";
    private static final String FIND_TEMPLATE_DONE = "Successfully found function template: ";
    private static final String FIND_TEMPLATE_FAIL = "Function template not found: ";
    private static final String PREPARE_PARAMS = "Step 3 of 4: Prepare required parameters";
    private static final String FOUND_VALID_VALUE = "Found valid value. Skip user input.";
    private static final String SAVE_FILE = "Step 4 of 4: Saving function to file";
    private static final String SAVE_FILE_DONE = "Successfully saved new function at ";
    private static final String FILE_EXIST = "Function already exists at %s. Please specify a different function name.";
    private static final String DEFAULT_INPUT_ERROR_MESSAGE = "Invalid input, please check and try again.";
    private static final String PROMPT_STRING_WITH_DEFAULT_VALUE = "Enter value for %s(Default: %s): ";
    private static final String PROMPT_STRING_WITHOUT_DEFAULT_VALUE = "Enter value for %s: ";
    private static final String FUNCTION_NAME_REGEXP = "^[a-zA-Z][a-zA-Z\\d_\\-]*$";
    @Parameter(defaultValue="${project.basedir}", readonly=true, required=true)
    protected File basedir;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    protected List<String> compileSourceRoots;
    @Parameter(property="functions.package")
    protected String functionPackageName;
    @Parameter(property="functions.name")
    protected String functionName;
    @Parameter(property="functions.template")
    protected String functionTemplate;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public String getFunctionPackageName() {
        return this.functionPackageName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.getFunctionName().replace('-', '_');
    }

    public String getFunctionTemplate() {
        return this.functionTemplate;
    }

    protected String getBasedir() {
        return this.basedir.getAbsolutePath();
    }

    protected String getSourceRoot() {
        return this.compileSourceRoots == null || this.compileSourceRoots.isEmpty() ? Paths.get(this.getBasedir(), "src", "main", "java").toString() : this.compileSourceRoots.get(0);
    }

    protected void setFunctionPackageName(String functionPackageName) {
        this.functionPackageName = StringUtils.lowerCase((String)functionPackageName);
    }

    protected void setFunctionName(String functionName) {
        this.functionName = StringUtils.capitalize((String)functionName);
    }

    protected void setFunctionTemplate(String functionTemplate) {
        this.functionTemplate = functionTemplate;
    }

    @AzureOperation(name="functionapp.add", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                FunctionExtensionVersion bundleVersion = this.getBundleVersion();
                List<FunctionTemplate> templates = this.loadAllFunctionTemplates(bundleVersion);
                FunctionTemplate template = this.getFunctionTemplate(templates);
                BindingTemplate bindingTemplate = FunctionUtils.loadBindingTemplate((String)template.getTriggerType());
                Map<String, String> params = this.prepareRequiredParameters(template, bindingTemplate);
                String newFunctionClass = this.substituteParametersInTemplate(template, params);
                this.saveNewFunctionToFile(newFunctionClass);
            }
            catch (IOException | MojoFailureException e) {
                throw new AzureExecutionException("Cannot add new java functions.", e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected List<FunctionTemplate> loadAllFunctionTemplates(FunctionExtensionVersion bundleVersion) throws AzureExecutionException {
        Log.info((String)"");
        Log.info((String)LOAD_TEMPLATES);
        List<FunctionTemplate> templates = FunctionUtils.loadAllFunctionTemplates().stream().filter(template -> ObjectUtils.anyNull((Object[])new Object[]{bundleVersion, template.getSupportedExtensionVersions()}) || template.getSupportedExtensionVersions().contains(bundleVersion)).collect(Collectors.toList());
        Log.info((String)LOAD_TEMPLATES_DONE);
        return templates;
    }

    protected FunctionTemplate getFunctionTemplate(List<FunctionTemplate> templates) throws IOException, AzureExecutionException, MojoFailureException {
        Log.info((String)"");
        Log.info((String)FIND_TEMPLATE);
        if (this.settings != null && !this.settings.isInteractiveMode()) {
            this.assureInputInBatchMode(this.getFunctionTemplate(), str -> this.getTemplateNames(templates).stream().filter(Objects::nonNull).anyMatch(o -> o.equalsIgnoreCase((String)str)), this::setFunctionTemplate, true);
        } else {
            this.assureInputFromUser("template for new function", this.getFunctionTemplate(), this.getTemplateNames(templates), this::setFunctionTemplate);
        }
        FunctionTemplate result = this.findTemplateByName(templates, this.getFunctionTemplate());
        this.getTelemetryProxy().addDefaultProperty("triggerType", result.getTriggerType());
        return result;
    }

    protected List<String> getTemplateNames(List<FunctionTemplate> templates) {
        return templates.stream().map(t -> t.getMetadata().getName()).collect(Collectors.toList());
    }

    protected FunctionTemplate findTemplateByName(List<FunctionTemplate> templates, String templateName) throws AzureExecutionException {
        Log.info((String)("Selected function template: " + templateName));
        Optional<FunctionTemplate> template = templates.stream().filter(t -> t.getMetadata().getName().equalsIgnoreCase(templateName)).findFirst();
        if (template.isPresent()) {
            Log.info((String)(FIND_TEMPLATE_DONE + templateName));
            return template.get();
        }
        throw new AzureExecutionException(FIND_TEMPLATE_FAIL + templateName);
    }

    protected Map<String, String> prepareRequiredParameters(FunctionTemplate template, BindingTemplate bindingTemplate) throws MojoFailureException {
        Log.info((String)"");
        Log.info((String)PREPARE_PARAMS);
        this.prepareFunctionName();
        this.preparePackageName();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("functionName", this.getFunctionName());
        params.put("className", this.getClassName());
        params.put("packageName", this.getFunctionPackageName());
        this.prepareTemplateParameters(template, bindingTemplate, params);
        this.displayParameters(params);
        return params;
    }

    protected void prepareFunctionName() throws MojoFailureException {
        Log.info((String)"Common parameter [Function Name]: name for both the new function and Java class");
        if (this.settings != null && !this.settings.isInteractiveMode()) {
            this.assureInputInBatchMode(this.getFunctionName(), str -> StringUtils.isNotEmpty((CharSequence)str) && str.matches(FUNCTION_NAME_REGEXP), this::setFunctionName, true);
        } else {
            this.assureInputFromUser("Enter value for Function Name: ", this.getFunctionName(), str -> StringUtils.isNotEmpty((CharSequence)str) && str.matches(FUNCTION_NAME_REGEXP), "Function name must start with a letter and can contain letters, digits, '_' and '-'", this::setFunctionName);
        }
    }

    protected void preparePackageName() throws MojoFailureException {
        Log.info((String)"Common parameter [Package Name]: package name of the new Java class");
        if (this.settings != null && !this.settings.isInteractiveMode()) {
            this.assureInputInBatchMode(this.getFunctionPackageName(), str -> StringUtils.isNotEmpty((CharSequence)str) && SourceVersion.isName(str), this::setFunctionPackageName, true);
        } else {
            this.assureInputFromUser("Enter value for Package Name: ", this.getFunctionPackageName(), str -> StringUtils.isNotEmpty((CharSequence)str) && SourceVersion.isName(str), "Input should be a valid Java package name.", this::setFunctionPackageName);
        }
    }

    protected Map<String, String> prepareTemplateParameters(FunctionTemplate template, BindingTemplate bindingTemplate, Map<String, String> params) throws MojoFailureException {
        List userPrompt = (List)ObjectUtils.firstNonNull((Object[])new List[]{template.getMetadata().getUserPrompt(), Collections.emptyList()});
        for (String property : userPrompt) {
            String initValue = System.getProperty(property);
            List<String> options = this.getOptionsForUserPrompt(property);
            FunctionSettingTemplate settingTemplate = bindingTemplate == null ? null : bindingTemplate.getSettingTemplateByName(property);
            String helpMessage = settingTemplate != null && settingTemplate.getHelp() != null ? settingTemplate.getHelp() : "";
            Log.info((String)String.format("Trigger specific parameter [%s]:%s", property, TemplateResources.getResource((String)helpMessage)));
            if (this.settings != null && !this.settings.isInteractiveMode()) {
                if (options != null && options.size() > 0) {
                    String foundElement = this.findElementInOptions(options, initValue);
                    initValue = foundElement == null ? options.get(0) : foundElement;
                }
                this.assureInputInBatchMode(initValue, StringUtils::isNotEmpty, str -> params.put(property, (String)str), false);
                continue;
            }
            if (options == null) {
                params.put(property, this.getStringInputFromUser(property, initValue, settingTemplate));
                continue;
            }
            this.assureInputFromUser(String.format("the value for %s: ", property), System.getProperty(property), options, str -> params.put(property, (String)str));
        }
        return params;
    }

    protected String getStringInputFromUser(String attributeName, String initValue, FunctionSettingTemplate template) {
        String defaultValue = template == null ? null : template.getDefaultValue();
        Function<String, Boolean> validator = this.getStringInputValidator(template);
        if (validator.apply(initValue).booleanValue()) {
            Log.info((String)FOUND_VALID_VALUE);
            return initValue;
        }
        Scanner scanner = this.getScanner();
        while (true) {
            System.out.printf(this.getStringInputPromptString(attributeName, defaultValue), new Object[0]);
            System.out.flush();
            String input = scanner.nextLine();
            if (validator.apply(input).booleanValue()) {
                return input;
            }
            if (StringUtils.isNotEmpty((CharSequence)defaultValue) && StringUtils.isEmpty((CharSequence)input)) {
                return defaultValue;
            }
            Log.warn((String)this.getStringInputErrorMessage(template));
        }
    }

    protected String getStringInputErrorMessage(FunctionSettingTemplate template) {
        return template != null && template.getErrorText() != null ? TemplateResources.getResource((String)template.getErrorText()) : DEFAULT_INPUT_ERROR_MESSAGE;
    }

    protected String getStringInputPromptString(String attributeName, String defaultValue) {
        return StringUtils.isBlank((CharSequence)defaultValue) ? String.format(PROMPT_STRING_WITHOUT_DEFAULT_VALUE, attributeName) : String.format(PROMPT_STRING_WITH_DEFAULT_VALUE, attributeName, defaultValue);
    }

    protected Function<String, Boolean> getStringInputValidator(FunctionSettingTemplate template) {
        String regex;
        String string = regex = template == null ? null : template.getSettingRegex();
        if (regex == null) {
            return StringUtils::isNotEmpty;
        }
        return attribute -> StringUtils.isNotEmpty((CharSequence)attribute) && attribute.matches(regex);
    }

    protected void displayParameters(Map<String, String> params) {
        Log.info((String)"");
        Log.info((String)"Summary of parameters for function template:");
        params.entrySet().stream().forEach(e -> Log.info((String)String.format("%s: %s", e.getKey(), e.getValue())));
    }

    protected String substituteParametersInTemplate(FunctionTemplate template, Map<String, String> params) {
        String ret = (String)template.getFiles().get("function.java");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            ret = ret.replace(String.format("$%s$", entry.getKey()), entry.getValue());
        }
        return ret;
    }

    protected void saveNewFunctionToFile(String newFunctionClass) throws IOException, AzureExecutionException {
        Log.info((String)"");
        Log.info((String)SAVE_FILE);
        File packageDir = this.getPackageDir();
        File targetFile = this.getTargetFile(packageDir);
        this.createPackageDirIfNotExist(packageDir);
        this.saveToTargetFile(targetFile, newFunctionClass);
        Log.info((String)(SAVE_FILE_DONE + targetFile.getAbsolutePath()));
    }

    protected File getPackageDir() {
        String sourceRoot = this.getSourceRoot();
        String[] packageName = this.getFunctionPackageName().split("\\.");
        return Paths.get(sourceRoot, packageName).toFile();
    }

    protected File getTargetFile(File packageDir) throws AzureExecutionException {
        String javaFileName = this.getClassName() + ".java";
        File targetFile = new File(packageDir, javaFileName);
        if (targetFile.exists()) {
            throw new AzureExecutionException(String.format(FILE_EXIST, targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    protected void createPackageDirIfNotExist(File packageDir) {
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
    }

    protected void saveToTargetFile(File targetFile, String newFunctionClass) throws IOException {
        try (FileOutputStream os = new FileOutputStream(targetFile);){
            IOUtil.copy((String)newFunctionClass, (OutputStream)os);
        }
    }

    protected void assureInputFromUser(String prompt, String initValue, List<String> options, Consumer<String> setter) {
        String option = this.findElementInOptions(options, initValue);
        if (option != null) {
            Log.info((String)FOUND_VALID_VALUE);
            setter.accept(option);
            return;
        }
        System.out.printf("Choose from below options as %s %n", prompt);
        for (int i = 0; i < options.size(); ++i) {
            System.out.printf("%d. %s%n", i, options.get(i));
        }
        this.assureInputFromUser("Enter index to use: ", null, str -> {
            try {
                int index = Integer.parseInt(str);
                return 0 <= index && index < options.size();
            }
            catch (Exception e) {
                return false;
            }
        }, "Invalid index.", str -> {
            int index = Integer.parseInt(str);
            setter.accept((String)options.get(index));
        });
    }

    protected void assureInputFromUser(String prompt, String initValue, Function<String, Boolean> validator, String errorMessage, Consumer<String> setter) {
        if (validator.apply(initValue).booleanValue()) {
            Log.info((String)FOUND_VALID_VALUE);
            setter.accept(initValue);
            return;
        }
        Scanner scanner = this.getScanner();
        while (true) {
            System.out.printf(prompt, new Object[0]);
            System.out.flush();
            try {
                String input = scanner.nextLine();
                if (validator.apply(input).booleanValue()) {
                    setter.accept(input);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.warn((String)errorMessage);
        }
    }

    protected void assureInputInBatchMode(String input, Function<String, Boolean> validator, Consumer<String> setter, boolean required) throws MojoFailureException {
        if (validator.apply(input).booleanValue()) {
            Log.info((String)FOUND_VALID_VALUE);
            setter.accept(input);
            return;
        }
        if (required) {
            throw new MojoFailureException(String.format("invalid input: %s", input));
        }
        System.out.printf("The input is invalid. Use empty string.%n", new Object[0]);
        setter.accept("");
    }

    protected Scanner getScanner() {
        return new Scanner(System.in, "UTF-8");
    }

    @Nullable
    private String findElementInOptions(List<String> options, String item) {
        return options.stream().filter(o -> o != null && o.equalsIgnoreCase(item)).findFirst().orElse(null);
    }

    @Nullable
    private List<String> getOptionsForUserPrompt(String promptName) {
        if ("authlevel".equalsIgnoreCase(promptName.trim())) {
            return Arrays.asList("ANONYMOUS", "FUNCTION", "ADMIN");
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)promptName.trim(), (CharSequence[])new CharSequence[]{"createLeaseCollectionIfNotExists", "createLeaseContainerIfNotExists"})) {
            return Arrays.asList("true", "false");
        }
        if ("protocol".equalsIgnoreCase(promptName.trim())) {
            return Arrays.asList("NOTSET", "PLAINTEXT", "SSL", "SASLPLAINTEXT", "SASLSSL");
        }
        if ("authenticationMode".equalsIgnoreCase(promptName.trim())) {
            return Arrays.asList("NOTSET", "GSSAPI", "PLAIN", "SCRAMSHA256", "SCRAMSHA512");
        }
        return null;
    }

    static {
        AddMojo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AddMojo.java", AddMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.function.AddMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 148);
    }
}

