/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="list")
public class ListMojo
extends AbstractFunctionMojo {
    protected static final String TEMPLATES_START = ">> templates begin <<";
    protected static final String TEMPLATES_END = ">> templates end <<";
    protected static final String BINDINGS_START = ">> bindings begin <<";
    protected static final String BINDINGS_END = ">> bindings end <<";
    protected static final String RESOURCES_START = ">> resources begin <<";
    protected static final String RESOURCES_END = ">> resources end <<";
    protected static final String TEMPLATES_FILE = "/templates.json";
    protected static final String BINDINGS_FILE = "/bindings.json";
    protected static final String RESOURCES_FILE = "/resources.json";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="functionapp.list", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            try {
                Log.info((String)TEMPLATES_START);
                this.printToSystemOut(TEMPLATES_FILE);
                Log.info((String)TEMPLATES_END);
                Log.info((String)BINDINGS_START);
                this.printToSystemOut(BINDINGS_FILE);
                Log.info((String)BINDINGS_END);
                Log.info((String)RESOURCES_START);
                this.printToSystemOut(RESOURCES_FILE);
                Log.info((String)RESOURCES_END);
            }
            catch (IOException e) {
                throw new AzureExecutionException("IO error when printing templates:" + e.getMessage(), (Throwable)e);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected void printToSystemOut(String file) throws IOException {
        try (InputStream is = ListMojo.class.getResourceAsStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)System.out);
        }
    }

    static {
        ListMojo.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ListMojo.java", ListMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.function.ListMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 41);
    }
}

