/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.Binding;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.AnnotationHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.AnnotationHandlerImpl;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.FunctionCoreToolsHandler;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.FunctionCoreToolsHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractFunctionMojo {
    public static final String SEARCH_FUNCTIONS = "Step 1 of 8: Searching for Azure Functions entry points";
    public static final String FOUND_FUNCTIONS = " Azure Functions entry point(s) found.";
    public static final String NO_FUNCTIONS = "Azure Functions entry point not found, plugin will exit.";
    public static final String GENERATE_CONFIG = "Step 2 of 8: Generating Azure Functions configurations";
    public static final String GENERATE_SKIP = "No Azure Functions found. Skip configuration generation.";
    public static final String GENERATE_DONE = "Generation done.";
    public static final String VALIDATE_CONFIG = "Step 3 of 8: Validating generated configurations";
    public static final String VALIDATE_SKIP = "No configurations found. Skip validation.";
    public static final String VALIDATE_DONE = "Validation done.";
    public static final String SAVING_HOST_JSON = "Step 4 of 8: Copying/creating host.json";
    public static final String SAVING_LOCAL_SETTINGS_JSON = "Step 5 of 8: Copying/creating local.settings.json";
    public static final String SAVE_FUNCTION_JSONS = "Step 6 of 8: Saving configurations to function.json";
    public static final String SAVE_SKIP = "No configurations found. Skip save.";
    public static final String SAVE_FUNCTION_JSON = "Starting processing function: ";
    public static final String SAVE_SUCCESS = "Successfully saved to ";
    public static final String COPY_JARS = "Step 7 of 8: Copying JARs to staging directory ";
    public static final String COPY_SUCCESS = "Copied successfully.";
    public static final String INSTALL_EXTENSIONS = "Step 8 of 8: Installing function extensions if needed";
    public static final String SKIP_INSTALL_EXTENSIONS_HTTP = "Skip install Function extension for HTTP Trigger Functions";
    public static final String INSTALL_EXTENSIONS_FINISH = "Function extension installation done.";
    public static final String BUILD_SUCCESS = "Successfully built Azure Functions.";
    public static final String FUNCTION_JSON = "function.json";
    public static final String EXTENSION_BUNDLE = "extensionBundle";
    private static final String AZURE_FUNCTIONS_JAVA_CORE_LIBRARY = "azure-functions-java-core-library";
    private static final String DEFAULT_LOCAL_SETTINGS_JSON = "{ \"IsEncrypted\": false, \"Values\": { \"FUNCTIONS_WORKER_RUNTIME\": \"java\" } }";
    private static final String DEFAULT_HOST_JSON = "{\"version\":\"2.0\",\"extensionBundle\":{\"id\":\"Microsoft.Azure.Functions.ExtensionBundle\",\"version\":\"[3.*, 4.0.0)\"}}\n";
    private static final BindingEnum[] FUNCTION_WITHOUT_FUNCTION_EXTENSION;
    private static final String EXTENSION_BUNDLE_ID = "Microsoft.Azure.Functions.ExtensionBundle";
    private static final String EXTENSION_BUNDLE_PREVIEW_ID = "Microsoft.Azure.Functions.ExtensionBundle.Preview";
    private static final String SKIP_INSTALL_EXTENSIONS_FLAG = "skipInstallExtensions flag is set, skip install extension";
    private static final String SKIP_INSTALL_EXTENSIONS_BUNDLE = "Extension bundle specified, skip install extension";
    private static final String CAN_NOT_FIND_ARTIFACT = "Cannot find the maven artifact, please run `mvn package` first.";
    @Parameter(property="functions.skipInstallExtensions", defaultValue="false")
    protected boolean skipInstallExtensions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(name="functionapp.package", type=AzureOperation.Type.ACTION)
    protected void doExecute() throws AzureExecutionException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            Set<Method> methods;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.validateAppName();
            this.validateFunctionCompatibility();
            this.promptCompileInfo();
            AnnotationHandler annotationHandler = this.getAnnotationHandler();
            try {
                methods = this.findAnnotatedMethods(annotationHandler);
            }
            catch (MalformedURLException e) {
                throw new AzureExecutionException("Invalid URL when resolving class path:" + e.getMessage(), (Throwable)e);
            }
            if (methods.size() == 0) {
                Log.info((String)NO_FUNCTIONS);
            } else {
                Map<String, FunctionConfiguration> configMap = this.getFunctionConfigurations(annotationHandler, methods);
                this.trackFunctionProperties(configMap);
                this.validateFunctionConfigurations(configMap);
                ObjectWriter objectWriter = this.getObjectWriter();
                try {
                    this.copyHostJson();
                    this.copyLocalSettingsJson();
                    this.writeFunctionJsonFiles(objectWriter, configMap);
                    this.copyJarsToStageDirectory();
                }
                catch (IOException e) {
                    throw new AzureExecutionException("Cannot perform IO operations due to error:" + e.getMessage(), (Throwable)e);
                }
                CommandHandlerImpl commandHandler = new CommandHandlerImpl();
                FunctionCoreToolsHandler functionCoreToolsHandler = this.getFunctionCoreToolsHandler((CommandHandler)commandHandler);
                Set<BindingEnum> bindingClasses = this.getFunctionBindingEnums(configMap);
                this.installExtension(functionCoreToolsHandler, bindingClasses);
                Log.info((String)BUILD_SUCCESS);
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    protected AnnotationHandler getAnnotationHandler() {
        return new AnnotationHandlerImpl();
    }

    protected Set<Method> findAnnotatedMethods(AnnotationHandler handler) throws MalformedURLException {
        Set functions;
        Log.info((String)"");
        Log.info((String)SEARCH_FUNCTIONS);
        try {
            Log.debug((String)("ClassPath to resolve: " + this.getTargetClassUrl()));
            List<URL> dependencyWithTargetClass = this.getDependencyArtifactUrls();
            dependencyWithTargetClass.add(this.getTargetClassUrl());
            functions = handler.findFunctions(dependencyWithTargetClass);
        }
        catch (NoClassDefFoundError e) {
            Log.debug((String)("ClassPath to resolve: " + this.getArtifactUrl()));
            functions = handler.findFunctions(Arrays.asList(this.getArtifactUrl()));
        }
        Log.info((String)(functions.size() + FOUND_FUNCTIONS));
        return functions;
    }

    protected URL getArtifactUrl() throws MalformedURLException {
        return this.getProject().getArtifact().getFile().toURI().toURL();
    }

    protected URL getTargetClassUrl() throws MalformedURLException {
        return this.outputDirectory.toURI().toURL();
    }

    protected List<URL> getDependencyArtifactUrls() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList runtimeClasspathElements = new ArrayList();
        try {
            runtimeClasspathElements.addAll(this.getProject().getRuntimeClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            Log.debug((String)("Failed to resolve dependencies for compile scope, exception: " + e.getMessage()));
        }
        for (String element : runtimeClasspathElements) {
            File f = new File(element);
            try {
                urlList.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Log.debug((String)("Failed to get URL for file: " + f.toString()));
            }
        }
        return urlList;
    }

    protected Map<String, FunctionConfiguration> getFunctionConfigurations(AnnotationHandler handler, Set<Method> methods) throws AzureExecutionException {
        Log.info((String)"");
        Log.info((String)GENERATE_CONFIG);
        Map configMap = handler.generateConfigurations(methods);
        if (configMap.size() == 0) {
            Log.info((String)GENERATE_SKIP);
        } else {
            String scriptFilePath = this.getScriptFilePath();
            configMap.values().forEach(config -> config.setScriptFile(scriptFilePath));
            Log.info((String)GENERATE_DONE);
        }
        return configMap;
    }

    protected String getScriptFilePath() {
        return String.format("../%s.jar", this.getFinalName());
    }

    protected void validateFunctionConfigurations(Map<String, FunctionConfiguration> configMap) {
        Log.info((String)"");
        Log.info((String)VALIDATE_CONFIG);
        if (configMap.size() == 0) {
            Log.info((String)VALIDATE_SKIP);
        } else {
            configMap.values().forEach(FunctionConfiguration::validate);
            Log.info((String)VALIDATE_DONE);
        }
    }

    protected void writeFunctionJsonFiles(ObjectWriter objectWriter, Map<String, FunctionConfiguration> configMap) throws IOException {
        Log.info((String)"");
        Log.info((String)SAVE_FUNCTION_JSONS);
        if (configMap.size() == 0) {
            Log.info((String)SAVE_SKIP);
        } else {
            for (Map.Entry<String, FunctionConfiguration> config : configMap.entrySet()) {
                this.writeFunctionJsonFile(objectWriter, config.getKey(), config.getValue());
            }
        }
    }

    protected void writeFunctionJsonFile(ObjectWriter objectWriter, String functionName, FunctionConfiguration config) throws IOException {
        Log.info((String)(SAVE_FUNCTION_JSON + functionName));
        File functionJsonFile = Paths.get(this.getDeploymentStagingDirectoryPath(), functionName, FUNCTION_JSON).toFile();
        this.writeObjectToFile(objectWriter, config, functionJsonFile);
        Log.info((String)(SAVE_SUCCESS + functionJsonFile.getAbsolutePath()));
    }

    protected void copyHostJson() throws IOException {
        Log.info((String)"");
        Log.info((String)SAVING_HOST_JSON);
        File sourceHostJsonFile = this.getHostJsonFile();
        File destHostJsonFile = Paths.get(this.getDeploymentStagingDirectoryPath(), "host.json").toFile();
        PackageMojo.copyFilesWithDefaultContent(sourceHostJsonFile, destHostJsonFile, DEFAULT_HOST_JSON);
        Log.info((String)(SAVE_SUCCESS + destHostJsonFile.getAbsolutePath()));
    }

    protected void copyLocalSettingsJson() throws IOException {
        Log.info((String)"");
        Log.info((String)SAVING_LOCAL_SETTINGS_JSON);
        File sourceLocalSettingsJsonFile = this.getLocalSettingsJsonFile();
        File destLocalSettingsJsonFile = Paths.get(this.getDeploymentStagingDirectoryPath(), "local.settings.json").toFile();
        PackageMojo.copyFilesWithDefaultContent(sourceLocalSettingsJsonFile, destLocalSettingsJsonFile, DEFAULT_LOCAL_SETTINGS_JSON);
        Log.info((String)(SAVE_SUCCESS + destLocalSettingsJsonFile.getAbsolutePath()));
    }

    private static void copyFilesWithDefaultContent(File source, File dest, String defaultContent) throws IOException {
        if (source != null && source.exists()) {
            FileUtils.copyFile((File)source, (File)dest);
        } else {
            FileUtils.write((File)dest, (CharSequence)defaultContent, (Charset)Charset.defaultCharset());
        }
    }

    protected void writeObjectToFile(ObjectWriter objectWriter, Object object, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        objectWriter.writeValue(targetFile, object);
    }

    protected ObjectWriter getObjectWriter() {
        DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n");
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).writer((PrettyPrinter)prettyPrinter);
    }

    protected void copyJarsToStageDirectory() throws IOException, AzureExecutionException {
        String stagingDirectory = this.getDeploymentStagingDirectoryPath();
        Log.info((String)"");
        Log.info((String)(COPY_JARS + stagingDirectory));
        File libFolder = Paths.get(stagingDirectory, "lib").toFile();
        if (libFolder.exists()) {
            FileUtils.cleanDirectory((File)libFolder);
        }
        Set artifacts = this.project.getArtifacts();
        String libraryToExclude = artifacts.stream().filter(artifact -> StringUtils.equalsAnyIgnoreCase((CharSequence)artifact.getArtifactId(), (CharSequence[])new CharSequence[]{AZURE_FUNCTIONS_JAVA_CORE_LIBRARY})).map(Artifact::getArtifactId).findFirst().orElse("azure-functions-java-library");
        for (Artifact artifact2 : artifacts) {
            if (StringUtils.equalsIgnoreCase((CharSequence)artifact2.getArtifactId(), (CharSequence)libraryToExclude)) continue;
            PackageMojo.copyFileToDirectory(artifact2.getFile(), libFolder);
        }
        PackageMojo.copyFileToDirectory(this.getArtifactFile(), new File(stagingDirectory));
        Log.info((String)COPY_SUCCESS);
    }

    public List<DeploymentResource> getResources() {
        DeploymentResource resource = new DeploymentResource();
        resource.setDirectory(this.getBuildDirectoryAbsolutePath());
        resource.setTargetPath("/");
        resource.setFiltering(false);
        resource.setIncludes(Collections.singletonList("*.jar"));
        return Collections.singletonList(resource);
    }

    protected FunctionCoreToolsHandler getFunctionCoreToolsHandler(CommandHandler commandHandler) {
        return new FunctionCoreToolsHandlerImpl(commandHandler);
    }

    protected void installExtension(FunctionCoreToolsHandler handler, Set<BindingEnum> bindingEnums) throws AzureExecutionException {
        Log.info((String)INSTALL_EXTENSIONS);
        if (!this.isInstallingExtensionNeeded(bindingEnums)) {
            return;
        }
        handler.installExtension(new File(this.getDeploymentStagingDirectoryPath()), this.project.getBasedir());
        Log.info((String)INSTALL_EXTENSIONS_FINISH);
    }

    protected Set<BindingEnum> getFunctionBindingEnums(Map<String, FunctionConfiguration> configMap) {
        HashSet<BindingEnum> result = new HashSet<BindingEnum>();
        configMap.values().forEach(configuration -> configuration.getBindings().forEach(binding -> result.add(binding.getBindingEnum())));
        return result;
    }

    protected boolean isInstallingExtensionNeeded(Set<BindingEnum> bindingTypes) {
        if (this.skipInstallExtensions) {
            Log.info((String)SKIP_INSTALL_EXTENSIONS_FLAG);
            return false;
        }
        String extensionBundleId = Optional.ofNullable(this.readHostJson()).map(node -> node.at("/extensionBundle/id")).filter(node -> !node.isMissingNode()).map(JsonNode::asText).orElse(null);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)extensionBundleId, (CharSequence[])new CharSequence[]{EXTENSION_BUNDLE_ID, EXTENSION_BUNDLE_PREVIEW_ID})) {
            Log.info((String)SKIP_INSTALL_EXTENSIONS_BUNDLE);
            return false;
        }
        boolean isNonHttpTriggersExist = bindingTypes.stream().anyMatch(binding -> !Arrays.asList(FUNCTION_WITHOUT_FUNCTION_EXTENSION).contains(binding));
        if (!isNonHttpTriggersExist) {
            Log.info((String)SKIP_INSTALL_EXTENSIONS_HTTP);
            return false;
        }
        return true;
    }

    protected void promptCompileInfo() throws AzureExecutionException {
        Log.info((String)String.format("Java home : %s", System.getenv("JAVA_HOME")));
        Log.info((String)String.format("Artifact compile version : %s", Utils.getArtifactCompileVersion((File)this.getArtifactFile())));
    }

    private File getArtifactFile() throws AzureExecutionException {
        Artifact artifact = this.project.getArtifact();
        if (artifact.getFile() != null) {
            return artifact.getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        String packaging = this.project.getPackaging();
        File result = new File(this.buildDirectory, StringUtils.join((Object[])new Serializable[]{finalName, Character.valueOf('.'), packaging}));
        if (!result.exists()) {
            throw new AzureExecutionException(CAN_NOT_FIND_ARTIFACT);
        }
        return result;
    }

    protected void trackFunctionProperties(Map<String, FunctionConfiguration> configMap) {
        List bindingTypeSet = configMap.values().stream().flatMap(configuration -> configuration.getBindings().stream()).map(Binding::getType).sorted().distinct().collect(Collectors.toList());
        this.getTelemetryProxy().addDefaultProperty("triggerType", StringUtils.join(bindingTypeSet, (String)","));
    }

    private static void copyFileToDirectory(@Nonnull File srcFile, @Nonnull File destFile) throws IOException {
        if (!Objects.equals(srcFile.getParentFile(), destFile)) {
            FileUtils.copyFileToDirectory((File)srcFile, (File)destFile);
        }
    }

    static {
        PackageMojo.ajc$preClinit();
        FUNCTION_WITHOUT_FUNCTION_EXTENSION = new BindingEnum[]{BindingEnum.HttpOutput, BindingEnum.HttpTrigger};
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PackageMojo.java", PackageMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.function.PackageMojo", "", "", "com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException", "void"), 113);
    }
}

