/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.ConfigParser;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.FunctionAppConfig;
import com.microsoft.azure.toolkit.lib.appservice.config.RuntimeConfig;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.JavaVersion;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.CreateOrUpdateFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.DeployFunctionAppTask;
import com.microsoft.azure.toolkit.lib.appservice.task.StreamingLogTask;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceConfigUtils;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    private static final String APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT = "Contradictory configurations for application insights, specify 'appInsightsKey' or 'appInsightsInstance' if you want to enable it, and specify 'disableAppInsights=true' if you want to disable it.";
    private static final String ARTIFACT_INCOMPATIBLE_WARNING = "Your function app artifact compile version {0} may not compatible with java version {1} in configuration.";
    private static final String ARTIFACT_INCOMPATIBLE_ERROR = "Your function app artifact compile version {0} is not compatible with java version {1} in configuration, please downgrade the project compile version and try again.";
    private static final String NO_ARTIFACT_FOUNDED = "Failed to find function artifact '%s.jar' in folder '%s', please re-package the project and try again.";
    private static final String APP_NAME_PATTERN = "[a-zA-Z0-9\\-]{2,60}";
    private static final String RESOURCE_GROUP_PATTERN = "[a-zA-Z0-9._\\-()]{1,90}";
    private static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String APP_SERVICE_PLAN_NAME_PATTERN = "[a-zA-Z0-9\\-]{1,40}";
    private static final List<Integer> VALID_CONTAINER_SIZE;
    private static final String EMPTY_APP_NAME = "Please config the <appName> in pom.xml.";
    private static final String INVALID_APP_NAME = "The <appName> only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.";
    private static final String EMPTY_RESOURCE_GROUP = "Please config the <resourceGroup> in pom.xml.";
    private static final String INVALID_RESOURCE_GROUP_NAME = "The <resourceGroup> only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String INVALID_SERVICE_PLAN_NAME = "Invalid value for <appServicePlanName>, it need to match the pattern %s";
    private static final String INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME = "Invalid value for <appServicePlanResourceGroup>, it only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.";
    private static final String EMPTY_SLOT_NAME = "Please config the <name> of <deploymentSlot> in pom.xml";
    private static final String INVALID_SLOT_NAME = "Invalid value of <name> inside <deploymentSlot> in pom.xml, it needs to match the pattern '%s'";
    private static final String EMPTY_IMAGE_NAME = "Please config the <image> of <runtime> in pom.xml.";
    private static final String INVALID_OS = "The value of <os> is not correct, supported values are: windows, linux and docker.";
    private static final String EXPANDABLE_PRICING_TIER_WARNING = "'%s' may not be a valid pricing tier, please refer to https://aka.ms/maven_function_configuration#supported-pricing-tiers for valid values";
    private static final String EXPANDABLE_REGION_WARNING = "'%s' may not be a valid region, please refer to https://aka.ms/maven_function_configuration#supported-regions for valid values";
    private static final String EXPANDABLE_JAVA_VERSION_WARNING = "'%s' may not be a valid java version, recommended values are `Java 8`, `Java 11` and `Java 17`";
    private static final String CV2_INVALID_CONTAINER_SIZE = "Invalid container size for flex consumption plan, valid values are: %s";
    private static final String CV2_INVALID_RUNTIME = "Windows runtime is not supported within flex consumption service plan";
    private static final String CV2_INVALID_MAX_INSTANCE = "Invalid maximum instances for flex consumption plan, the limit is 1000";
    public static final int MAX_MAX_INSTANCES = 1000;
    public static final String CV2_INVALID_ALWAYS_READY_INSTANCE = "'alwaysReadyInstances' must be less than or equal to 'maximumInstances'";
    public static final String CV2_INVALID_JAVA_VERSION = "Invalid java version for flex consumption plan, only java 17 is supported";
    @JsonProperty
    @Parameter(property="deploymentType")
    protected String deploymentType;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @AzureOperation(value="user/functionapp.deploy_app")
    protected void doExecute() throws Throwable {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            this.mergeCommandLineConfig();
            this.doValidate();
            this.initAzureAppServiceClient();
            ConfigParser parser = this.getParser();
            FunctionAppConfig config = parser.parseConfig();
            FunctionApp app = (FunctionApp)((AzureFunctions)Azure.az(AzureFunctions.class)).functionApps(config.subscriptionId()).updateOrCreate(config.appName(), config.resourceGroup());
            try {
                FunctionAppBase<?, ?, ?> target = this.createOrUpdateResource(app);
                this.deployArtifact(target);
            }
            catch (Exception e) {
                new StreamingLogTask((AppServiceAppBase)app).execute();
                throw new AzureToolkitRuntimeException((Throwable)e);
            }
            this.updateTelemetryProperties();
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private void mergeCommandLineConfig() {
        try {
            JavaPropsMapper mapper = new JavaPropsMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            DeployMojo commandLineConfig = (DeployMojo)((Object)mapper.readSystemPropertiesAs(JavaPropsSchema.emptySchema(), DeployMojo.class));
            Utils.copyProperties((Object)((Object)this), (Object)((Object)commandLineConfig), (boolean)false);
        }
        catch (IOException | IllegalAccessException e) {
            throw new AzureToolkitRuntimeException("failed to merge command line configuration", (Throwable)e);
        }
    }

    protected void doValidate() throws AzureExecutionException {
        this.validateParameters();
        this.validateFunctionCompatibility();
        this.validateArtifactCompileVersion();
        this.validateApplicationInsightsConfiguration();
    }

    private void validateArtifactCompileVersion() throws AzureExecutionException {
        RuntimeConfig runtimeConfig = this.getParser().getRuntimeConfig();
        String javaVersion = Optional.ofNullable(runtimeConfig).map(RuntimeConfig::javaVersion).map(JavaVersion::getValue).orElse("");
        DeployMojo.validateArtifactCompileVersion((String)javaVersion, (File)this.getArtifact(), (boolean)this.getFailsOnRuntimeValidationError());
    }

    @Deprecated
    protected void validateParameters() {
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            throw new AzureToolkitRuntimeException(EMPTY_APP_NAME);
        }
        if (this.appName.startsWith("-") || !this.appName.matches(APP_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_APP_NAME);
        }
        if (StringUtils.isBlank((CharSequence)this.resourceGroup)) {
            throw new AzureToolkitRuntimeException(EMPTY_RESOURCE_GROUP);
        }
        if (this.resourceGroup.endsWith(".") || !this.resourceGroup.matches(RESOURCE_GROUP_PATTERN)) {
            throw new AzureToolkitRuntimeException(INVALID_RESOURCE_GROUP_NAME);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appServicePlanName) && !this.appServicePlanName.matches(APP_SERVICE_PLAN_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SERVICE_PLAN_NAME, APP_SERVICE_PLAN_NAME_PATTERN));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.appServicePlanResourceGroup) && (this.appServicePlanResourceGroup.endsWith(".") || !this.appServicePlanResourceGroup.matches(RESOURCE_GROUP_PATTERN))) {
            throw new AzureToolkitRuntimeException(INVALID_SERVICE_PLAN_RESOURCE_GROUP_NAME);
        }
        if (this.deploymentSlotSetting != null && StringUtils.isEmpty((CharSequence)this.deploymentSlotSetting.getName())) {
            throw new AzureToolkitRuntimeException(EMPTY_SLOT_NAME);
        }
        if (this.deploymentSlotSetting != null && !this.deploymentSlotSetting.getName().matches(SLOT_NAME_PATTERN)) {
            throw new AzureToolkitRuntimeException(String.format(INVALID_SLOT_NAME, SLOT_NAME_PATTERN));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.region) && Region.fromName((String)this.region).isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(EXPANDABLE_REGION_WARNING, this.region));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runtime.getOs()) && OperatingSystem.fromString((String)this.runtime.getOs()) == null) {
            throw new AzureToolkitRuntimeException(INVALID_OS);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.runtime.getJavaVersion()) && JavaVersion.fromString((String)this.runtime.getJavaVersion()).isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(EXPANDABLE_JAVA_VERSION_WARNING, this.runtime.getJavaVersion()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.pricingTier) && PricingTier.fromString((String)this.pricingTier).isExpandedValue()) {
            AzureMessager.getMessager().warning(String.format(EXPANDABLE_PRICING_TIER_WARNING, this.pricingTier));
        }
        if (OperatingSystem.fromString((String)this.runtime.getOs()) == OperatingSystem.DOCKER && StringUtils.isEmpty((CharSequence)this.runtime.getImage())) {
            throw new AzureToolkitRuntimeException(EMPTY_IMAGE_NAME);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.pricingTier) && PricingTier.fromString((String)this.pricingTier).isFlexConsumption()) {
            if (Objects.nonNull(this.instanceSize) && !VALID_CONTAINER_SIZE.contains(this.instanceSize)) {
                throw new AzureToolkitRuntimeException(String.format(CV2_INVALID_CONTAINER_SIZE, VALID_CONTAINER_SIZE.stream().map(String::valueOf).collect(Collectors.joining(","))));
            }
            if (Objects.nonNull(this.maximumInstances) && this.maximumInstances > 1000) {
                throw new AzureToolkitRuntimeException(CV2_INVALID_MAX_INSTANCE);
            }
            if (ObjectUtils.allNotNull((Object[])new Object[]{this.maximumInstances, this.alwaysReadyInstances}) && this.alwaysReadyInstances > this.maximumInstances) {
                throw new AzureToolkitRuntimeException(CV2_INVALID_ALWAYS_READY_INSTANCE);
            }
            if (StringUtils.isEmpty((CharSequence)this.runtime.getOs()) || OperatingSystem.fromString((String)this.runtime.getOs()) == OperatingSystem.WINDOWS) {
                throw new AzureToolkitRuntimeException(CV2_INVALID_RUNTIME);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.runtime.getJavaVersion()) && Utils.getJavaMajorVersion((String)this.runtime.getJavaVersion()) < 17) {
                throw new AzureToolkitRuntimeException(CV2_INVALID_JAVA_VERSION);
            }
        }
    }

    protected FunctionAppBase<?, ?, ?> createOrUpdateResource(FunctionApp app) throws Throwable {
        FunctionAppConfig config = this.parser.parseConfig();
        boolean newFunctionApp = !app.exists();
        FunctionAppConfig defaultConfig = !newFunctionApp ? AppServiceConfigUtils.fromFunctionApp((FunctionAppBase)app, (AppServicePlan)Objects.requireNonNull(app.getAppServicePlan())) : this.buildDefaultConfig(config.subscriptionId(), config.resourceGroup(), config.appName());
        AppServiceConfigUtils.mergeAppServiceConfig((AppServiceConfig)config, (AppServiceConfig)defaultConfig);
        if (!newFunctionApp && !config.disableAppInsights() && StringUtils.isEmpty((CharSequence)config.appInsightsKey())) {
            config.appInsightsKey((String)Objects.requireNonNull(app.getAppSettings()).get("APPINSIGHTS_INSTRUMENTATIONKEY"));
        }
        return new CreateOrUpdateFunctionAppTask(config).doExecute();
    }

    private FunctionAppConfig buildDefaultConfig(String subscriptionId, String resourceGroup, String appName) {
        FunctionAppConfig appServiceConfig = AppServiceConfig.buildDefaultFunctionConfig((String)resourceGroup, (String)appName);
        appServiceConfig.subscriptionId(subscriptionId);
        List regions = ((AppServiceServiceSubscription)((AzureAppService)Azure.az(AzureAppService.class)).forSubscription(subscriptionId)).listSupportedRegions();
        appServiceConfig.region((Region)Utils.selectFirstOptionIfCurrentInvalid((String)"region", (List)regions, (Object)appServiceConfig.region()));
        return appServiceConfig;
    }

    private void deployArtifact(FunctionAppBase<?, ?, ?> target) {
        File file = new File(this.getDeploymentStagingDirectoryPath());
        FunctionDeployType type = StringUtils.isEmpty((CharSequence)this.deploymentType) ? null : FunctionDeployType.fromString((String)this.deploymentType);
        new DeployFunctionAppTask(target, file, type, true).doExecute();
    }

    private void validateApplicationInsightsConfiguration() throws AzureExecutionException {
        if (this.isDisableAppInsights() && (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey()) || StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()))) {
            throw new AzureExecutionException(APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT);
        }
    }

    static {
        DeployMojo.ajc$preClinit();
        VALID_CONTAINER_SIZE = Arrays.asList(512, 2048, 4096);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeployMojo.java", DeployMojo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "doExecute", "com.microsoft.azure.maven.function.DeployMojo", "", "", "java.lang.Throwable", "void"), 107);
    }
}

