/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class AzureStorageHelper {
    public static String uploadFileAsBlob(File fileToUpload, CloudStorageAccount storageAccount, String containerName, String blobName) throws Exception {
        CloudBlobContainer blobContainer = AzureStorageHelper.getBlobContainer(storageAccount, containerName);
        blobContainer.createIfNotExists(BlobContainerPublicAccessType.BLOB, null, null);
        CloudBlockBlob blob = blobContainer.getBlockBlobReference(blobName);
        blob.upload((InputStream)new FileInputStream(fileToUpload), fileToUpload.length());
        return blob.getUri().toString();
    }

    public static void deleteBlob(CloudStorageAccount storageAccount, String containerName, String blobName) throws Exception {
        CloudBlobContainer blobContainer = AzureStorageHelper.getBlobContainer(storageAccount, containerName);
        if (blobContainer.exists()) {
            CloudBlockBlob blob = blobContainer.getBlockBlobReference(blobName);
            blob.deleteIfExists();
        }
    }

    protected static CloudBlobContainer getBlobContainer(CloudStorageAccount storageAccount, String containerName) throws Exception {
        CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
        return blobClient.getContainerReference(containerName);
    }
}

