/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.azure.core.implementation.SemanticVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import com.microsoft.azure.maven.appservice.AbstractAppServiceMojo;
import com.microsoft.azure.maven.function.ConfigParser;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.utils.FunctionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFunctionMojo
extends AbstractAppServiceMojo {
    protected static final String HOST_JSON = "host.json";
    protected static final String LOCAL_SETTINGS_JSON = "local.settings.json";
    protected static final String TRIGGER_TYPE = "triggerType";
    protected static final String AZURE_FUNCTIONS_JAVA_LIBRARY = "azure-functions-java-library";
    protected static final String CAN_NOT_FIND_ARTIFACT = "Cannot find the maven artifact, please run `mvn package` first.";
    protected static final Map<FunctionExtensionVersion, Set<Integer>> FUNCTION_EXTENSION_LIBRARY_MAP = new HashMap<FunctionExtensionVersion, Set<Integer>>(){
        {
            this.put(FunctionExtensionVersion.VERSION_2, Sets.newHashSet((Object[])new Integer[]{1, 2}));
            this.put(FunctionExtensionVersion.VERSION_3, Sets.newHashSet((Object[])new Integer[]{1, 2}));
            this.put(FunctionExtensionVersion.VERSION_4, Sets.newHashSet((Object[])new Integer[]{3}));
        }
    };
    private static final String FUNCTION_JAVA_VERSION_KEY = "functionJavaVersion";
    private static final String DISABLE_APP_INSIGHTS_KEY = "disableAppInsights";
    private static final String FUNCTION_RUNTIME_KEY = "os";
    private static final String FUNCTION_IS_DOCKER_KEY = "isDockerFunction";
    private static final String FUNCTION_REGION_KEY = "region";
    private static final String FUNCTION_PRICING_KEY = "pricingTier";
    private static final String FUNCTION_DEPLOY_TO_SLOT_KEY = "isDeployToFunctionSlot";
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    protected String finalName;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(property="functions.pricingTier")
    protected String pricingTier;
    @Parameter(property="functions.skip", defaultValue="false")
    protected Boolean skip;
    @Parameter(property="functions.region")
    protected String region;
    @Parameter(property="functions.runtime")
    protected RuntimeConfiguration runtime;
    @Parameter(property="functions.appInsightsInstance")
    protected String appInsightsInstance;
    @Parameter(property="functions.appInsightsKey")
    protected String appInsightsKey;
    @Parameter(property="functions.disableAppInsights", defaultValue="false")
    protected Boolean disableAppInsights;
    @Parameter(property="functions.enableDistributedTracing")
    protected Boolean enableDistributedTracing;
    @Parameter(property="functions.hostJson", defaultValue="host.json")
    protected String hostJson;
    @Parameter(property="functions.localSettingsJson", defaultValue="local.settings.json")
    protected String localSettingsJson;
    @Parameter(property="functions.artifact")
    protected String artifactPath;
    @JsonProperty
    @Parameter
    protected Integer alwaysReadyInstances;
    @JsonProperty
    @Parameter
    protected Integer instanceSize;
    @JsonProperty
    @Parameter
    protected Integer maximumInstances;
    @JsonProperty
    @Parameter
    protected String storageAccountName;
    @JsonProperty
    @Parameter
    protected String storageAccountResourceGroup;
    @JsonProperty
    @Parameter
    protected String environment;
    @JsonProperty
    @Parameter
    protected Integer minReplicas;
    @JsonProperty
    @Parameter
    protected Integer maxReplicas;
    protected final ConfigParser parser = new ConfigParser(this);

    public String getRegion() {
        return this.region;
    }

    protected boolean isSkipMojo() {
        return BooleanUtils.isTrue((Boolean)this.skip);
    }

    public String getFinalName() {
        return this.finalName;
    }

    public String getAppInsightsInstance() {
        return this.appInsightsInstance;
    }

    public String getAppInsightsKey() {
        return this.appInsightsKey;
    }

    public boolean isDisableAppInsights() {
        return BooleanUtils.isTrue((Boolean)this.disableAppInsights);
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtime;
    }

    @Nonnull
    protected File getArtifact() throws AzureToolkitRuntimeException {
        if (StringUtils.isNotEmpty((CharSequence)this.getArtifactPath())) {
            return new File(this.getArtifactPath());
        }
        Artifact artifact = this.project.getArtifact();
        if (artifact.getFile() != null) {
            return artifact.getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        String packaging = this.project.getPackaging();
        File result = new File(this.buildDirectory, StringUtils.join((Object[])new Serializable[]{finalName, Character.valueOf('.'), packaging}));
        if (!result.exists()) {
            throw new AzureToolkitRuntimeException(CAN_NOT_FIND_ARTIFACT);
        }
        return result;
    }

    protected File getHostJsonFile() {
        Path path = Paths.get(this.getHostJson(), new String[0]);
        return path.isAbsolute() ? path.toFile() : Paths.get(this.project.getBasedir().getAbsolutePath(), this.getHostJson()).toFile();
    }

    protected File getLocalSettingsJsonFile() {
        Path path = Paths.get(this.getLocalSettingsJson(), new String[0]);
        return path.isAbsolute() ? path.toFile() : Paths.get(this.project.getBasedir().getAbsolutePath(), this.getLocalSettingsJson()).toFile();
    }

    protected void validateAppName() {
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            throw new AzureToolkitRuntimeException("<appName> is not configured in pom");
        }
    }

    protected void validateFunctionCompatibility() {
        FunctionExtensionVersion bundleVersion = this.getBundleVersion();
        String functionLibraryVersion = this.getFunctionLibraryVersion();
        Integer functionLibraryMajorVersion = Optional.ofNullable(functionLibraryVersion).map(version -> SemanticVersion.parse((String)version).getMajorVersion()).orElse(null);
        if (bundleVersion == null || bundleVersion == FunctionExtensionVersion.UNKNOWN || functionLibraryMajorVersion == null) {
            return;
        }
        Set<Integer> matchedVersions = FUNCTION_EXTENSION_LIBRARY_MAP.get(bundleVersion);
        if (!matchedVersions.contains(functionLibraryMajorVersion)) {
            String validVersions = matchedVersions.stream().map(value -> String.format("v%s.*", value)).collect(Collectors.joining(","));
            AzureMessager.getMessager().warning("There might be some compatibility issues between azure function extension bundle and azure functions java library");
            AzureMessager.getMessager().warning(AzureString.format((String)"Valid function library versions for extension bundle v%s should be: %s, current value is %s", (Object[])new Object[]{bundleVersion.getValue(), validVersions, functionLibraryVersion}));
        }
    }

    @Nullable
    protected String getFunctionLibraryVersion() {
        Set artifacts = this.project.getArtifacts();
        return artifacts.stream().filter(artifact -> StringUtils.equals((CharSequence)artifact.getArtifactId(), (CharSequence)AZURE_FUNCTIONS_JAVA_LIBRARY)).findFirst().map(Artifact::getVersion).orElse(null);
    }

    @Nullable
    protected JsonNode readHostJson() {
        JsonNode jsonNode;
        File hostJson = this.getHostJsonFile();
        FileInputStream fis = new FileInputStream(hostJson);
        try {
            String content = IOUtils.toString((InputStream)fis, (Charset)Charset.defaultCharset());
            jsonNode = (JsonNode)JsonUtils.fromJson((String)content, JsonNode.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        fis.close();
        return jsonNode;
    }

    @Nullable
    protected FunctionExtensionVersion getBundleVersion() {
        return Optional.ofNullable(this.readHostJson()).map(jsonNode -> jsonNode.at("/extensionBundle/version")).filter(jsonNode -> !jsonNode.isMissingNode()).map(jsonNode -> FunctionUtils.parseFunctionExtensionVersionFromHostJson((String)jsonNode.asText())).orElse(null);
    }

    public Map<String, String> getTelemetryProperties() {
        Map result = super.getTelemetryProperties();
        String javaVersion = this.runtime == null ? null : this.runtime.getJavaVersion();
        String os = this.runtime == null ? null : this.runtime.getOs();
        boolean isDockerFunction = this.runtime != null && StringUtils.isNotEmpty((CharSequence)this.runtime.getImage());
        result.put(FUNCTION_JAVA_VERSION_KEY, StringUtils.isEmpty((CharSequence)javaVersion) ? "" : javaVersion);
        result.put(FUNCTION_RUNTIME_KEY, StringUtils.isEmpty((CharSequence)os) ? "" : os);
        result.put(FUNCTION_IS_DOCKER_KEY, String.valueOf(isDockerFunction));
        result.put(FUNCTION_REGION_KEY, this.region);
        result.put(FUNCTION_PRICING_KEY, this.pricingTier);
        result.put(DISABLE_APP_INSIGHTS_KEY, String.valueOf(this.isDisableAppInsights()));
        boolean isDeployToFunctionSlot = this.getDeploymentSlotSetting() != null && StringUtils.isNotEmpty((CharSequence)this.getDeploymentSlotSetting().getName());
        result.put(FUNCTION_DEPLOY_TO_SLOT_KEY, String.valueOf(isDeployToFunctionSlot));
        return result;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public Boolean getEnableDistributedTracing() {
        return this.enableDistributedTracing;
    }

    public String getHostJson() {
        return this.hostJson;
    }

    public String getLocalSettingsJson() {
        return this.localSettingsJson;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public Integer getAlwaysReadyInstances() {
        return this.alwaysReadyInstances;
    }

    public Integer getInstanceSize() {
        return this.instanceSize;
    }

    public Integer getMaximumInstances() {
        return this.maximumInstances;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getStorageAccountResourceGroup() {
        return this.storageAccountResourceGroup;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public ConfigParser getParser() {
        return this.parser;
    }
}

