/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.ElasticPremiumPricingTier;
import com.microsoft.azure.common.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.function.utils.FunctionUtils;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFunctionMojo
extends AbstractAppServiceMojo {
    private static final String JDK_VERSION_ERROR = "Azure Functions only support JDK 8, which is lower than local JDK version %s.";
    private static final String FUNCTIONS_WORKER_RUNTIME_NAME = "FUNCTIONS_WORKER_RUNTIME";
    private static final String FUNCTIONS_WORKER_RUNTIME_VALUE = "java";
    private static final String SET_FUNCTIONS_WORKER_RUNTIME = "Set function worker runtime to java.";
    private static final String CHANGE_FUNCTIONS_WORKER_RUNTIME = "Function worker runtime doesn't meet the requirement, change it from %s to java.";
    private static final String FUNCTIONS_EXTENSION_VERSION_NAME = "FUNCTIONS_EXTENSION_VERSION";
    private static final String FUNCTIONS_EXTENSION_VERSION_VALUE = "~3";
    private static final String SET_FUNCTIONS_EXTENSION_VERSION = "Functions extension version isn't configured, setting up the default value.";
    @Parameter(property="functions.pricingTier")
    protected String pricingTier;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    protected String finalName;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(property="functions.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="functions.region", defaultValue="westeurope")
    protected String region;
    @Parameter(property="functions.runtime")
    protected RuntimeConfiguration runtime;

    public Map getAppSettingsWithDefaultValue() {
        Map settings = this.getAppSettings();
        this.overrideDefaultAppSetting(settings, FUNCTIONS_WORKER_RUNTIME_NAME, SET_FUNCTIONS_WORKER_RUNTIME, FUNCTIONS_WORKER_RUNTIME_VALUE, CHANGE_FUNCTIONS_WORKER_RUNTIME);
        this.setDefaultAppSetting(settings, FUNCTIONS_EXTENSION_VERSION_NAME, SET_FUNCTIONS_EXTENSION_VERSION, FUNCTIONS_EXTENSION_VERSION_VALUE);
        return settings;
    }

    public FunctionExtensionVersion getFunctionExtensionVersion() throws AzureExecutionException {
        String extensionVersion = (String)this.getAppSettingsWithDefaultValue().get(FUNCTIONS_EXTENSION_VERSION_NAME);
        return FunctionUtils.parseFunctionExtensionVersion((String)extensionVersion);
    }

    private void overrideDefaultAppSetting(Map result, String settingName, String settingIsEmptyMessage, String settingValue, String changeSettingMessage) {
        String setting = (String)result.get(settingName);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            Log.info((String)settingIsEmptyMessage);
        } else if (!setting.equals(settingValue)) {
            Log.warn((String)String.format(changeSettingMessage, setting));
        }
        result.put(settingName, settingValue);
    }

    private void setDefaultAppSetting(Map result, String settingName, String settingIsEmptyMessage, String settingValue) {
        String setting = (String)result.get(settingName);
        if (StringUtils.isEmpty((CharSequence)setting)) {
            Log.info((String)settingIsEmptyMessage);
            result.put(settingName, settingValue);
        }
    }

    public PricingTier getPricingTier() throws AzureExecutionException {
        if (StringUtils.isEmpty((CharSequence)this.pricingTier)) {
            return null;
        }
        ElasticPremiumPricingTier elasticPremiumPricingTier = ElasticPremiumPricingTier.fromString((String)this.pricingTier);
        return elasticPremiumPricingTier != null ? elasticPremiumPricingTier.toPricingTier() : AppServiceUtils.getPricingTierFromString((String)this.pricingTier);
    }

    public String getRegion() {
        return this.region;
    }

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getFinalName() {
        return this.finalName;
    }

    @Nullable
    public FunctionApp getFunctionApp() throws AzureAuthFailureException {
        PagedList functionList = this.getAzureClient().appServices().functionApps().list();
        return (FunctionApp)AppServiceUtils.findAppServiceInPagedList((PagedList)functionList, (String)this.getResourceGroup(), (String)this.getAppName());
    }

    public RuntimeConfiguration getRuntime() {
        return this.runtime;
    }

    public void execute() throws MojoExecutionException {
        this.checkJavaVersion();
        super.execute();
    }

    public void checkJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.8")) {
            Log.warn((String)String.format(JDK_VERSION_ERROR, javaVersion));
        }
    }
}

