/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.common.Utils;
import com.microsoft.azure.common.appservice.DeployTargetType;
import com.microsoft.azure.common.appservice.DeploymentType;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.function.handlers.artifact.DockerArtifactHandler;
import com.microsoft.azure.common.function.handlers.artifact.MSDeployArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.artifact.RunFromBlobArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.artifact.RunFromZipArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.runtime.DockerFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.LinuxFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.WindowsFunctionRuntimeHandler;
import com.microsoft.azure.common.handlers.ArtifactHandler;
import com.microsoft.azure.common.handlers.artifact.FTPArtifactHandlerImpl;
import com.microsoft.azure.common.handlers.artifact.ZIPArtifactHandlerImpl;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.ProjectUtils;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    public static final JavaVersion DEFAULT_JAVA_VERSION = JavaVersion.JAVA_8_NEWEST;
    public static final String VALID_JAVA_VERSION_PATTERN = "^1\\.8.*";
    public static final String DEPLOY_START = "Trying to deploy the function app...";
    public static final String DEPLOY_FINISH = "Successfully deployed the function app at https://%s.azurewebsites.net.";
    public static final String FUNCTION_APP_CREATE_START = "The specified function app does not exist. Creating a new function app...";
    public static final String FUNCTION_APP_CREATED = "Successfully created the function app: %s.";
    public static final String FUNCTION_APP_UPDATE = "Updating the specified function app...";
    public static final String FUNCTION_APP_UPDATE_DONE = "Successfully updated the function app: %s.";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    public static final String HOST_JAVA_VERSION = "Java version of function host : %s";
    public static final String HOST_JAVA_VERSION_OFF = "Java version of function host is not initiated, set it to Java 8.";
    public static final String HOST_JAVA_VERSION_INCORRECT = "Java version of function host %s does not meet the requirement of Azure Functions, set it to Java 8.";
    public static final String UNKNOWN_DEPLOYMENT_TYPE = "The value of <deploymentType> is unknown, supported values are: ftp, zip, msdeploy, run_from_blob and run_from_zip.";

    protected void doExecute() throws AzureExecutionException {
        try {
            this.createOrUpdateFunctionApp();
            FunctionApp app = this.getFunctionApp();
            if (app == null) {
                throw new AzureExecutionException(String.format("Failed to get the function app with name: %s", this.getAppName()));
            }
            DeployTarget deployTarget = new DeployTarget((WebAppBase)app, DeployTargetType.FUNCTION);
            Log.info((String)DEPLOY_START);
            this.getArtifactHandler().publish(deployTarget);
            Log.info((String)String.format(DEPLOY_FINISH, this.getAppName()));
        }
        catch (AzureAuthFailureException e) {
            throw new AzureExecutionException("Cannot auth to azure", (Throwable)e);
        }
    }

    protected void createOrUpdateFunctionApp() throws AzureAuthFailureException, AzureExecutionException {
        FunctionApp app = this.getFunctionApp();
        if (app == null) {
            this.createFunctionApp();
        } else {
            this.updateFunctionApp(app);
        }
    }

    protected void createFunctionApp() throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_APP_CREATE_START);
        FunctionRuntimeHandler runtimeHandler = this.getFunctionRuntimeHandler();
        FunctionApp.DefinitionStages.WithCreate withCreate = runtimeHandler.defineAppWithRuntime();
        this.configureAppSettings(arg_0 -> ((FunctionApp.DefinitionStages.WithCreate)withCreate).withAppSettings(arg_0), this.getAppSettingsWithDefaultValue());
        withCreate.withJavaVersion(DEFAULT_JAVA_VERSION).withWebContainer(null).create();
        Log.info((String)String.format(FUNCTION_APP_CREATED, this.getAppName()));
    }

    protected void updateFunctionApp(FunctionApp app) throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_APP_UPDATE);
        ((SiteInner)app.inner()).withTags(null);
        FunctionRuntimeHandler runtimeHandler = this.getFunctionRuntimeHandler();
        runtimeHandler.updateAppServicePlan((WebAppBase)app);
        FunctionApp.Update update = runtimeHandler.updateAppRuntime(app);
        this.checkHostJavaVersion(app, update);
        this.configureAppSettings(arg_0 -> ((FunctionApp.Update)update).withAppSettings(arg_0), this.getAppSettingsWithDefaultValue());
        update.apply();
        Log.info((String)String.format(FUNCTION_APP_UPDATE_DONE, this.getAppName()));
    }

    protected void checkHostJavaVersion(FunctionApp app, FunctionApp.Update update) {
        JavaVersion serverJavaVersion = app.javaVersion();
        if (serverJavaVersion.toString().matches(VALID_JAVA_VERSION_PATTERN)) {
            Log.info((String)String.format(HOST_JAVA_VERSION, serverJavaVersion));
        } else if (serverJavaVersion.equals((Object)JavaVersion.OFF)) {
            Log.info((String)HOST_JAVA_VERSION_OFF);
            update.withJavaVersion(DEFAULT_JAVA_VERSION);
        } else {
            Log.warn((String)HOST_JAVA_VERSION_INCORRECT);
            update.withJavaVersion(DEFAULT_JAVA_VERSION);
        }
    }

    protected void configureAppSettings(Consumer<Map> withAppSettings, Map appSettings) {
        if (appSettings != null && !appSettings.isEmpty()) {
            withAppSettings.accept(appSettings);
        }
    }

    protected FunctionRuntimeHandler getFunctionRuntimeHandler() throws AzureAuthFailureException, AzureExecutionException {
        WindowsFunctionRuntimeHandler.Builder builder;
        OperatingSystemEnum os = this.getOsEnum();
        switch (os) {
            case Windows: {
                builder = new WindowsFunctionRuntimeHandler.Builder();
                break;
            }
            case Linux: {
                builder = new LinuxFunctionRuntimeHandler.Builder();
                break;
            }
            case Docker: {
                RuntimeConfiguration runtime = this.getRuntime();
                builder = (FunctionRuntimeHandler.Builder)((DockerFunctionRuntimeHandler.Builder)((DockerFunctionRuntimeHandler.Builder)new DockerFunctionRuntimeHandler.Builder().image(runtime.getImage())).dockerCredentialProvider((IDockerCredentialProvider)MavenDockerCredentialProvider.fromMavenSettings((Settings)this.getSettings(), (String)runtime.getServerId()))).registryUrl(runtime.getRegistryUrl());
                break;
            }
            default: {
                throw new AzureExecutionException(String.format("Unsupported runtime %s", os));
            }
        }
        return ((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)builder.appName(this.getAppName())).resourceGroup(this.getResourceGroup())).runtime(this.getRuntime()).region(Region.fromName((String)this.region))).pricingTier(this.getPricingTier())).servicePlanName(this.getAppServicePlanName())).servicePlanResourceGroup(this.getAppServicePlanResourceGroup())).functionExtensionVersion(this.getFunctionExtensionVersion()).azure(this.getAzureClient())).build();
    }

    protected OperatingSystemEnum getOsEnum() throws AzureExecutionException {
        String os = this.runtime == null ? null : this.runtime.getOs();
        return StringUtils.isEmpty((CharSequence)os) ? RuntimeConfiguration.DEFAULT_OS : Utils.parseOperationSystem((String)os);
    }

    protected ArtifactHandler getArtifactHandler() throws AzureExecutionException {
        FTPArtifactHandlerImpl.Builder builder;
        DeploymentType deploymentType = this.getDeploymentType();
        switch (deploymentType) {
            case MSDEPLOY: {
                builder = new MSDeployArtifactHandlerImpl.Builder().functionAppName(this.getAppName());
                break;
            }
            case FTP: {
                builder = new FTPArtifactHandlerImpl.Builder();
                break;
            }
            case ZIP: {
                builder = new ZIPArtifactHandlerImpl.Builder();
                break;
            }
            case RUN_FROM_BLOB: {
                builder = new RunFromBlobArtifactHandlerImpl.Builder();
                break;
            }
            case DOCKER: {
                builder = new DockerArtifactHandler.Builder();
                break;
            }
            case EMPTY: 
            case RUN_FROM_ZIP: {
                builder = new RunFromZipArtifactHandlerImpl.Builder();
                break;
            }
            default: {
                throw new AzureExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
            }
        }
        return builder.project(ProjectUtils.convertCommonProject((MavenProject)this.getProject())).stagingDirectoryPath(this.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.getBuildDirectoryAbsolutePath()).build();
    }

    public DeploymentType getDeploymentType() throws AzureExecutionException {
        DeploymentType deploymentType = super.getDeploymentType();
        return deploymentType == DeploymentType.EMPTY ? this.getDeploymentTypeByRuntime() : deploymentType;
    }

    public DeploymentType getDeploymentTypeByRuntime() throws AzureExecutionException {
        OperatingSystemEnum operatingSystemEnum = this.getOsEnum();
        switch (operatingSystemEnum) {
            case Docker: {
                return DeploymentType.DOCKER;
            }
            case Linux: {
                return this.isDedicatedPricingTier() ? DeploymentType.RUN_FROM_ZIP : DeploymentType.RUN_FROM_BLOB;
            }
        }
        return DeploymentType.RUN_FROM_ZIP;
    }

    protected boolean isDedicatedPricingTier() {
        return AppServiceUtils.getPricingTierFromString((String)this.pricingTier) != null;
    }

    public Map<String, String> getTelemetryProperties() {
        Map map = super.getTelemetryProperties();
        try {
            map.put(DEPLOYMENT_TYPE_KEY, this.getDeploymentType().toString());
        }
        catch (AzureExecutionException e) {
            map.put(DEPLOYMENT_TYPE_KEY, "Unknown deployment type.");
        }
        return map;
    }
}

