/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonObject;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.bindings.BindingEnum;
import com.microsoft.azure.common.function.configurations.FunctionConfiguration;
import com.microsoft.azure.common.function.handlers.AnnotationHandler;
import com.microsoft.azure.common.function.handlers.AnnotationHandlerImpl;
import com.microsoft.azure.common.function.handlers.CommandHandler;
import com.microsoft.azure.common.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.common.function.handlers.FunctionCoreToolsHandler;
import com.microsoft.azure.common.function.handlers.FunctionCoreToolsHandlerImpl;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PackageMojo
extends AbstractFunctionMojo {
    public static final String SEARCH_FUNCTIONS = "Step 1 of 7: Searching for Azure Functions entry points";
    public static final String FOUND_FUNCTIONS = " Azure Functions entry point(s) found.";
    public static final String NO_FUNCTIONS = "Azure Functions entry point not found, plugin will exit.";
    public static final String GENERATE_CONFIG = "Step 2 of 7: Generating Azure Functions configurations";
    public static final String GENERATE_SKIP = "No Azure Functions found. Skip configuration generation.";
    public static final String GENERATE_DONE = "Generation done.";
    public static final String VALIDATE_CONFIG = "Step 3 of 7: Validating generated configurations";
    public static final String VALIDATE_SKIP = "No configurations found. Skip validation.";
    public static final String VALIDATE_DONE = "Validation done.";
    public static final String SAVE_HOST_JSON = "Step 4 of 7: Saving host.json";
    public static final String SAVE_FUNCTION_JSONS = "Step 5 of 7: Saving configurations to function.json";
    public static final String SAVE_SKIP = "No configurations found. Skip save.";
    public static final String SAVE_FUNCTION_JSON = "Starting processing function: ";
    public static final String SAVE_SUCCESS = "Successfully saved to ";
    public static final String COPY_JARS = "Step 6 of 7: Copying JARs to staging directory";
    public static final String COPY_SUCCESS = "Copied successfully.";
    public static final String INSTALL_EXTENSIONS = "Step 7 of 7: Installing function extensions if needed";
    public static final String SKIP_INSTALL_EXTENSIONS_HTTP = "Skip install Function extension for HTTP Trigger Functions";
    public static final String INSTALL_EXTENSIONS_FINISH = "Function extension installation done.";
    public static final String BUILD_SUCCESS = "Successfully built Azure Functions.";
    public static final String FUNCTION_JSON = "function.json";
    public static final String HOST_JSON = "host.json";
    public static final String EXTENSION_BUNDLE = "extensionBundle";
    private static final BindingEnum[] FUNCTION_WITHOUT_FUNCTION_EXTENSION = new BindingEnum[]{BindingEnum.HttpOutput, BindingEnum.HttpTrigger};
    public static final String EXTENSION_BUNDLE_ID = "Microsoft.Azure.Functions.ExtensionBundle";
    public static final String SKIP_INSTALL_EXTENSIONS_BUNDLE = "Extension bundle specified, skip install extension";

    protected void doExecute() throws AzureExecutionException {
        AnnotationHandler annotationHandler = this.getAnnotationHandler();
        Set<Method> methods = null;
        try {
            methods = this.findAnnotatedMethods(annotationHandler);
        }
        catch (MalformedURLException e) {
            throw new AzureExecutionException("Invalid URL when resolving class path:" + e.getMessage(), (Throwable)e);
        }
        if (methods.size() == 0) {
            Log.info((String)NO_FUNCTIONS);
            return;
        }
        Map<String, FunctionConfiguration> configMap = this.getFunctionConfigurations(annotationHandler, methods);
        this.validateFunctionConfigurations(configMap);
        ObjectWriter objectWriter = this.getObjectWriter();
        try {
            this.copyHostJsonFile(objectWriter);
            this.writeFunctionJsonFiles(objectWriter, configMap);
            this.copyJarsToStageDirectory();
        }
        catch (IOException e) {
            throw new AzureExecutionException("Canot perform IO operations due to error:" + e.getMessage(), (Throwable)e);
        }
        CommandHandlerImpl commandHandler = new CommandHandlerImpl();
        FunctionCoreToolsHandler functionCoreToolsHandler = this.getFunctionCoreToolsHandler((CommandHandler)commandHandler);
        Set<BindingEnum> bindingClasses = this.getFunctionBindingEnums(configMap);
        this.installExtension(functionCoreToolsHandler, bindingClasses);
        Log.info((String)BUILD_SUCCESS);
    }

    protected AnnotationHandler getAnnotationHandler() {
        return new AnnotationHandlerImpl();
    }

    protected Set<Method> findAnnotatedMethods(AnnotationHandler handler) throws AzureExecutionException, MalformedURLException {
        Set functions;
        Log.info((String)"");
        Log.info((String)SEARCH_FUNCTIONS);
        try {
            Log.debug((String)("ClassPath to resolve: " + this.getTargetClassUrl()));
            List<URL> dependencyWithTargetClass = this.getDependencyArtifactUrls();
            dependencyWithTargetClass.add(this.getTargetClassUrl());
            functions = handler.findFunctions(dependencyWithTargetClass);
        }
        catch (NoClassDefFoundError e) {
            Log.debug((String)("ClassPath to resolve: " + this.getArtifactUrl()));
            functions = handler.findFunctions(Arrays.asList(this.getArtifactUrl()));
        }
        Log.info((String)(functions.size() + FOUND_FUNCTIONS));
        return functions;
    }

    protected URL getArtifactUrl() throws MalformedURLException {
        return this.getProject().getArtifact().getFile().toURI().toURL();
    }

    protected URL getTargetClassUrl() throws MalformedURLException {
        return this.outputDirectory.toURI().toURL();
    }

    protected List<URL> getDependencyArtifactUrls() {
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList compileClasspathElements = new ArrayList();
        try {
            compileClasspathElements.addAll(this.getProject().getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            Log.debug((String)("Failed to resolve dependencies for compile scope, exception: " + e.getMessage()));
        }
        for (String element : compileClasspathElements) {
            File f = new File(element);
            try {
                urlList.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                Log.debug((String)("Failed to get URL for file: " + f.toString()));
            }
        }
        return urlList;
    }

    protected Map<String, FunctionConfiguration> getFunctionConfigurations(AnnotationHandler handler, Set<Method> methods) throws AzureExecutionException {
        Log.info((String)"");
        Log.info((String)GENERATE_CONFIG);
        Map configMap = handler.generateConfigurations(methods);
        if (configMap.size() == 0) {
            Log.info((String)GENERATE_SKIP);
        } else {
            String scriptFilePath = this.getScriptFilePath();
            configMap.values().forEach(config -> config.setScriptFile(scriptFilePath));
            Log.info((String)GENERATE_DONE);
        }
        return configMap;
    }

    protected String getScriptFilePath() {
        return ".." + "/" + this.getFinalName() + ".jar";
    }

    protected void validateFunctionConfigurations(Map<String, FunctionConfiguration> configMap) {
        Log.info((String)"");
        Log.info((String)VALIDATE_CONFIG);
        if (configMap.size() == 0) {
            Log.info((String)VALIDATE_SKIP);
        } else {
            configMap.values().forEach(config -> config.validate());
            Log.info((String)VALIDATE_DONE);
        }
    }

    protected void writeFunctionJsonFiles(ObjectWriter objectWriter, Map<String, FunctionConfiguration> configMap) throws IOException {
        Log.info((String)"");
        Log.info((String)SAVE_FUNCTION_JSONS);
        if (configMap.size() == 0) {
            Log.info((String)SAVE_SKIP);
        } else {
            for (Map.Entry<String, FunctionConfiguration> config : configMap.entrySet()) {
                this.writeFunctionJsonFile(objectWriter, config.getKey(), config.getValue());
            }
        }
    }

    protected void writeFunctionJsonFile(ObjectWriter objectWriter, String functionName, FunctionConfiguration config) throws IOException {
        Log.info((String)(SAVE_FUNCTION_JSON + functionName));
        File functionJsonFile = Paths.get(this.getDeploymentStagingDirectoryPath(), functionName, FUNCTION_JSON).toFile();
        this.writeObjectToFile(objectWriter, config, functionJsonFile);
        Log.info((String)(SAVE_SUCCESS + functionJsonFile.getAbsolutePath()));
    }

    protected void copyHostJsonFile(ObjectWriter objectWriter) throws IOException {
        Log.info((String)"");
        Log.info((String)SAVE_HOST_JSON);
        File sourceFile = new File(this.project.getBasedir(), HOST_JSON);
        File targetFile = Paths.get(this.getDeploymentStagingDirectoryPath(), HOST_JSON).toFile();
        if (sourceFile.exists()) {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        } else {
            this.writeObjectToFile(objectWriter, new Object(), targetFile);
        }
        Log.info((String)(SAVE_SUCCESS + targetFile.getAbsolutePath()));
    }

    protected void writeObjectToFile(ObjectWriter objectWriter, Object object, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        objectWriter.writeValue(targetFile, object);
    }

    protected ObjectWriter getObjectWriter() {
        DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n");
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).writer((PrettyPrinter)prettyPrinter);
    }

    protected void copyJarsToStageDirectory() throws IOException {
        String stagingDirectory = this.getDeploymentStagingDirectoryPath();
        Log.info((String)"");
        Log.info((String)(COPY_JARS + stagingDirectory));
        PackageMojo.copyResources(this.getProject(), this.getSession(), this.getMavenResourcesFiltering(), this.getResources(), stagingDirectory);
        Log.info((String)COPY_SUCCESS);
    }

    public List<Resource> getResources() {
        Resource resource = new Resource();
        resource.setDirectory(this.getBuildDirectoryAbsolutePath());
        resource.setTargetPath("/");
        resource.setFiltering(false);
        resource.setIncludes(Arrays.asList("*.jar"));
        return Arrays.asList(resource);
    }

    protected FunctionCoreToolsHandler getFunctionCoreToolsHandler(CommandHandler commandHandler) {
        return new FunctionCoreToolsHandlerImpl(commandHandler);
    }

    protected void installExtension(FunctionCoreToolsHandler handler, Set<BindingEnum> bindingEnums) throws AzureExecutionException {
        Log.info((String)INSTALL_EXTENSIONS);
        if (!this.isInstallingExtensionNeeded(bindingEnums)) {
            return;
        }
        handler.installExtension(new File(this.getDeploymentStagingDirectoryPath()), this.project.getBasedir());
        Log.info((String)INSTALL_EXTENSIONS_FINISH);
    }

    protected Set<BindingEnum> getFunctionBindingEnums(Map<String, FunctionConfiguration> configMap) {
        HashSet<BindingEnum> result = new HashSet<BindingEnum>();
        configMap.values().forEach(configuration -> configuration.getBindings().forEach(binding -> result.add(binding.getBindingEnum())));
        return result;
    }

    protected boolean isInstallingExtensionNeeded(Set<BindingEnum> bindingTypes) {
        JsonObject extensionBundle;
        JsonObject hostJson = this.readHostJson();
        JsonObject jsonObject = extensionBundle = hostJson == null ? null : hostJson.getAsJsonObject(EXTENSION_BUNDLE);
        if (extensionBundle != null && extensionBundle.has("id") && StringUtils.equalsIgnoreCase((CharSequence)extensionBundle.get("id").getAsString(), (CharSequence)EXTENSION_BUNDLE_ID)) {
            Log.info((String)SKIP_INSTALL_EXTENSIONS_BUNDLE);
            return false;
        }
        boolean isNonHttpTriggersExist = bindingTypes.stream().anyMatch(binding -> !Arrays.asList(FUNCTION_WITHOUT_FUNCTION_EXTENSION).contains(binding));
        if (!isNonHttpTriggersExist) {
            Log.info((String)SKIP_INSTALL_EXTENSIONS_HTTP);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    protected JsonObject readHostJson() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void copyResources(MavenProject project, MavenSession session, MavenResourcesFiltering filtering, List<Resource> resources, String targetDirectory) throws IOException {
        for (Resource resource : resources) {
            String targetPath = resource.getTargetPath() == null ? "" : resource.getTargetPath();
            resource.setTargetPath(Paths.get(targetDirectory, targetPath).toString());
            resource.setFiltering(false);
        }
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, new File(targetDirectory), project, "UTF-8", null, Collections.EMPTY_LIST, session);
        mavenResourcesExecution.setEscapeWindowsPaths(true);
        mavenResourcesExecution.setInjectProjectBuildFilters(false);
        mavenResourcesExecution.setOverwrite(true);
        mavenResourcesExecution.setIncludeEmptyDirs(false);
        mavenResourcesExecution.setSupportMultiLineFiltering(false);
        try {
            filtering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException ex) {
            throw new IOException("Failed to copy resources", ex);
        }
    }
}

