/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.auth.AzureTokenWrapper;
import com.microsoft.azure.common.Utils;
import com.microsoft.azure.common.applicationinsights.ApplicationInsightsManager;
import com.microsoft.azure.common.appservice.DeployTargetType;
import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.appservice.DeploymentType;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.docker.IDockerCredentialProvider;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.common.function.handlers.artifact.DockerArtifactHandler;
import com.microsoft.azure.common.function.handlers.artifact.MSDeployArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.artifact.RunFromBlobArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.artifact.RunFromZipArtifactHandlerImpl;
import com.microsoft.azure.common.function.handlers.runtime.DockerFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.FunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.LinuxFunctionRuntimeHandler;
import com.microsoft.azure.common.function.handlers.runtime.WindowsFunctionRuntimeHandler;
import com.microsoft.azure.common.function.model.FunctionResource;
import com.microsoft.azure.common.function.utils.FunctionUtils;
import com.microsoft.azure.common.handlers.ArtifactHandler;
import com.microsoft.azure.common.handlers.artifact.FTPArtifactHandlerImpl;
import com.microsoft.azure.common.handlers.artifact.ZIPArtifactHandlerImpl;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.functions.annotation.AuthorizationLevel;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponent;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlot;
import com.microsoft.azure.management.appservice.FunctionEnvelope;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.ProjectUtils;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY)
public class DeployMojo
extends AbstractFunctionMojo {
    private static final int LIST_TRIGGERS_MAX_RETRY = 3;
    private static final int LIST_TRIGGERS_RETRY_PERIOD_IN_SECONDS = 10;
    private static final String DEPLOY_START = "Starting deployment...";
    private static final String DEPLOY_FINISH = "Deployment done, you may access your resource through %s";
    private static final String FUNCTION_APP_CREATE_START = "The specified function app does not exist. Creating a new function app...";
    private static final String FUNCTION_APP_CREATED = "Successfully created the function app: %s.";
    private static final String FUNCTION_SLOT_CREATE_START = "The specified function slot does not exist. Creating a new slot...";
    private static final String FUNCTION_SLOT_CREATED = "Successfully created the function slot: %s.";
    private static final String FUNCTION_APP_UPDATE = "Updating the specified function app...";
    private static final String FUNCTION_APP_UPDATE_DONE = "Successfully updated the function app: %s.";
    private static final String FUNCTION_SLOT_UPDATE = "Updating the specified function slot...";
    private static final String FUNCTION_SLOT_UPDATE_DONE = "Successfully updated the function slot: %s.";
    private static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    private static final String UNKNOWN_DEPLOYMENT_TYPE = "The value of <deploymentType> is unknown, supported values are: ftp, zip, msdeploy, run_from_blob and run_from_zip.";
    private static final String APPINSIGHTS_INSTRUMENTATION_KEY = "APPINSIGHTS_INSTRUMENTATIONKEY";
    private static final String APPLICATION_INSIGHTS_NOT_SUPPORTED = "Application Insights features are not supported with current authentication, skip related steps.";
    private static final String APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT = "Contradictory configurations for application insights, specify 'appInsightsKey' or 'appInsightsInstance' if you want to enable it, and specify 'disableAppInsights=true' if you want to disable it.";
    private static final String FAILED_TO_GET_APPLICATION_INSIGHTS = "The application insights %s cannot be found, will create it in resource group %s.";
    private static final String SKIP_CREATING_APPLICATION_INSIGHTS = "Skip creating application insights";
    private static final String APPLICATION_INSIGHTS_CREATE_START = "Creating application insights...";
    private static final String APPLICATION_INSIGHTS_CREATED = "Successfully created the application insights %s for this Function App. You can visit https://portal.azure.com/#resource%s/overview to view your Application Insights component.";
    private static final String APPLICATION_INSIGHTS_CREATE_FAILED = "Unable to create the Application Insights for the Function App due to error %s. Please use the Azure Portal to manually create and configure the Application Insights if needed.";
    private static final String INSTRUMENTATION_KEY_IS_NOT_VALID = "Instrumentation key is not valid, please update the application insights configuration";
    private static final String FAILED_TO_GET_FUNCTION_APP_PRICING_TIER = "Failed to get function app pricing tier";
    private static final String FAILED_TO_LIST_TRIGGERS = "Deployment succeeded, but failed to list http trigger urls.";
    private static final String UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS = "Some http trigger urls cannot be displayed because they are non-anonymous. To access the non-anonymous triggers, please refer https://aka.ms/azure-functions-key.";
    private static final String HTTP_TRIGGER_URLS = "HTTP Trigger Urls:";
    private static final String NO_ANONYMOUS_HTTP_TRIGGER = "No anonymous HTTP Triggers found in deployed function app, skip list triggers.";
    private static final String AUTH_LEVEL = "authLevel";
    private static final String HTTP_TRIGGER = "httpTrigger";
    private static final String NO_TRIGGERS_FOUNDED = "No triggers found in deployed function app, please try recompile the project by `mvn clean package` and deploy again.";
    private static final String SYNCING_TRIGGERS_AND_FETCH_FUNCTION_INFORMATION = "Syncing triggers and fetching function information (Attempt %d/%d)...";
    private static final String ARTIFACT_INCOMPATIBLE = "Your function app artifact compile version is higher than the java version in function host, please downgrade the project compile version and try again.";
    private static final String FUNCTION_APP_NOT_EXISTS = "Cannot find the Function App '%s' when creating deployment slot.";
    private JavaVersion parsedJavaVersion;

    public DeploymentType getDeploymentType() throws AzureExecutionException {
        DeploymentType deploymentType = super.getDeploymentType();
        return deploymentType == DeploymentType.EMPTY ? this.getDeploymentTypeByRuntime() : deploymentType;
    }

    protected void doExecute() throws AzureExecutionException {
        try {
            this.parseConfiguration();
            this.checkArtifactCompileVersion();
            WebAppBase target = this.createOrUpdateResource();
            if (target == null) {
                throw new AzureExecutionException(String.format("Failed to get the deploy target with name: %s", this.getAppName()));
            }
            DeployTarget deployTarget = new DeployTarget(target, DeployTargetType.FUNCTION);
            Log.info((String)DEPLOY_START);
            this.getArtifactHandler().publish(deployTarget);
            Log.info((String)String.format(DEPLOY_FINISH, this.getResourcePortalUrl(target)));
            if (!this.isDeployToSlot()) {
                this.listHTTPTriggerUrls();
            }
        }
        catch (AzureAuthFailureException e) {
            throw new AzureExecutionException("Cannot auth to azure", (Throwable)e);
        }
    }

    protected WebAppBase createOrUpdateResource() throws AzureExecutionException, AzureAuthFailureException {
        FunctionApp app = this.getFunctionApp();
        FunctionRuntimeHandler runtimeHandler = this.getFunctionRuntimeHandler();
        if (this.isDeployToSlot()) {
            if (app == null) {
                throw new AzureExecutionException(String.format(FUNCTION_APP_NOT_EXISTS, this.getAppName()));
            }
            FunctionDeploymentSlot deploymentSlot = FunctionUtils.getFunctionDeploymentSlotByName((FunctionApp)app, (String)this.getDeploymentSlotSetting().getName());
            return deploymentSlot == null ? this.createDeploymentSlot(app, runtimeHandler) : this.updateDeploymentSlot(deploymentSlot, runtimeHandler);
        }
        return app == null ? this.createFunctionApp(runtimeHandler) : this.updateFunctionApp(app, runtimeHandler);
    }

    protected FunctionApp createFunctionApp(FunctionRuntimeHandler runtimeHandler) throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_APP_CREATE_START);
        this.validateApplicationInsightsConfiguration();
        Map appSettings = this.getAppSettingsWithDefaultValue();
        this.bindApplicationInsights(appSettings, true);
        FunctionApp.DefinitionStages.WithCreate withCreate = runtimeHandler.defineAppWithRuntime();
        FunctionApp result = (FunctionApp)withCreate.withAppSettings(appSettings).create();
        Log.info((String)String.format(FUNCTION_APP_CREATED, this.getAppName()));
        return result;
    }

    protected FunctionApp updateFunctionApp(FunctionApp app, FunctionRuntimeHandler runtimeHandler) throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_APP_UPDATE);
        runtimeHandler.updateAppServicePlan((WebAppBase)app);
        FunctionApp.Update update = runtimeHandler.updateAppRuntime(app);
        this.updateFunctionAppSettings((WebAppBase.Update)update);
        FunctionApp result = (FunctionApp)update.apply();
        Log.info((String)String.format(FUNCTION_APP_UPDATE_DONE, this.getAppName()));
        return result;
    }

    protected FunctionDeploymentSlot createDeploymentSlot(FunctionApp functionApp, FunctionRuntimeHandler runtimeHandler) throws AzureExecutionException, AzureAuthFailureException {
        Log.info((String)FUNCTION_SLOT_CREATE_START);
        DeploymentSlotSetting slotSetting = this.getDeploymentSlotSetting();
        FunctionDeploymentSlot.DefinitionStages.WithCreate withCreate = runtimeHandler.createDeploymentSlot(functionApp, slotSetting);
        FunctionDeploymentSlot result = (FunctionDeploymentSlot)withCreate.create();
        Log.info((String)String.format(FUNCTION_SLOT_CREATED, result.name()));
        return this.updateDeploymentSlot((FunctionDeploymentSlot)withCreate.create(), runtimeHandler);
    }

    protected FunctionDeploymentSlot updateDeploymentSlot(FunctionDeploymentSlot deploymentSlot, FunctionRuntimeHandler runtimeHandler) throws AzureAuthFailureException, AzureExecutionException {
        Log.info((String)FUNCTION_SLOT_UPDATE);
        WebAppBase.Update update = runtimeHandler.updateDeploymentSlot(deploymentSlot);
        this.updateFunctionAppSettings(update);
        FunctionDeploymentSlot result = (FunctionDeploymentSlot)update.apply();
        Log.info((String)String.format(FUNCTION_SLOT_UPDATE_DONE, result.name()));
        return result;
    }

    protected void listHTTPTriggerUrls() {
        try {
            List<FunctionResource> triggers = this.listFunctions();
            List httpFunction = triggers.stream().filter(function -> function.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)function.getTrigger().getType(), (CharSequence)HTTP_TRIGGER)).collect(Collectors.toList());
            List<FunctionResource> anonymousTriggers = httpFunction.stream().filter(bindingResource -> bindingResource.getTrigger() != null && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)bindingResource.getTrigger().getProperty(AUTH_LEVEL)), (CharSequence)AuthorizationLevel.ANONYMOUS.toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(httpFunction) || CollectionUtils.isEmpty(anonymousTriggers)) {
                Log.info((String)NO_ANONYMOUS_HTTP_TRIGGER);
                return;
            }
            Log.info((String)HTTP_TRIGGER_URLS);
            anonymousTriggers.forEach(trigger -> Log.info((String)String.format("\t %s : %s", trigger.getName(), trigger.getTriggerUrl())));
            if (anonymousTriggers.size() < httpFunction.size()) {
                Log.info((String)UNABLE_TO_LIST_NONE_ANONYMOUS_HTTP_TRIGGERS);
            }
        }
        catch (AzureAuthFailureException | InterruptedException e) {
            Log.warn((String)FAILED_TO_LIST_TRIGGERS);
        }
        catch (AzureExecutionException e) {
            Log.warn((String)e.getMessage());
        }
    }

    protected FunctionRuntimeHandler getFunctionRuntimeHandler() throws AzureAuthFailureException, AzureExecutionException {
        WindowsFunctionRuntimeHandler.Builder builder;
        OperatingSystemEnum os = this.getOsEnum();
        switch (os) {
            case Windows: {
                builder = new WindowsFunctionRuntimeHandler.Builder();
                break;
            }
            case Linux: {
                builder = new LinuxFunctionRuntimeHandler.Builder();
                break;
            }
            case Docker: {
                RuntimeConfiguration runtime = this.getRuntime();
                builder = (FunctionRuntimeHandler.Builder)((DockerFunctionRuntimeHandler.Builder)((DockerFunctionRuntimeHandler.Builder)new DockerFunctionRuntimeHandler.Builder().image(runtime.getImage())).dockerCredentialProvider((IDockerCredentialProvider)MavenDockerCredentialProvider.fromMavenSettings((Settings)this.getSettings(), (String)runtime.getServerId()))).registryUrl(runtime.getRegistryUrl());
                break;
            }
            default: {
                throw new AzureExecutionException(String.format("Unsupported runtime %s", os));
            }
        }
        return ((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)((FunctionRuntimeHandler.Builder)builder.appName(this.getAppName())).resourceGroup(this.getResourceGroup())).runtime(this.getRuntime()).region(Region.fromName((String)this.region))).pricingTier(this.getPricingTier())).servicePlanName(this.getAppServicePlanName())).servicePlanResourceGroup(this.getAppServicePlanResourceGroup())).functionExtensionVersion(this.getFunctionExtensionVersion()).javaVersion(this.parsedJavaVersion).azure(this.getAzureClient())).build();
    }

    protected OperatingSystemEnum getOsEnum() throws AzureExecutionException {
        String os = this.runtime == null ? null : this.runtime.getOs();
        return StringUtils.isEmpty((CharSequence)os) ? RuntimeConfiguration.DEFAULT_OS : Utils.parseOperationSystem((String)os);
    }

    protected ArtifactHandler getArtifactHandler() throws AzureExecutionException {
        FTPArtifactHandlerImpl.Builder builder;
        DeploymentType deploymentType = this.getDeploymentType();
        this.getTelemetryProxy().addDefaultProperty(DEPLOYMENT_TYPE_KEY, deploymentType.toString());
        switch (deploymentType) {
            case MSDEPLOY: {
                builder = new MSDeployArtifactHandlerImpl.Builder().functionAppName(this.getAppName());
                break;
            }
            case FTP: {
                builder = new FTPArtifactHandlerImpl.Builder();
                break;
            }
            case ZIP: {
                builder = new ZIPArtifactHandlerImpl.Builder();
                break;
            }
            case RUN_FROM_BLOB: {
                builder = new RunFromBlobArtifactHandlerImpl.Builder();
                break;
            }
            case DOCKER: {
                builder = new DockerArtifactHandler.Builder();
                break;
            }
            case EMPTY: 
            case RUN_FROM_ZIP: {
                builder = new RunFromZipArtifactHandlerImpl.Builder();
                break;
            }
            default: {
                throw new AzureExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
            }
        }
        return builder.project(ProjectUtils.convertCommonProject((MavenProject)this.getProject())).stagingDirectoryPath(this.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.getBuildDirectoryAbsolutePath()).build();
    }

    protected DeploymentType getDeploymentTypeByRuntime() throws AzureExecutionException {
        OperatingSystemEnum operatingSystemEnum = this.getOsEnum();
        switch (operatingSystemEnum) {
            case Docker: {
                return DeploymentType.DOCKER;
            }
            case Linux: {
                return this.isDedicatedPricingTier() ? DeploymentType.RUN_FROM_ZIP : DeploymentType.RUN_FROM_BLOB;
            }
        }
        return DeploymentType.RUN_FROM_ZIP;
    }

    protected boolean isDedicatedPricingTier() throws AzureExecutionException {
        try {
            FunctionApp functionApp = this.getFunctionApp();
            AppServicePlan appServicePlan = AppServiceUtils.getAppServicePlanByAppService((WebAppBase)functionApp);
            PricingTier functionPricingTier = appServicePlan.pricingTier();
            return PricingTier.getAll().stream().anyMatch(pricingTier -> pricingTier.equals((Object)functionPricingTier));
        }
        catch (AzureAuthFailureException e) {
            throw new AzureExecutionException(FAILED_TO_GET_FUNCTION_APP_PRICING_TIER, (Throwable)e);
        }
    }

    protected void checkArtifactCompileVersion() throws AzureExecutionException {
        ComparableVersion artifactVersion;
        if (this.getOsEnum() == OperatingSystemEnum.Docker) {
            return;
        }
        ComparableVersion runtimeVersion = new ComparableVersion(this.parsedJavaVersion.toString());
        if (runtimeVersion.compareTo(artifactVersion = new ComparableVersion(Utils.getArtifactCompileVersion((File)this.getArtifactToDeploy()))) < 0) {
            throw new AzureExecutionException(ARTIFACT_INCOMPATIBLE);
        }
    }

    protected void parseConfiguration() {
        this.parsedJavaVersion = FunctionUtils.parseJavaVersion((String)this.getRuntime().getJavaVersion());
    }

    protected void configureAppSettings(Consumer<Map> withAppSettings, Map appSettings) {
        if (appSettings != null && !appSettings.isEmpty()) {
            withAppSettings.accept(appSettings);
        }
    }

    private WebAppBase.Update updateFunctionAppSettings(WebAppBase.Update update) throws AzureExecutionException, AzureAuthFailureException {
        this.validateApplicationInsightsConfiguration();
        Map appSettings = this.getAppSettingsWithDefaultValue();
        if (this.isDisableAppInsights()) {
            update.withoutAppSetting(APPINSIGHTS_INSTRUMENTATION_KEY);
        } else {
            this.bindApplicationInsights(appSettings, false);
        }
        this.configureAppSettings(arg_0 -> ((WebAppBase.Update)update).withAppSettings(arg_0), appSettings);
        return update;
    }

    private File getArtifactToDeploy() throws AzureExecutionException {
        File stagingFolder = new File(this.getDeploymentStagingDirectoryPath());
        return Arrays.stream(stagingFolder.listFiles()).filter(jar -> StringUtils.equals((CharSequence)FilenameUtils.getBaseName((String)jar.getName()), (CharSequence)this.project.getBuild().getFinalName())).findFirst().orElseThrow(() -> new AzureExecutionException("Failed to find function artifact, please re-package the project and try again."));
    }

    private List<FunctionResource> listFunctions() throws AzureExecutionException, AzureAuthFailureException, InterruptedException {
        FunctionApp functionApp = this.getFunctionApp();
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(10000L);
            Log.info((String)String.format(SYNCING_TRIGGERS_AND_FETCH_FUNCTION_INFORMATION, i + 1, 3));
            try {
                functionApp.syncTriggers();
                List<FunctionResource> triggers = this.getAzureClient().appServices().functionApps().listFunctions(this.getResourceGroup(), this.getAppName()).stream().map(envelope -> FunctionResource.parseFunction((FunctionEnvelope)envelope)).filter(function -> function != null).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(triggers)) continue;
                return triggers;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        throw new AzureExecutionException(NO_TRIGGERS_FOUNDED);
    }

    private void bindApplicationInsights(Map appSettings, boolean isCreation) throws AzureExecutionException, AzureAuthFailureException {
        if (appSettings.containsKey(APPINSIGHTS_INSTRUMENTATION_KEY)) {
            return;
        }
        String instrumentationKey = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey())) {
            instrumentationKey = this.getAppInsightsKey();
            if (!Utils.isGUID((String)instrumentationKey)) {
                throw new AzureExecutionException(INSTRUMENTATION_KEY_IS_NOT_VALID);
            }
        } else {
            ApplicationInsightsComponent applicationInsightsComponent = this.getOrCreateApplicationInsights(isCreation);
            String string = instrumentationKey = applicationInsightsComponent == null ? null : applicationInsightsComponent.instrumentationKey();
        }
        if (StringUtils.isNotEmpty((CharSequence)instrumentationKey)) {
            appSettings.put(APPINSIGHTS_INSTRUMENTATION_KEY, instrumentationKey);
        }
    }

    private void validateApplicationInsightsConfiguration() throws AzureExecutionException {
        if (this.isDisableAppInsights() && (StringUtils.isNotEmpty((CharSequence)this.getAppInsightsKey()) || StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()))) {
            throw new AzureExecutionException(APPLICATION_INSIGHTS_CONFIGURATION_CONFLICT);
        }
    }

    private boolean isDeployToSlot() {
        DeploymentSlotSetting slotSetting = this.getDeploymentSlotSetting();
        return slotSetting != null && StringUtils.isNotEmpty((CharSequence)slotSetting.getName());
    }

    private ApplicationInsightsComponent getOrCreateApplicationInsights(boolean enableCreation) throws AzureAuthFailureException {
        AzureTokenWrapper credentials = this.getAzureTokenWrapper();
        if (credentials == null) {
            Log.warn((String)APPLICATION_INSIGHTS_NOT_SUPPORTED);
            return null;
        }
        String subscriptionId = this.getAzureClient().subscriptionId();
        ApplicationInsightsManager applicationInsightsManager = new ApplicationInsightsManager((AzureTokenCredentials)credentials, subscriptionId, this.getUserAgent());
        return StringUtils.isNotEmpty((CharSequence)this.getAppInsightsInstance()) ? this.getApplicationInsights(applicationInsightsManager, this.getAppInsightsInstance()) : (enableCreation ? this.createApplicationInsights(applicationInsightsManager, this.getAppName()) : null);
    }

    private ApplicationInsightsComponent getApplicationInsights(ApplicationInsightsManager applicationInsightsManager, String appInsightsInstance) {
        ApplicationInsightsComponent resource = applicationInsightsManager.getApplicationInsightsInstance(this.getResourceGroup(), appInsightsInstance);
        if (resource == null) {
            Log.warn((String)String.format(FAILED_TO_GET_APPLICATION_INSIGHTS, appInsightsInstance, this.getResourceGroup()));
            return this.createApplicationInsights(applicationInsightsManager, appInsightsInstance);
        }
        return resource;
    }

    private ApplicationInsightsComponent createApplicationInsights(ApplicationInsightsManager applicationInsightsManager, String name) {
        if (this.isDisableAppInsights()) {
            Log.info((String)SKIP_CREATING_APPLICATION_INSIGHTS);
            return null;
        }
        try {
            Log.info((String)APPLICATION_INSIGHTS_CREATE_START);
            ApplicationInsightsComponent resource = applicationInsightsManager.createApplicationInsights(this.getResourceGroup(), name, this.getRegion());
            Log.info((String)String.format(APPLICATION_INSIGHTS_CREATED, resource.name(), resource.id()));
            return resource;
        }
        catch (Exception e) {
            Log.warn((String)String.format(APPLICATION_INSIGHTS_CREATE_FAILED, e.getMessage()));
            return null;
        }
    }
}

