/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gradle.auth;

import com.azure.core.management.AzureEnvironment;
import com.azure.identity.DeviceCodeInfo;
import com.microsoft.azure.gradle.auth.GradleAuthConfig;
import com.microsoft.azure.gradle.temeletry.TelemetryAgent;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.core.devicecode.DeviceCodeAccount;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.auth.model.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.model.AuthType;
import com.microsoft.azure.toolkit.lib.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class GradleAuthHelper {
    protected static final String SUBSCRIPTION_TEMPLATE = "Subscription: %s(%s)";
    private static final String USING_AZURE_ENVIRONMENT = "Using Azure environment: %s.";
    private static final String SUBSCRIPTION_NOT_FOUND = "Subscription %s was not found in current account.";
    private static final String INVALID_AZURE_ENVIRONMENT = "Invalid environment string '%s', please replace it with one of " + AzureEnvironment.knownEnvironments().stream().map(AzureEnvironmentUtils::getCloudNameForAzureCli).collect(Collectors.joining(",")) + ".";

    public static String login(GradleAuthConfig auth, String subscriptionId) {
        try {
            Account account = GradleAuthHelper.login(GradleAuthHelper.toAuthConfiguration((GradleAuthConfig)ObjectUtils.firstNonNull((Object[])new GradleAuthConfig[]{auth, new GradleAuthConfig()})));
            List subscriptions = account.getSubscriptions();
            String targetSubscriptionId = GradleAuthHelper.getTargetSubscriptionId(subscriptionId, subscriptions, account.getSelectedSubscriptions());
            GradleAuthHelper.checkSubscription(subscriptions, targetSubscriptionId);
            ((AzureAccount)Azure.az(AzureAccount.class)).account().selectSubscription(Collections.singletonList(targetSubscriptionId));
            GradleAuthHelper.printCurrentSubscription(account);
            return targetSubscriptionId;
        }
        catch (InvalidConfigurationException e) {
            throw new AzureToolkitAuthenticationException("Failed to authenticate with Azure due to error: " + e.getMessage());
        }
    }

    private static void printCurrentSubscription(Account account) {
        if (account == null || account.getSelectedSubscriptions().isEmpty()) {
            return;
        }
        Subscription subscription = (Subscription)account.getSelectedSubscriptions().get(0);
        if (subscription != null) {
            AzureMessager.getMessager().info(String.format(SUBSCRIPTION_TEMPLATE, subscription.getName(), subscription.getId()));
        }
    }

    private static void checkSubscription(List<Subscription> subscriptions, String targetSubscriptionId) {
        if (StringUtils.isEmpty((CharSequence)targetSubscriptionId)) {
            return;
        }
        Optional<Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.getId(), (CharSequence)targetSubscriptionId)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new AzureToolkitAuthenticationException(String.format(SUBSCRIPTION_NOT_FOUND, targetSubscriptionId));
        }
    }

    private static String getTargetSubscriptionId(String defaultSubscriptionId, List<Subscription> subscriptions, List<Subscription> selectedSubscriptions) {
        String targetSubscriptionId = defaultSubscriptionId;
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && !selectedSubscriptions.isEmpty()) {
            targetSubscriptionId = selectedSubscriptions.stream().filter(Subscription::isSelected).map(Subscription::getId).findFirst().orElse(null);
        }
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && !subscriptions.isEmpty()) {
            targetSubscriptionId = subscriptions.stream().map(Subscription::getId).findFirst().orElse(null);
        }
        TelemetryAgent.getInstance().addDefaultProperty("subscriptionId", targetSubscriptionId);
        return targetSubscriptionId;
    }

    private static Account login(@Nonnull AuthConfiguration auth) {
        GradleAuthHelper.promptAzureEnvironment(auth.getEnvironment());
        Account account = GradleAuthHelper.accountLogin(auth);
        boolean isInteractiveLogin = account.getAuthType() == AuthType.OAUTH2 || account.getAuthType() == AuthType.DEVICE_CODE;
        AzureEnvironment env = account.getEnvironment();
        String environmentName = AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env);
        if (env != AzureEnvironment.AZURE && env != auth.getEnvironment()) {
            AzureMessager.getMessager().info(AzureString.format((String)USING_AZURE_ENVIRONMENT, (Object[])new Object[]{environmentName}));
        }
        GradleAuthHelper.printCredentialDescription(account, isInteractiveLogin);
        TelemetryAgent.getInstance().addDefaultProperty("authType", Objects.toString(auth.getType()));
        TelemetryAgent.getInstance().addDefaultProperty("authMethod", Objects.toString(account.getAuthType()));
        TelemetryAgent.getInstance().addDefaultProperty("azureEnvironment", environmentName);
        return account;
    }

    private static void printCredentialDescription(Account account, boolean skipType) {
        if (skipType) {
            List selectedSubscriptions;
            if (CollectionUtils.isNotEmpty((Collection)account.getSubscriptions()) && (selectedSubscriptions = account.getSelectedSubscriptions()) != null && selectedSubscriptions.size() == 1) {
                AzureMessager.getMessager().info(AzureString.format((String)"Default subscription: %s(%s)", (Object[])new Object[]{((Subscription)selectedSubscriptions.get(0)).getName(), ((Subscription)selectedSubscriptions.get(0)).getId()}));
            }
            if (StringUtils.isNotEmpty((CharSequence)account.getEntity().getEmail())) {
                AzureMessager.getMessager().info(AzureString.format((String)"Username: %s", (Object[])new Object[]{account.getEntity().getEmail()}));
            }
        } else {
            AzureMessager.getMessager().info(account.toString());
        }
    }

    private static void promptAzureEnvironment(AzureEnvironment env) {
        if (env != null && env != AzureEnvironment.AZURE) {
            AzureMessager.getMessager().info(AzureString.format((String)"Auth environment: %s", (Object[])new Object[]{AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env)}));
        }
    }

    private static Account accountLogin(AuthConfiguration auth) {
        if (auth.getEnvironment() != null) {
            ((AzureCloud)Azure.az(AzureCloud.class)).set(auth.getEnvironment());
        }
        if (auth.getType() == null || auth.getType() == AuthType.AUTO) {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{auth.getCertificate(), auth.getCertificatePassword(), auth.getKey()})) {
                Account account = (Account)GradleAuthHelper.findFirstAvailableAccount().block();
                if (account == null) {
                    throw new AzureToolkitAuthenticationException("There are no accounts available.");
                }
                GradleAuthHelper.promptForOAuthOrDeviceCodeLogin(account.getAuthType());
                return GradleAuthHelper.handleDeviceCodeAccount((Account)((AzureAccount)Azure.az(AzureAccount.class)).loginAsync(account, false).block());
            }
            return GradleAuthHelper.doServicePrincipalLogin(auth);
        }
        GradleAuthHelper.promptForOAuthOrDeviceCodeLogin(auth.getType());
        return GradleAuthHelper.handleDeviceCodeAccount((Account)((AzureAccount)Azure.az(AzureAccount.class)).loginAsync(auth, false).block());
    }

    private static Account doServicePrincipalLogin(AuthConfiguration auth) {
        auth.setType(AuthType.SERVICE_PRINCIPAL);
        return ((AzureAccount)Azure.az(AzureAccount.class)).login(auth).account();
    }

    private static Account handleDeviceCodeAccount(Account account) {
        if (account instanceof DeviceCodeAccount) {
            DeviceCodeAccount deviceCodeAccount = (DeviceCodeAccount)account;
            DeviceCodeInfo challenge = deviceCodeAccount.getDeviceCode();
            AzureMessager.getMessager().info(AzureString.format((String)StringUtils.replace((String)challenge.getMessage(), (String)challenge.getUserCode(), (String)"%s"), (Object[])new Object[]{challenge.getUserCode()}));
        }
        return (Account)account.continueLogin().block();
    }

    private static void promptForOAuthOrDeviceCodeLogin(AuthType authType) {
        if (authType == AuthType.OAUTH2 || authType == AuthType.DEVICE_CODE) {
            AzureMessager.getMessager().info(AzureString.format((String)"Auth type: %s", (Object[])new Object[]{authType.toString()}));
        }
    }

    private static Mono<Account> findFirstAvailableAccount() {
        List accounts = ((AzureAccount)Azure.az(AzureAccount.class)).accounts();
        if (accounts.isEmpty()) {
            return Mono.error((Throwable)new AzureToolkitAuthenticationException("There are no accounts available."));
        }
        Mono current = GradleAuthHelper.checkAccountAvailable((Account)accounts.get(0));
        for (int i = 1; i < accounts.size(); ++i) {
            Account ac = (Account)accounts.get(i);
            current = current.onErrorResume(e -> GradleAuthHelper.checkAccountAvailable(ac));
        }
        return current;
    }

    private static Mono<Account> checkAccountAvailable(Account account) {
        return account.checkAvailable().map(avail -> {
            if (avail.booleanValue()) {
                return account;
            }
            throw new AzureToolkitAuthenticationException(String.format("Cannot login with auth type: %s", account.getAuthType()));
        });
    }

    private static AuthConfiguration toAuthConfiguration(GradleAuthConfig gradleAuthConfig) throws InvalidConfigurationException {
        AuthConfiguration authConfiguration = new AuthConfiguration();
        authConfiguration.setClient(gradleAuthConfig.getClient());
        authConfiguration.setTenant(gradleAuthConfig.getTenant());
        authConfiguration.setCertificate(gradleAuthConfig.getCertificate());
        authConfiguration.setCertificatePassword(gradleAuthConfig.getCertificatePassword());
        authConfiguration.setKey(gradleAuthConfig.getKey());
        String authTypeStr = gradleAuthConfig.getType();
        authConfiguration.setType(AuthType.parseAuthType((String)authTypeStr));
        authConfiguration.setEnvironment(AzureEnvironmentUtils.stringToAzureEnvironment((String)gradleAuthConfig.getEnvironment()));
        if (StringUtils.isNotBlank((CharSequence)gradleAuthConfig.getEnvironment()) && Objects.isNull(authConfiguration.getEnvironment())) {
            throw new InvalidConfigurationException(String.format(INVALID_AZURE_ENVIRONMENT, gradleAuthConfig.getEnvironment()));
        }
        return authConfiguration;
    }
}

